/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.model;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jboss.interceptor.InterceptorException;
import org.jboss.interceptor.model.metadata.MethodReference;
import org.jboss.interceptor.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodHolder
implements Serializable {
    private String methodName;
    private Class<?>[] parameterTypes;
    private Class<?> declaringClass;

    public static MethodHolder of(Method method, boolean withDeclaringClass) {
        return new MethodHolder(method, withDeclaringClass);
    }

    public static MethodHolder of(MethodReference method, boolean withDeclaringClass) {
        return new MethodHolder(method.getJavaMethod(), withDeclaringClass);
    }

    private MethodHolder(Method method, boolean withDeclaringClass) {
        this.methodName = method.getName();
        this.parameterTypes = method.getParameterTypes();
        if (withDeclaringClass) {
            this.declaringClass = method.getDeclaringClass();
        }
    }

    private MethodHolder(String methodName, Class<?>[] parameterTypes, Class<?> declaringClass) {
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.declaringClass = declaringClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodHolder that = (MethodHolder)o;
        if (this.declaringClass != null ? !this.declaringClass.equals(that.declaringClass) : that.declaringClass != null) {
            return false;
        }
        if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) {
            return false;
        }
        return Arrays.equals(this.parameterTypes, that.parameterTypes);
    }

    public int hashCode() {
        int result = this.methodName != null ? this.methodName.hashCode() : 0;
        result = 31 * result + (this.parameterTypes != null ? Arrays.hashCode(this.parameterTypes) : 0);
        result = 31 * result + (this.declaringClass != null ? this.declaringClass.hashCode() : 0);
        return result;
    }

    private Object writeReplace() {
        return new MethodHolderSerializationProxy(this);
    }

    static class MethodHolderSerializationProxy
    implements Serializable {
        private String className;
        private String methodName;
        private String[] parameterClassNames;

        MethodHolderSerializationProxy(MethodHolder methodHolder) {
            this.className = methodHolder.declaringClass != null ? methodHolder.declaringClass.getName() : null;
            this.methodName = methodHolder.methodName;
            if (methodHolder.parameterTypes != null) {
                this.parameterClassNames = new String[methodHolder.parameterTypes.length];
                int i = 0;
                for (Class parameterType : methodHolder.parameterTypes) {
                    this.parameterClassNames[i++] = parameterType.getName();
                }
            }
        }

        private Object readResolve() {
            try {
                Class[] parameterTypes = null;
                if (this.parameterClassNames != null) {
                    parameterTypes = new Class[this.parameterClassNames.length];
                    for (int i = 0; i < this.parameterClassNames.length; ++i) {
                        parameterTypes[i] = ReflectionUtils.classForName(this.parameterClassNames[i]);
                    }
                }
                Class<?> declaringClass = null;
                if (this.className != null) {
                    declaringClass = ReflectionUtils.classForName(this.className);
                }
                return new MethodHolder(this.methodName, parameterTypes, declaringClass);
            }
            catch (ClassNotFoundException e) {
                throw new InterceptorException("Error while deserializing intercepted instance", e);
            }
        }
    }
}

