/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpSession;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.context.beanstore.HashMapBeanStore;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.servlet.HttpSessionBeanStore;
import org.jboss.weld.util.collections.EnumerationList;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpPassThruSessionBeanStore
extends HttpSessionBeanStore {
    private static final long serialVersionUID = 8923580660774253915L;
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CONTEXT);
    private HashMapBeanStore delegateBeanStore = new HashMapBeanStore();
    private boolean attachedToSession = false;
    private boolean invalidated = false;

    public HttpPassThruSessionBeanStore() {
        log.trace("New bean store created: " + this);
    }

    @Override
    public void attachToSession(HttpSession session) {
        super.attachToSession(session);
        this.attachedToSession = true;
        this.loadFromSession(session);
    }

    protected void detachFromSession() {
        this.attachedToSession = false;
    }

    public void invalidate() {
        this.detachFromSession();
        this.invalidated = true;
        log.trace("Bean store " + this + " is invalidated");
    }

    public boolean isAttachedToSession() {
        return this.attachedToSession;
    }

    public boolean isInvalidated() {
        return this.invalidated;
    }

    protected void loadFromSession(HttpSession newSession) {
        log.trace("Loading bean store " + this + " map from session " + newSession.getId());
        try {
            for (String id : this.getFilteredAttributeNames()) {
                this.delegateBeanStore.put(id, (ContextualInstance)super.getAttribute(id));
                log.trace("Added contextual " + super.getAttribute(id) + " under ID " + id);
            }
        }
        catch (IllegalStateException e) {
            this.delegateBeanStore.clear();
        }
    }

    @Override
    protected Object getAttribute(String key) {
        return this.delegateBeanStore.get(key);
    }

    @Override
    protected Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.delegateBeanStore.getContextualIds());
    }

    @Override
    protected void removeAttribute(String key) {
        if (this.attachedToSession && !this.isInvalidated()) {
            try {
                super.removeAttribute(key);
            }
            catch (IllegalStateException e) {
                this.invalidate();
            }
        }
        this.delegateBeanStore.delegate().remove(key);
    }

    @Override
    protected void setAttribute(String key, Object instance) {
        if (this.attachedToSession && !this.isInvalidated()) {
            try {
                super.setAttribute(key, instance);
                log.trace("***** Added " + key + " to session " + this.getSession().getId());
            }
            catch (IllegalStateException e) {
                this.invalidate();
            }
        }
        this.delegateBeanStore.put(key, (ContextualInstance)instance);
        log.trace("Added instance for key " + key);
    }

    private List<String> getFilteredAttributeNames() {
        ArrayList<String> attributeNames = new ArrayList<String>();
        NamingScheme namingScheme = this.getNamingScheme();
        try {
            for (String attributeName : new EnumerationList<String>(super.getAttributeNames())) {
                if (!namingScheme.acceptKey(attributeName)) continue;
                attributeNames.add(attributeName);
            }
        }
        catch (IllegalStateException e) {
            this.invalidate();
        }
        return attributeNames;
    }
}

