/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.jboss.interceptor.proxy.LifecycleMixin;
import org.jboss.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.Container;
import org.jboss.weld.bean.proxy.BeanInstance;
import org.jboss.weld.bean.proxy.Proxy;
import org.jboss.weld.bean.proxy.util.ClassloaderClassPath;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SecureReflections;
import org.jboss.weld.util.reflection.instantiation.InstantiatorFactory;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyFactory<T> {
    protected static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    public static final String PROXY_SUFFIX = "Proxy";
    private final Class<?> beanType;
    private final Set<Class<?>> additionalInterfaces = new HashSet();
    private final ClassLoader classLoader;
    private final ProtectionDomain protectionDomain;
    private final ClassPool classPool;
    private final String baseProxyName;

    /*
     * WARNING - void declaration
     */
    public ProxyFactory(Class<?> proxiedBeanType, Set<? extends Type> businessInterfaces) {
        void var4_8;
        Class clazz;
        for (Type type : businessInterfaces) {
            Class c = Reflections.getRawType(type);
            if (!c.isInterface()) continue;
            this.addInterface(c);
        }
        Proxies.TypeInfo typeInfo = Proxies.TypeInfo.of(businessInterfaces);
        Class<?> clazz2 = typeInfo.getSuperClass();
        Class clazz3 = clazz = clazz2 == null ? Object.class : clazz2;
        if (clazz.equals(Object.class)) {
            if (this.additionalInterfaces.isEmpty()) {
                Class<?> clazz4 = proxiedBeanType;
            }
            this.classLoader = Container.instance().services().get(ProxyServices.class).getClassLoader(proxiedBeanType);
        } else {
            this.classLoader = Container.instance().services().get(ProxyServices.class).getClassLoader(clazz);
        }
        this.beanType = var4_8;
        this.protectionDomain = Container.instance().services().get(ProxyServices.class).getProtectionDomain(this.beanType);
        this.classPool = new ClassPool();
        this.classPool.appendClassPath(new ClassloaderClassPath(this.classLoader));
        this.addDefaultAdditionalInterfaces();
        if (proxiedBeanType.equals(Object.class)) {
            Class<?> superInterface = typeInfo.getSuperInterface();
            if (superInterface == null) {
                throw new IllegalArgumentException("Proxied bean type cannot be java.lang.Object without an interface");
            }
            this.baseProxyName = superInterface.getName();
        } else {
            this.baseProxyName = proxiedBeanType.getName();
        }
    }

    public void addInterface(Class<?> newInterface) {
        if (!newInterface.isInterface()) {
            throw new IllegalArgumentException(newInterface + " is not an interface");
        }
        this.additionalInterfaces.add(newInterface);
    }

    public T create(BeanInstance beanInstance) {
        T proxy = null;
        Class<T> proxyClass = this.getProxyClass();
        try {
            proxy = InstantiatorFactory.useInstantiators() ? (T)SecureReflections.newUnsafeInstance(proxyClass) : (T)SecureReflections.newInstance(proxyClass);
        }
        catch (InstantiationException e) {
            throw new DefinitionException(BeanMessage.PROXY_INSTANTIATION_FAILED, (Throwable)e, this);
        }
        catch (IllegalAccessException e) {
            throw new DefinitionException(BeanMessage.PROXY_INSTANTIATION_BEAN_ACCESS_FAILED, (Throwable)e, this);
        }
        ((Proxy)proxy).proxy_setInstance(beanInstance);
        return proxy;
    }

    public Class<T> getProxyClass() {
        String proxyClassName = this.getBaseProxyName() + "_$$_Weld" + this.getProxyNameSuffix();
        if (proxyClassName.startsWith("java")) {
            proxyClassName = proxyClassName.replaceFirst("java", "org.jboss.weld");
        }
        Class<Object> proxyClass = null;
        log.trace("Retrieving/generating proxy class " + proxyClassName);
        try {
            proxyClass = this.classLoader.loadClass(proxyClassName);
        }
        catch (ClassNotFoundException e) {
            try {
                proxyClass = this.createProxyClass(proxyClassName);
            }
            catch (Exception e1) {
                throw new WeldException(e1);
            }
        }
        return proxyClass;
    }

    protected String getBaseProxyName() {
        return this.baseProxyName;
    }

    public static boolean isProxy(Object proxySuspect) {
        return proxySuspect instanceof Proxy;
    }

    public static <T> void setBeanInstance(T proxy, BeanInstance beanInstance) {
        if (proxy instanceof Proxy) {
            Proxy proxyView = (Proxy)proxy;
            proxyView.proxy_setInstance(beanInstance);
        }
    }

    protected String getProxyNameSuffix() {
        return PROXY_SUFFIX;
    }

    private void addDefaultAdditionalInterfaces() {
        this.additionalInterfaces.add(Serializable.class);
    }

    private Class<T> createProxyClass(String proxyClassName) throws Exception {
        ArraySet<Class<TargetInstanceProxy>> specialInterfaces = new ArraySet<Class<TargetInstanceProxy>>(3);
        specialInterfaces.add(Proxy.class);
        specialInterfaces.add(LifecycleMixin.class);
        specialInterfaces.add(TargetInstanceProxy.class);
        this.additionalInterfaces.removeAll(specialInterfaces);
        CtClass instanceType = this.classPool.get(this.beanType.getName());
        CtClass proxyClassType = null;
        if (instanceType.isInterface()) {
            proxyClassType = this.classPool.makeClass(proxyClassName);
            proxyClassType.addInterface(instanceType);
        } else {
            proxyClassType = this.classPool.makeClass(proxyClassName, instanceType);
        }
        for (Class<?> clazz : this.additionalInterfaces) {
            proxyClassType.addInterface(this.classPool.get(clazz.getName()));
        }
        this.addFields(proxyClassType);
        this.addConstructors(proxyClassType);
        this.addMethods(proxyClassType);
        for (Class<Object> clazz : specialInterfaces) {
            proxyClassType.addInterface(this.classPool.get(clazz.getName()));
        }
        Class proxyClass = proxyClassType.toClass(this.classLoader, this.protectionDomain);
        proxyClassType.detach();
        log.trace("Created Proxy class of type " + proxyClass + " supporting interfaces " + Arrays.toString(proxyClass.getInterfaces()));
        return proxyClass;
    }

    protected void addConstructors(CtClass proxyClassType) {
        try {
            CtClass baseType = this.classPool.get(this.beanType.getName());
            if (baseType.isInterface()) {
                proxyClassType.addConstructor(CtNewConstructor.defaultConstructor(proxyClassType));
            } else {
                for (CtConstructor constructor : baseType.getConstructors()) {
                    proxyClassType.addConstructor(CtNewConstructor.make(constructor.getParameterTypes(), constructor.getExceptionTypes(), proxyClassType));
                }
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    protected void addFields(CtClass proxyClassType) {
        try {
            proxyClassType.addField(new CtField(this.classPool.get("org.jboss.weld.bean.proxy.BeanInstance"), "beanInstance", proxyClassType));
            proxyClassType.addField(new CtField(CtClass.booleanType, "firstSerializationPhaseComplete", proxyClassType), "false");
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    private void addMethods(CtClass proxyClassType) {
        this.addMethodsFromClass(proxyClassType);
        this.addSpecialMethods(proxyClassType);
        this.addSerializationSupport(proxyClassType);
    }

    protected void addSerializationSupport(CtClass proxyClassType) {
        try {
            CtClass exception = this.classPool.get(ObjectStreamException.class.getName());
            CtClass objectClass = this.classPool.get(Object.class.getName());
            String writeReplaceBody = "{  if (firstSerializationPhaseComplete) {    firstSerializationPhaseComplete = false;     return $0;  } else { firstSerializationPhaseComplete = true;  return ((org.jboss.weld.serialization.spi.ProxyServices)org.jboss.weld.Container.instance().services().get(org.jboss.weld.serialization.spi.ProxyServices.class)).wrapForSerialization($0); } }";
            proxyClassType.addMethod(CtNewMethod.make(objectClass, "writeReplace", null, new CtClass[]{exception}, writeReplaceBody, proxyClassType));
            CtClass objectInputStreamClass = this.classPool.get(ObjectInputStream.class.getName());
            CtClass cnfe = this.classPool.get(ClassNotFoundException.class.getName());
            CtClass ioe = this.classPool.get(IOException.class.getName());
            String deserializeProxyBody = "{ return $1.readObject(); }";
            proxyClassType.addMethod(CtNewMethod.make(9, objectClass, "deserializeProxy", new CtClass[]{objectInputStreamClass}, new CtClass[]{cnfe, ioe}, deserializeProxyBody, proxyClassType));
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    protected void addMethodsFromClass(CtClass proxyClassType) {
        try {
            for (CtMethod method : proxyClassType.getMethods()) {
                if ((Modifier.isStatic(method.getModifiers()) || method.getDeclaringClass().getName().equals("java.lang.Object")) && !method.getName().equals("toString")) continue;
                log.trace("Adding method " + method.getLongName());
                proxyClassType.addMethod(CtNewMethod.make(method.getReturnType(), method.getName(), method.getParameterTypes(), method.getExceptionTypes(), this.createInterceptorBody(method), proxyClassType));
            }
            CtClass superClass = proxyClassType.getSuperclass();
            while (!superClass.getName().equals("java.lang.Object")) {
                for (CtMethod method : superClass.getDeclaredMethods()) {
                    if (!Modifier.isPrivate(method.getModifiers()) || method.getDeclaringClass().getName().equals("java.lang.Object")) continue;
                    log.trace("Adding method " + method.getLongName());
                    proxyClassType.addMethod(CtNewMethod.make(method.getReturnType(), method.getName(), method.getParameterTypes(), method.getExceptionTypes(), this.createInterceptorBody(method), proxyClassType));
                }
                superClass = superClass.getSuperclass();
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    protected String createInterceptorBody(CtMethod method) throws NotFoundException {
        StringBuilder bodyString = new StringBuilder();
        bodyString.append("{ ");
        try {
            if (method.getReturnType() != null) {
                bodyString.append("return ($r)");
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        bodyString.append("beanInstance.invoke(");
        bodyString.append(method.getDeclaringClass().getName());
        if (Modifier.isPublic(method.getModifiers())) {
            bodyString.append(".class.getMethod(\"");
            log.trace("Using getMethod in proxy for method " + method.getLongName());
        } else {
            bodyString.append(".class.getDeclaredMethod(\"");
            log.trace("Using getDeclaredMethod in proxy for method " + method.getLongName());
        }
        bodyString.append(method.getName());
        bodyString.append("\", ");
        bodyString.append(this.getSignatureClasses(method));
        bodyString.append("), $args); }");
        return bodyString.toString();
    }

    protected String getSignatureClasses(CtMethod method) throws NotFoundException {
        if (method.getParameterTypes().length > 0) {
            StringBuilder signatureBuffer = new StringBuilder();
            signatureBuffer.append("new Class[]{");
            boolean firstClass = true;
            for (CtClass clazz : method.getParameterTypes()) {
                if (firstClass) {
                    firstClass = false;
                } else {
                    signatureBuffer.append(", ");
                }
                signatureBuffer.append(clazz.getName());
                signatureBuffer.append(".class");
            }
            signatureBuffer.append('}');
            return signatureBuffer.toString();
        }
        return "null";
    }

    protected void addSpecialMethods(CtClass proxyClassType) {
        try {
            proxyClassType.addMethod(CtNewMethod.make("public org.jboss.weld.bean.proxy.BeanInstance proxy_getInstance() { return beanInstance; }", proxyClassType));
            proxyClassType.addMethod(CtNewMethod.make("public void proxy_setInstance(org.jboss.weld.bean.proxy.BeanInstance beanInstance) { this.beanInstance = beanInstance; }", proxyClassType));
            CtClass lifecycleMixinClass = this.classPool.get(LifecycleMixin.class.getName());
            for (CtMethod method : lifecycleMixinClass.getDeclaredMethods()) {
                log.trace("Adding method " + method.getLongName());
                proxyClassType.addMethod(CtNewMethod.make(method.getReturnType(), method.getName(), method.getParameterTypes(), method.getExceptionTypes(), this.createSpecialInterfaceBody(method, LifecycleMixin.class), proxyClassType));
            }
            CtClass targetInstanceProxyClass = this.classPool.get(TargetInstanceProxy.class.getName());
            CtMethod getInstanceMethod = targetInstanceProxyClass.getDeclaredMethod("getTargetInstance");
            CtMethod getInstanceClassMethod = targetInstanceProxyClass.getDeclaredMethod("getTargetClass");
            proxyClassType.addMethod(CtNewMethod.make(getInstanceMethod.getReturnType(), getInstanceMethod.getName(), getInstanceMethod.getParameterTypes(), getInstanceMethod.getExceptionTypes(), "{ return beanInstance.getInstance(); }", proxyClassType));
            proxyClassType.addMethod(CtNewMethod.make(getInstanceClassMethod.getReturnType(), getInstanceClassMethod.getName(), getInstanceClassMethod.getParameterTypes(), getInstanceClassMethod.getExceptionTypes(), "{ return beanInstance.getInstanceType(); }", proxyClassType));
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    protected String createSpecialInterfaceBody(CtMethod method, Class<?> interfaceClazz) throws NotFoundException {
        StringBuilder bodyString = new StringBuilder();
        bodyString.append("{ beanInstance.invoke(");
        bodyString.append(interfaceClazz.getName());
        bodyString.append(".class.getDeclaredMethod(\"");
        bodyString.append(method.getName());
        bodyString.append("\", ");
        bodyString.append(this.getSignatureClasses(method));
        bodyString.append("), $args); }");
        return bodyString.toString();
    }

    public ClassPool getClassPool() {
        return this.classPool;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }
}

