/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Set;
import org.jboss.weld.Container;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.jboss.weld.util.collections.ArraySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableProxy
implements Serializable {
    private static final long serialVersionUID = -7682006876407447753L;
    private final String proxyClassName;
    private final String proxySuperClassName;
    private final ArraySet<String> proxyInterfaces;
    private transient Object proxyObject;
    private transient boolean writeProxy;

    public SerializableProxy(Object proxyObject) {
        if (!ProxyFactory.isProxy(proxyObject)) {
            throw new IllegalStateException(BeanMessage.PROXY_REQUIRED, new Object[0]);
        }
        this.proxyClassName = proxyObject.getClass().getName();
        this.proxySuperClassName = proxyObject.getClass().getSuperclass().getName();
        Class<?>[] proxyInterfaceClasses = proxyObject.getClass().getInterfaces();
        this.proxyInterfaces = new ArraySet(proxyInterfaceClasses.length);
        for (int i = 0; i < proxyInterfaceClasses.length; ++i) {
            this.proxyInterfaces.add(proxyInterfaceClasses[i].getName());
        }
        this.proxyInterfaces.add(this.proxySuperClassName);
        this.proxyObject = proxyObject;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeProxy = true;
        out.writeUnshared(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Class<?> proxyBeanType = Container.instance().services().get(ProxyServices.class).loadBeanClass(this.proxySuperClassName);
        ArraySet<Type> proxyBeanInterfaces = this.loadInterfaces();
        Class<?> proxyClass = null;
        proxyClass = this.proxyClassName.endsWith("Proxy") ? this.generateClientProxyClass(proxyBeanType, proxyBeanInterfaces) : Container.instance().services().get(ProxyServices.class).getClassLoader(proxyBeanType).loadClass(this.proxyClassName);
        try {
            this.proxyObject = proxyClass.getDeclaredMethod("deserializeProxy", ObjectInputStream.class).invoke(null, in);
        }
        catch (Exception e) {
            throw new WeldException(BeanMessage.PROXY_DESERIALIZATION_FAILURE, (Throwable)e, new Object[0]);
        }
    }

    private ArraySet<Type> loadInterfaces() throws ClassNotFoundException {
        ProxyServices proxyServices = Container.instance().services().get(ProxyServices.class);
        ArraySet<Type> interfaceClasses = new ArraySet<Type>(this.proxyInterfaces.size());
        for (String interfaceName : this.proxyInterfaces) {
            interfaceClasses.add(proxyServices.loadBeanClass(interfaceName));
        }
        return interfaceClasses;
    }

    Object readResolve() throws ObjectStreamException {
        return this.proxyObject;
    }

    Object writeReplace() throws ObjectStreamException {
        return this.writeProxy ? this.proxyObject : this;
    }

    private <T> Class<?> generateClientProxyClass(Class<T> beanType, Set<Type> interfaces) {
        return new ProxyFactory(beanType, interfaces).getProxyClass();
    }
}

