/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.xml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.weld.logging.messages.XmlMessage;
import org.jboss.weld.manager.EnabledClasses;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.xml.BeansXmlElement;
import org.jboss.weld.xml.MergedElements;
import org.jboss.weld.xml.WeldXmlException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansXmlParser {
    public static final String NAMESPACE = "http://java.sun.com/xml/ns/javaee";
    private final Iterable<URL> beansXmls;
    private final ResourceLoader resourceLoader;

    public BeansXmlParser(ResourceLoader resourceLoader, Iterable<URL> beansXmls) {
        this.beansXmls = beansXmls;
        this.resourceLoader = resourceLoader;
    }

    public EnabledClasses parse() {
        DocumentBuilder documentBuilder = this.createDocumentBuilder();
        MergedElements mergedElements = new MergedElements();
        for (URL beansXml : this.beansXmls) {
            if (!this.isBeansXmlOK(beansXml)) continue;
            Document document = this.loadDocument(documentBuilder, beansXml);
            if (document.getNamespaceURI() == null) {
                mergedElements.merge(beansXml, document, "*");
                continue;
            }
            mergedElements.merge(beansXml, document, NAMESPACE);
        }
        ArrayList enabledAlternativeClasses = new ArrayList();
        ArrayList<Class<? extends Annotation>> enabledAlternativeStereotypes = new ArrayList<Class<? extends Annotation>>();
        ArrayList enabledDecoratorClasses = new ArrayList();
        ArrayList enabledInterceptorClasses = new ArrayList();
        for (BeansXmlElement element : mergedElements.getAlternativesElements()) {
            for (Class<?> clazz : element.getClasses(this.resourceLoader)) {
                if (clazz.isAnnotation()) {
                    enabledAlternativeStereotypes.add(clazz.asSubclass(Annotation.class));
                    continue;
                }
                enabledAlternativeClasses.add(clazz);
            }
        }
        for (BeansXmlElement element : mergedElements.getDecoratorsElements()) {
            enabledDecoratorClasses.addAll(element.getClasses(this.resourceLoader));
        }
        for (BeansXmlElement element : mergedElements.getInterceptorsElements()) {
            enabledInterceptorClasses.addAll(element.getClasses(this.resourceLoader));
        }
        return new EnabledClasses(enabledAlternativeStereotypes, enabledAlternativeClasses, enabledDecoratorClasses, enabledInterceptorClasses);
    }

    private Document loadDocument(DocumentBuilder documentBuilder, URL beansXml) {
        Document document;
        InputStream in = null;
        try {
            in = beansXml.openStream();
            document = documentBuilder.parse(in);
            document.normalize();
        }
        catch (SAXException e) {
            throw new WeldXmlException(XmlMessage.PARSING_ERROR, e, beansXml.toString());
        }
        catch (IOException e) {
            throw new WeldXmlException(XmlMessage.LOAD_ERROR, e, beansXml.toString());
        }
        finally {
            this.closeStream(in);
        }
        return document;
    }

    private void closeStream(InputStream in) {
        if (in == null) {
            return;
        }
        try {
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isBeansXmlOK(URL beansXml) {
        if (beansXml == null) {
            throw new WeldXmlException(XmlMessage.LOAD_ERROR, "URL: null");
        }
        InputStream in = null;
        try {
            in = beansXml.openStream();
            boolean bl = in.available() > 0;
            return bl;
        }
        catch (IOException e) {
            throw new WeldXmlException(XmlMessage.LOAD_ERROR, e, beansXml.toString());
        }
        finally {
            this.closeStream(in);
        }
    }

    private DocumentBuilder createDocumentBuilder() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new WeldXmlException(XmlMessage.CONFIGURATION_ERROR, e);
        }
    }
}

