/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.xml;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.weld.logging.messages.XmlMessage;
import org.jboss.weld.xml.BeansXmlElement;
import org.jboss.weld.xml.WeldXmlException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MergedElements {
    private List<BeansXmlElement> alternativesElements = new ArrayList<BeansXmlElement>();
    private List<BeansXmlElement> decoratorsElements = new ArrayList<BeansXmlElement>();
    private List<BeansXmlElement> interceptorsElements = new ArrayList<BeansXmlElement>();

    public void merge(URL url, Document beansXmlDocument, String namespace) {
        Element documentElement = beansXmlDocument.getDocumentElement();
        this.alternativesElements.addAll(this.findNamedElement(url, documentElement, namespace, "alternatives", XmlMessage.MULTIPLE_ALTERNATIVES));
        this.interceptorsElements.addAll(this.findNamedElement(url, documentElement, namespace, "interceptors", XmlMessage.MULTIPLE_INTERCEPTORS));
        this.decoratorsElements.addAll(this.findNamedElement(url, documentElement, namespace, "decorators", XmlMessage.MULTIPLE_DECORATORS));
    }

    private List<BeansXmlElement> findNamedElement(URL url, Element beans, String namespace, String name, XmlMessage multipleViolationMessage) {
        ArrayList<BeansXmlElement> elements = new ArrayList<BeansXmlElement>();
        NodeList nodeList = beans.getElementsByTagNameNS(namespace, name);
        if (nodeList.getLength() > 1) {
            throw new WeldXmlException(multipleViolationMessage, new Object[0]);
        }
        if (nodeList.getLength() == 1) {
            BeansXmlElement element = new BeansXmlElement(url, (Element)nodeList.item(0));
            elements.add(element);
        }
        return elements;
    }

    public List<BeansXmlElement> getAlternativesElements() {
        return Collections.unmodifiableList(this.alternativesElements);
    }

    public List<BeansXmlElement> getDecoratorsElements() {
        return Collections.unmodifiableList(this.decoratorsElements);
    }

    public List<BeansXmlElement> getInterceptorsElements() {
        return Collections.unmodifiableList(this.interceptorsElements);
    }
}

