/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.registry;

import org.jboss.interceptor.InterceptorException;
import org.jboss.interceptor.model.InterceptorMetadata;
import org.jboss.interceptor.model.metadata.AbstractInterceptorMetadata;
import org.jboss.interceptor.model.metadata.AbstractInterceptorMetadataSerializationProxy;
import org.jboss.interceptor.model.metadata.ClassReference;
import org.jboss.interceptor.model.metadata.ReflectiveClassReference;
import org.jboss.interceptor.registry.ClassMetadataReader;
import org.jboss.interceptor.util.ReflectionUtils;

public class SimpleClassMetadataReader
implements ClassMetadataReader {
    private static SimpleClassMetadataReader instance = new SimpleClassMetadataReader();

    public InterceptorMetadata getInterceptorMetadata(ClassReference clazz, boolean isInterceptorTargetClass) {
        return new AbstractInterceptorMetadata(clazz, isInterceptorTargetClass){

            protected Object createSerializableProxy() {
                return new SimpleInterceptorMetadataSerializationProxy(this.getInterceptorClass().getClassName(), this.isTargetClass());
            }

            private Object writeReplace() {
                return this.createSerializableProxy();
            }
        };
    }

    public static ClassMetadataReader getInstance() {
        return instance;
    }

    private static class SimpleInterceptorMetadataSerializationProxy
    extends AbstractInterceptorMetadataSerializationProxy {
        public SimpleInterceptorMetadataSerializationProxy(String className, boolean targetClass) {
            super(className, targetClass);
        }

        protected InterceptorMetadata loadInterceptorMetadata() throws ClassNotFoundException {
            Class<?> clazz = ReflectionUtils.classForName(this.getClassName());
            return instance.getInterceptorMetadata(ReflectiveClassReference.of(clazz), this.isInterceptionTargetClass());
        }

        private Object readResolve() {
            try {
                return this.loadInterceptorMetadata();
            }
            catch (ClassNotFoundException e) {
                throw new InterceptorException("Failed to deserialize the interceptor class metadata", e);
            }
        }
    }
}

