/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Decorator;
import javax.inject.Inject;
import org.jboss.weld.bean.ForwardingDecorator;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.WeldDecorator;
import org.jboss.weld.bean.proxy.DecoratorProxyFactory;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ProxyClassConstructorInjectionPointWrapper;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.MethodSignature;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldConstructor;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.jlr.WeldConstructorImpl;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.Decorators;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoratorImpl<T>
extends ManagedBean<T>
implements WeldDecorator<T> {
    private WeldClass<?> annotatedDelegateItem;
    private WeldClass<T> proxyClassForAbstractDecorators;
    private WeldConstructor<T> constructorForAbstractDecorator;
    private Set<MethodSignature> decoratedMethodSignatures;
    private WeldInjectionPoint<?, ?> delegateInjectionPoint;
    private Set<Annotation> delegateBindings;
    private Type delegateType;
    private Set<Type> delegateTypes;
    private Set<Type> decoratedTypes;

    public static <T> Decorator<T> wrap(final Decorator<T> decorator) {
        return new ForwardingDecorator<T>(){

            @Override
            public Set<Annotation> getQualifiers() {
                return this.delegate().getDelegateQualifiers();
            }

            @Override
            public Set<Type> getTypes() {
                return this.delegate().getTypes();
            }

            @Override
            protected Decorator<T> delegate() {
                return decorator;
            }
        };
    }

    public static <T> DecoratorImpl<T> of(WeldClass<T> clazz, BeanManagerImpl beanManager) {
        return new DecoratorImpl<T>(clazz, beanManager);
    }

    protected DecoratorImpl(WeldClass<T> type, BeanManagerImpl beanManager) {
        super(type, Decorator.class.getSimpleName() + "-" + type.getName(), beanManager);
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        if (!this.isInitialized()) {
            super.initialize(environment);
            this.initDelegateInjectionPoint();
            this.initDecoratedTypes();
            this.initDelegateBindings();
            this.initDelegateType();
            this.checkDelegateType();
            this.checkAbstractMethods();
        }
    }

    protected void initDecoratedTypes() {
        this.decoratedTypes = new HashSet<Type>();
        this.decoratedTypes.addAll(this.getWeldAnnotated().getInterfaceClosure());
        this.decoratedTypes.remove(Serializable.class);
        this.decoratedMethodSignatures = Decorators.getDecoratedMethodSignatures(this.getBeanManager(), this.decoratedTypes);
    }

    protected void initDelegateInjectionPoint() {
        this.delegateInjectionPoint = this.getDelegateInjectionPoints().iterator().next();
        if (this.getWeldAnnotated().isAbstract()) {
            Class clazz = new DecoratorProxyFactory(this.getWeldAnnotated().getJavaClass(), this.delegateInjectionPoint, this).getProxyClass();
            this.proxyClassForAbstractDecorators = this.beanManager.getServices().get(ClassTransformer.class).loadClass(clazz);
            this.constructorForAbstractDecorator = WeldConstructorImpl.of(this.proxyClassForAbstractDecorators.getDeclaredWeldConstructor(this.getConstructor().getSignature()), this.proxyClassForAbstractDecorators, this.beanManager.getServices().get(ClassTransformer.class));
        }
    }

    @Override
    protected void checkDelegateInjectionPoints() {
        for (WeldInjectionPoint<?, ?> injectionPoint : this.getDelegateInjectionPoints()) {
            if (!(injectionPoint instanceof MethodInjectionPoint) || injectionPoint.isAnnotationPresent(Inject.class)) continue;
            throw new DefinitionException(BeanMessage.DELEGATE_ON_NON_INITIALIZER_METHOD, injectionPoint);
        }
        if (this.getDelegateInjectionPoints().size() == 0) {
            throw new DefinitionException(BeanMessage.NO_DELEGATE_FOR_DECORATOR, this.getWeldAnnotated());
        }
        if (this.getDelegateInjectionPoints().size() > 1) {
            throw new DefinitionException(BeanMessage.TOO_MANY_DELEGATES_FOR_DECORATOR, this.getWeldAnnotated());
        }
    }

    protected void initDelegateBindings() {
        this.delegateBindings = new HashSet<Annotation>();
        this.delegateBindings.addAll(this.delegateInjectionPoint.getQualifiers());
    }

    protected void initDelegateType() {
        this.delegateType = this.delegateInjectionPoint.getBaseType();
        this.delegateTypes = new HashSet<Type>();
        this.delegateTypes.add(this.delegateType);
    }

    protected void checkDelegateType() {
        HashSet<Type> mostSpecificDecoratedTypes = new HashSet<Type>(Arrays.asList(this.getWeldAnnotated().getJavaClass().getGenericInterfaces()));
        mostSpecificDecoratedTypes.remove(Serializable.class);
        for (Type decoratedType : mostSpecificDecoratedTypes) {
            if (decoratedType instanceof Class) {
                if (((Class)decoratedType).isAssignableFrom(this.delegateInjectionPoint.getJavaClass())) continue;
                throw new DefinitionException(BeanMessage.DELEGATE_MUST_SUPPORT_EVERY_DECORATED_TYPE, decoratedType, this);
            }
            if (!(decoratedType instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)decoratedType;
            if (!this.delegateInjectionPoint.isParameterizedType()) {
                throw new DefinitionException(BeanMessage.DECORATED_TYPE_PARAMETERIZED_DELEGATE_NOT, this.delegateType, this);
            }
            if (!Arrays.equals(this.delegateInjectionPoint.getActualTypeArguments(), parameterizedType.getActualTypeArguments())) {
                throw new DefinitionException(BeanMessage.DELEGATE_TYPE_PARAMETER_MISMATCH, decoratedType, this);
            }
            Type rawType = ((ParameterizedType)decoratedType).getRawType();
            if (!(rawType instanceof Class) || ((Class)rawType).isAssignableFrom(this.delegateInjectionPoint.getJavaClass())) continue;
            throw new DefinitionException(BeanMessage.DELEGATE_MUST_SUPPORT_EVERY_DECORATED_TYPE, decoratedType, this);
        }
        this.annotatedDelegateItem = this.beanManager.getServices().get(ClassTransformer.class).loadClass(this.delegateInjectionPoint.getJavaClass());
    }

    private void checkAbstractMethods() {
        if (this.getWeldAnnotated().isAbstract()) {
            for (WeldMethod<?, ?> method : this.getWeldAnnotated().getWeldMethods()) {
                MethodSignature methodSignature;
                if (!Reflections.isAbstract(method.getJavaMember()) || this.annotatedDelegateItem.getWeldMethod(methodSignature = method.getSignature()) != null) continue;
                throw new DefinitionException(BeanMessage.ABSTRACT_METHOD_MUST_MATCH_DECORATED_TYPE, method.getSignature(), this, this.getWeldAnnotated().getName());
            }
        }
    }

    @Override
    public Set<Annotation> getDelegateQualifiers() {
        return this.delegateBindings;
    }

    @Override
    public Type getDelegateType() {
        return this.delegateType;
    }

    @Override
    public Set<Type> getDecoratedTypes() {
        return this.decoratedTypes;
    }

    public WeldInjectionPoint<?, ?> getDelegateInjectionPoint() {
        return this.delegateInjectionPoint;
    }

    @Override
    public void initDecorators() {
    }

    @Override
    protected T createInstance(CreationalContext<T> ctx) {
        if (!this.getWeldAnnotated().isAbstract()) {
            return super.createInstance(ctx);
        }
        ProxyClassConstructorInjectionPointWrapper<T> constructorInjectionPointWrapper = new ProxyClassConstructorInjectionPointWrapper<T>(this, this.constructorForAbstractDecorator, this.getConstructor());
        T instance = constructorInjectionPointWrapper.newInstance(this.beanManager, ctx);
        return instance;
    }

    @Override
    public Set<MethodSignature> getDecoratedMethodSignatures() {
        return this.decoratedMethodSignatures;
    }

    @Override
    public String toString() {
        return "Decorator [" + this.getBeanClass().toString() + "] decorates [" + Formats.formatTypes(this.getDecoratedTypes()) + "] with delegate type [" + Formats.formatType(this.getDelegateType()) + "] and delegate qualifiers [" + Formats.formatAnnotations(this.getDelegateQualifiers()) + "]";
    }
}

