/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.Container;
import org.jboss.weld.bean.proxy.ContextBeanInstance;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.Proxies;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientProxyProvider {
    private static final Function<Bean<Object>, Object> CREATE_CLIENT_PROXY = new Function<Bean<Object>, Object>(){

        @Override
        public Object apply(Bean<Object> from) {
            String id = Container.instance().services().get(ContextualStore.class).putIfAbsent(from);
            if (id == null) {
                throw new DefinitionException(BeanMessage.BEAN_ID_CREATION_FAILED, from);
            }
            return ClientProxyProvider.createClientProxy(from, id);
        }
    };
    private final ConcurrentMap<Bean<Object>, Object> pool = new MapMaker().makeComputingMap(CREATE_CLIENT_PROXY);

    private static <T> T createClientProxy(Bean<T> bean, String id) throws RuntimeException {
        ContextBeanInstance<T> beanInstance = new ContextBeanInstance<T>(bean, id);
        Proxies.TypeInfo typeInfo = Proxies.TypeInfo.of(bean.getTypes());
        return new ProxyFactory(typeInfo.getSuperClass(), bean.getTypes(), bean).create(beanInstance);
    }

    public <T> T getClientProxy(Bean<T> bean) {
        return (T)this.pool.get(bean);
    }

    public String toString() {
        return "Proxy pool with " + this.pool.size() + " proxies";
    }

    public void clear() {
        this.pool.clear();
    }
}

