/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.introspector.MethodSignature;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Decorators {
    public static Set<MethodSignature> getDecoratedMethodSignatures(BeanManagerImpl beanManager, Set<Type> decoratedTypes) {
        HashSet<MethodSignature> methodSignatures = new HashSet<MethodSignature>();
        for (Type type : decoratedTypes) {
            WeldClass<?> weldClass = Decorators.getWeldClassOfDecoratedType(beanManager, type);
            for (WeldMethod<?, ?> method : weldClass.getWeldMethods()) {
                if (methodSignatures.contains(method.getSignature())) continue;
                methodSignatures.add(method.getSignature());
            }
        }
        return methodSignatures;
    }

    public static WeldClass<?> getWeldClassOfDecoratedType(BeanManagerImpl beanManager, Type type) {
        if (type instanceof Class) {
            return (WeldClass)beanManager.createAnnotatedType((Class)type);
        }
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() instanceof Class) {
            return (WeldClass)beanManager.createAnnotatedType((Class)((ParameterizedType)type).getRawType());
        }
        throw new IllegalStateException(BeanMessage.UNABLE_TO_PROCESS, type);
    }
}

