/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.xml;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Filter;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.messages.XmlMessage;
import org.jboss.weld.metadata.BeansXmlImpl;
import org.jboss.weld.metadata.ScanningImpl;
import org.jboss.weld.xml.BeansXmlHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeansXmlParser {
    public BeansXml parse(URL beansXml) {
        XMLReader xmlReader;
        if (beansXml == null) {
            throw new IllegalStateException(XmlMessage.LOAD_ERROR, "unknown");
        }
        try {
            xmlReader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            throw new IllegalStateException(XmlMessage.CONFIGURATION_ERROR, (Throwable)e, new Object[0]);
        }
        try {
            InputSource source = new InputSource(beansXml.openStream());
            if (source.getByteStream().available() == 0) {
                return BeansXml.EMPTY_BEANS_XML;
            }
            BeansXmlHandler handler = new BeansXmlHandler(beansXml);
            xmlReader.setContentHandler(handler);
            xmlReader.setErrorHandler(handler);
            xmlReader.parse(source);
            return handler.createBeansXml();
        }
        catch (IOException e) {
            throw new IllegalStateException(XmlMessage.LOAD_ERROR, (Throwable)e, beansXml);
        }
        catch (SAXException e) {
            throw new IllegalStateException(XmlMessage.PARSING_ERROR, beansXml, e);
        }
    }

    public BeansXml parse(Iterable<URL> urls) {
        ArrayList<Metadata<String>> alternativeStereotypes = new ArrayList<Metadata<String>>();
        ArrayList<Metadata<String>> alternativeClasses = new ArrayList<Metadata<String>>();
        ArrayList<Metadata<String>> decorators = new ArrayList<Metadata<String>>();
        ArrayList<Metadata<String>> interceptors = new ArrayList<Metadata<String>>();
        ArrayList<Metadata<Filter>> includes = new ArrayList<Metadata<Filter>>();
        ArrayList<Metadata<Filter>> excludes = new ArrayList<Metadata<Filter>>();
        for (URL url : urls) {
            BeansXml beansXml = this.parse(url);
            alternativeStereotypes.addAll(beansXml.getEnabledAlternativeStereotypes());
            alternativeClasses.addAll(beansXml.getEnabledAlternativeClasses());
            decorators.addAll(beansXml.getEnabledDecorators());
            interceptors.addAll(beansXml.getEnabledInterceptors());
            includes.addAll(beansXml.getScanning().getIncludes());
            excludes.addAll(beansXml.getScanning().getExcludes());
        }
        return new BeansXmlImpl(alternativeClasses, alternativeStereotypes, decorators, interceptors, new ScanningImpl(includes, excludes));
    }
}

