/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.interceptor.proxy;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.interceptor.InvocationContext;
import org.jboss.interceptor.proxy.InterceptorInvocation;
import org.jboss.interceptor.spi.context.InterceptionChain;
import org.jboss.interceptor.spi.model.InterceptionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleInterceptionChain
implements InterceptionChain {
    private final Logger log = LoggerFactory.getLogger(SimpleInterceptionChain.class);
    private Object target;
    private Method targetMethod;
    private int currentPosition;
    private final InterceptionType interceptionType;
    private List<InterceptorInvocation.InterceptorMethodInvocation> interceptorMethodInvocations;

    public SimpleInterceptionChain(Collection<InterceptorInvocation<?>> interceptorInvocations, InterceptionType interceptionType, Object target, Method targetMethod) {
        this.interceptionType = interceptionType;
        this.target = target;
        this.targetMethod = targetMethod;
        this.currentPosition = 0;
        this.interceptorMethodInvocations = new ArrayList<InterceptorInvocation.InterceptorMethodInvocation>();
        for (InterceptorInvocation<?> interceptorInvocation : interceptorInvocations) {
            this.interceptorMethodInvocations.addAll(interceptorInvocation.getInterceptorMethodInvocations());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invokeNextInterceptor(InvocationContext invocationContext) throws Throwable {
        try {
            if (!this.hasNextInterceptor()) {
                if (this.targetMethod == null) return null;
                this.targetMethod.setAccessible(true);
                return this.targetMethod.invoke(this.target, invocationContext.getParameters());
            }
            int oldCurrentPosition = this.currentPosition;
            try {
                InterceptorInvocation.InterceptorMethodInvocation nextInterceptorMethodInvocation = this.interceptorMethodInvocations.get(this.currentPosition++);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Invoking next interceptor in chain:" + nextInterceptorMethodInvocation.method.toString());
                }
                if (nextInterceptorMethodInvocation.method.getJavaMethod().getParameterTypes().length == 1) {
                    this.validateInterceptor(nextInterceptorMethodInvocation, invocationContext);
                    Object object = nextInterceptorMethodInvocation.invoke(invocationContext);
                    return object;
                }
                if (nextInterceptorMethodInvocation.method.getJavaMethod().getParameterTypes().length != 0) throw new IllegalStateException("Impossible state: interceptor method has more than one argument:" + nextInterceptorMethodInvocation.getMethod());
                this.validateInterceptor(nextInterceptorMethodInvocation, null);
                nextInterceptorMethodInvocation.invoke(null);
                while (this.hasNextInterceptor()) {
                    nextInterceptorMethodInvocation = this.interceptorMethodInvocations.get(this.currentPosition++);
                    this.validateInterceptor(nextInterceptorMethodInvocation, null);
                    nextInterceptorMethodInvocation.invoke(null);
                }
                Object var4_6 = null;
                return var4_6;
            }
            finally {
                this.currentPosition = oldCurrentPosition;
            }
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private void validateInterceptor(InterceptorInvocation.InterceptorMethodInvocation nextInterceptorMethodInvocation, InvocationContext context) {
        int expectedParameters;
        int n = expectedParameters = context == null ? 0 : 1;
        if (nextInterceptorMethodInvocation.method.getJavaMethod().getParameterTypes().length != expectedParameters) {
            throw new IllegalStateException("Mismatch between number of expected and actual parameters on " + nextInterceptorMethodInvocation.getMethod() + ": expected " + expectedParameters + ", actual " + nextInterceptorMethodInvocation.getMethod().getJavaMethod().getParameterTypes().length);
        }
    }

    @Override
    public boolean hasNextInterceptor() {
        return this.currentPosition < this.interceptorMethodInvocations.size();
    }
}

