/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.el;

import java.beans.FeatureDescriptor;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.el.CreationalContextCallable;
import org.jboss.weld.el.ELCreationalContext;
import org.jboss.weld.el.ELCreationalContextStack;
import org.jboss.weld.el.Namespace;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ElMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWeldELResolver
extends ELResolver {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.EL);

    protected abstract BeanManagerImpl getManager(ELContext var1);

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        BeanManagerImpl beanManager = this.getManager(context);
        if (property != null) {
            String name;
            Object value;
            String propertyString = property.toString();
            log.trace(ElMessage.PROPERTY_LOOKUP, propertyString);
            Namespace namespace = null;
            if (base == null) {
                if (beanManager.getRootNamespace().contains(propertyString)) {
                    Namespace value2 = beanManager.getRootNamespace().get(propertyString);
                    context.setPropertyResolved(true);
                    log.trace(ElMessage.PROPERTY_RESOLVED, propertyString, value2);
                    return value2;
                }
            } else if (base instanceof Namespace) {
                namespace = (Namespace)base;
                context.setPropertyResolved(true);
                if (namespace.contains(propertyString)) {
                    Namespace value3 = namespace.get(propertyString);
                    log.trace(ElMessage.PROPERTY_RESOLVED, propertyString, value3);
                    return value3;
                }
            } else {
                return null;
            }
            if ((value = this.lookup(beanManager, context, name = namespace != null ? namespace.qualifyName(propertyString) : propertyString)) != null) {
                context.setPropertyResolved(true);
                log.trace(ElMessage.PROPERTY_RESOLVED, propertyString, value);
                return value;
            }
        }
        return null;
    }

    private Object lookup(BeanManagerImpl beanManager, ELContext context, String name) {
        String beanName;
        Bean bean = beanManager.resolve(beanManager.getBeans(name));
        if (bean == null) {
            return null;
        }
        Class<Annotation> scope = bean.getScope();
        if (!scope.equals(Dependent.class)) {
            Object value = beanManager.getContext(scope).get(bean);
            if (value != null) {
                return value;
            }
            return beanManager.getReference(bean, beanManager.createCreationalContext((Contextual)bean), false);
        }
        ELCreationalContext<?> creationalContext = ((CreationalContextCallable)ELCreationalContextStack.getCreationalContextStore(context).peek()).get();
        Object value = creationalContext.getDependentInstanceForExpression(beanName = bean.getName());
        if (value == null) {
            value = this.getManager(context).getReference(bean, creationalContext, false);
            creationalContext.registerDependentInstanceForExpression(beanName, value);
        }
        return value;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return false;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
    }
}

