/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jboss.weld.Container;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.serialization.spi.ContextualStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableProxy
implements Serializable {
    private static final long serialVersionUID = -7682006876407447753L;
    private final String proxyClassName;
    private final String beanId;
    private transient Object proxyObject;
    private transient boolean writeProxy;

    public SerializableProxy(Object proxyObject, Bean<?> bean) {
        if (!ProxyFactory.isProxy(proxyObject)) {
            throw new IllegalStateException(BeanMessage.PROXY_REQUIRED, new Object[0]);
        }
        if (!(bean instanceof PassivationCapable)) {
            throw new WeldException(BeanMessage.BEAN_NOT_PASIVATION_CAPABLE_IN_SERIALIZATION, bean);
        }
        this.beanId = ((PassivationCapable)((Object)bean)).getId();
        this.proxyObject = proxyObject;
        this.proxyClassName = proxyObject.getClass().getName();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeProxy = true;
        out.writeUnshared(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Bean bean = (Bean)Container.instance().services().get(ContextualStore.class).getContextual(this.beanId);
        if (this.proxyClassName.endsWith("ClientProxy")) {
            this.proxyObject = Container.instance().deploymentManager().getClientProxyProvider().getClientProxy(bean);
        } else {
            Class<?> proxyClass = ProxyFactory.resolveClassLoaderForBeanProxy(bean).loadClass(this.proxyClassName);
            try {
                this.proxyObject = proxyClass.getDeclaredMethod("deserializeProxy", ObjectInputStream.class).invoke(null, in);
            }
            catch (Exception e) {
                throw new WeldException(BeanMessage.PROXY_DESERIALIZATION_FAILURE, (Throwable)e, new Object[0]);
            }
        }
    }

    Object readResolve() throws ObjectStreamException {
        return this.proxyObject;
    }

    Object writeReplace() throws ObjectStreamException {
        return this.writeProxy ? this.proxyObject : this;
    }
}

