/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import javax.enterprise.context.spi.Contextual;
import org.jboss.weld.Container;
import org.jboss.weld.context.ForwardingContextual;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableContextualImpl<C extends Contextual<I>, I>
extends ForwardingContextual<I>
implements SerializableContextual<C, I> {
    private static final long serialVersionUID = 9161034819867283482L;
    private C serialiazable;
    @SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="A cache which is lazily loaded")
    private transient C cached;
    private String id;
    private transient ContextualStore cachedContextualStore;

    @Override
    protected Contextual<I> delegate() {
        return this.get();
    }

    private SerializableContextualImpl() {
    }

    public SerializableContextualImpl(C contextual, ContextualStore contextualStore) {
        this.cachedContextualStore = contextualStore;
        if (contextual instanceof Serializable) {
            this.serialiazable = contextual;
        } else {
            this.id = contextualStore.putIfAbsent((Contextual<?>)contextual);
        }
        this.cached = contextual;
    }

    private ContextualStore getContextualStore() {
        if (this.cachedContextualStore == null) {
            this.cachedContextualStore = Container.instance().services().get(ContextualStore.class);
        }
        return this.cachedContextualStore;
    }

    @Override
    public C get() {
        if (this.cached == null) {
            this.loadContextual();
        }
        return this.cached;
    }

    private void loadContextual() {
        if (this.serialiazable != null) {
            this.cached = this.serialiazable;
        } else if (this.id != null) {
            this.cached = this.getContextualStore().getContextual(this.id);
        }
        if (this.cached == null) {
            throw new IllegalStateException("Error restoring serialized contextual with id " + this.id);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SerializableContextualImpl) {
            return this.delegate().equals(((SerializableContextualImpl)obj).get());
        }
        return this.delegate().equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }
}

