/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.introspector.jlr;

import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.introspector.TypeClosureLazyValueHolder;
import org.jboss.weld.introspector.WeldAnnotation;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.jlr.WeldClassImpl;
import org.jboss.weld.introspector.jlr.WeldMethodImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.collections.HashSetSupplier;
import org.jboss.weld.util.reflection.SecureReflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeldAnnotationImpl<T extends Annotation>
extends WeldClassImpl<T>
implements WeldAnnotation<T> {
    private final SetMultimap<Class<? extends Annotation>, WeldMethod<?, ?>> annotatedMembers;
    private final Class<T> clazz;
    private final Set<WeldMethod<?, ?>> members;

    public static <A extends Annotation> WeldAnnotation<A> create(Class<A> annotationType, ClassTransformer classTransformer) {
        HashMap<Class<? extends Annotation>, Annotation> annotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        annotationMap.putAll(WeldAnnotationImpl.buildAnnotationMap(annotationType.getAnnotations()));
        annotationMap.putAll(WeldAnnotationImpl.buildAnnotationMap(classTransformer.getTypeStore().get(annotationType)));
        HashMap<Class<? extends Annotation>, Annotation> declaredAnnotationMap = new HashMap<Class<? extends Annotation>, Annotation>();
        declaredAnnotationMap.putAll(WeldAnnotationImpl.buildAnnotationMap(annotationType.getDeclaredAnnotations()));
        declaredAnnotationMap.putAll(WeldAnnotationImpl.buildAnnotationMap(classTransformer.getTypeStore().get(annotationType)));
        return new WeldAnnotationImpl<A>(annotationType, annotationMap, declaredAnnotationMap, classTransformer);
    }

    protected WeldAnnotationImpl(Class<T> annotationType, Map<Class<? extends Annotation>, Annotation> annotationMap, Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap, ClassTransformer classTransformer) {
        super(annotationType, annotationType, null, new TypeClosureLazyValueHolder(annotationType), annotationMap, declaredAnnotationMap, classTransformer);
        this.clazz = annotationType;
        this.members = new HashSet();
        this.annotatedMembers = Multimaps.newSetMultimap(new HashMap(), HashSetSupplier.instance());
        for (Method member : SecureReflections.getDeclaredMethods(this.clazz)) {
            WeldMethodImpl annotatedMethod = WeldMethodImpl.of(member, this, classTransformer);
            this.members.add(annotatedMethod);
            for (Annotation annotation : annotatedMethod.getAnnotations()) {
                this.annotatedMembers.put(annotation.annotationType(), annotatedMethod);
            }
        }
    }

    @Override
    public Set<WeldMethod<?, ?>> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    @Override
    public Set<WeldMethod<?, ?>> getMembers(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableSet(this.annotatedMembers.get(annotationType));
    }

    @Override
    public String toString() {
        return this.getJavaClass().toString();
    }

    @Override
    public Class<T> getDelegate() {
        return this.clazz;
    }
}

