/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.util.Set;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.ForwardingResolvable;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.TypeSafeResolver;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Reflections;

public class TypeSafeDisposerResolver
extends TypeSafeResolver<Resolvable, DisposalMethod<?, ?>> {
    private final BeanManagerImpl manager;

    public TypeSafeDisposerResolver(BeanManagerImpl manager, Iterable<DisposalMethod<?, ?>> disposers) {
        super(disposers, manager);
        this.manager = manager;
    }

    @Override
    protected boolean matches(Resolvable resolvable, DisposalMethod<?, ?> disposer) {
        return resolvable.getDeclaringBean().equals(disposer.getDeclaringBean()) && Reflections.isAssignableFrom(disposer.getType(), resolvable.getTypes()) && Beans.containsAllQualifiers(QualifierInstance.qualifiers(this.getBeanManager(), disposer), resolvable.getQualifiers(), this.manager);
    }

    @Override
    protected Resolvable wrap(final Resolvable resolvable) {
        return new ForwardingResolvable(){

            @Override
            protected Resolvable delegate() {
                return resolvable;
            }

            @Override
            public boolean equals(Object o) {
                if (o instanceof Resolvable && super.equals(o)) {
                    Resolvable r = (Resolvable)o;
                    return r.getDeclaringBean().equals(this.getDeclaringBean());
                }
                return false;
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + this.getDeclaringBean().hashCode();
            }
        };
    }

    public BeanManagerImpl getManager() {
        return this.manager;
    }

    @Override
    protected Set<DisposalMethod<?, ?>> filterResult(Set<DisposalMethod<?, ?>> matched) {
        return matched;
    }

    @Override
    protected Set<DisposalMethod<?, ?>> sortResult(Set<DisposalMethod<?, ?>> matched) {
        return matched;
    }
}

