/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.servlet;

import java.lang.annotation.Annotation;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionEvent;
import org.jboss.weld.Container;
import org.jboss.weld.context.cache.RequestScopedBeanCache;
import org.jboss.weld.context.http.HttpConversationContext;
import org.jboss.weld.context.http.HttpRequestContext;
import org.jboss.weld.context.http.HttpSessionContext;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.ServletMessage;
import org.jboss.weld.servlet.api.helpers.AbstractServletListener;
import org.slf4j.cal10n.LocLogger;

public class WeldListener
extends AbstractServletListener {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.SERVLET);
    private transient HttpSessionContext sessionContextCache;
    private transient HttpRequestContext requestContextCache;
    private transient HttpConversationContext conversationContextCache;

    private HttpSessionContext sessionContext() {
        if (this.sessionContextCache == null) {
            this.sessionContextCache = (HttpSessionContext)Container.instance().deploymentManager().instance().select(HttpSessionContext.class, new Annotation[0]).get();
        }
        return this.sessionContextCache;
    }

    private HttpRequestContext requestContext() {
        if (this.requestContextCache == null) {
            this.requestContextCache = (HttpRequestContext)Container.instance().deploymentManager().instance().select(HttpRequestContext.class, new Annotation[0]).get();
        }
        return this.requestContextCache;
    }

    private HttpConversationContext conversationContext() {
        if (this.conversationContextCache == null) {
            this.conversationContextCache = (HttpConversationContext)Container.instance().deploymentManager().instance().select(HttpConversationContext.class, new Annotation[0]).get();
        }
        return this.conversationContextCache;
    }

    @Override
    public void sessionDestroyed(HttpSessionEvent event) {
        if (Container.available()) {
            this.sessionContext().destroy(event.getSession());
            RequestScopedBeanCache.endRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void requestDestroyed(ServletRequestEvent event) {
        log.trace(ServletMessage.REQUEST_DESTROYED, event.getServletRequest());
        if (!Container.available()) return;
        if (!(event.getServletRequest() instanceof HttpServletRequest)) throw new IllegalStateException(ServletMessage.ONLY_HTTP_SERVLET_LIFECYCLE_DEFINED, new Object[0]);
        HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
        try {
            this.requestContext().invalidate();
            this.requestContext().deactivate();
            this.sessionContext().deactivate();
            if (!this.conversationContext().isActive()) return;
            this.conversationContext().deactivate();
            return;
        }
        finally {
            this.requestContext().dissociate(request);
            this.sessionContext().dissociate(request);
            this.conversationContext().dissociate(request);
        }
    }

    @Override
    public void requestInitialized(ServletRequestEvent event) {
        log.trace(ServletMessage.REQUEST_INITIALIZED, event.getServletRequest());
        if (Container.available()) {
            if (event.getServletRequest() instanceof HttpServletRequest) {
                HttpServletRequest request = (HttpServletRequest)event.getServletRequest();
                this.requestContext().associate(request);
                this.sessionContext().associate(request);
                this.conversationContext().associate(request);
                this.requestContext().activate();
                this.sessionContext().activate();
            } else {
                throw new IllegalStateException(ServletMessage.ONLY_HTTP_SERVLET_LIFECYCLE_DEFINED, new Object[0]);
            }
        }
    }
}

