/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.reflection;

import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedActionException;

abstract class SecureReflectionAccess<T> {
    SecureReflectionAccess() {
    }

    public T run() throws Exception {
        return this.work();
    }

    public T runAndWrap() {
        try {
            return this.run();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public T runAsFieldAccess() throws NoSuchFieldException {
        try {
            return this.run();
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof NoSuchFieldException) {
                throw (NoSuchFieldException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public T runAsMethodAccess() throws NoSuchMethodException {
        try {
            return this.run();
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public T runAsInvocation() throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        try {
            return this.run();
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof IllegalAccessException) {
                throw (IllegalAccessException)e.getCause();
            }
            if (e.getCause() instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e.getCause();
            }
            if (e.getCause() instanceof InvocationTargetException) {
                throw (InvocationTargetException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public T runAsInstantiation() throws InstantiationException, IllegalAccessException {
        try {
            return this.run();
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof InstantiationException) {
                throw (InstantiationException)e.getCause();
            }
            if (e.getCause() instanceof IllegalAccessException) {
                throw (IllegalAccessException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract T work() throws Exception;
}

