/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyorException;
import ch.qos.cal10n.MessageParameterObj;
import ch.qos.cal10n.util.AnnotationExtractor;
import ch.qos.cal10n.util.CAL10NResourceBundle;
import ch.qos.cal10n.util.CAL10NResourceBundleFinder;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageConveyor
implements IMessageConveyor {
    final Locale locale;
    final Map<String, CAL10NResourceBundle> cache = new ConcurrentHashMap<String, CAL10NResourceBundle>();

    public MessageConveyor(Locale locale) {
        this.locale = locale;
    }

    @Override
    public <E extends Enum<?>> String getMessage(E key, Object ... args) throws MessageConveyorException {
        String keyAsStr;
        String value;
        String declararingClassName = key.getDeclaringClass().getName();
        CAL10NResourceBundle rb = this.cache.get(declararingClassName);
        if (rb == null || rb.hasChanged()) {
            rb = this.lookup(key);
            this.cache.put(declararingClassName, rb);
        }
        if ((value = rb.getString(keyAsStr = key.toString())) == null) {
            return "No key found for " + keyAsStr;
        }
        if (args == null || args.length == 0) {
            return value;
        }
        return MessageFormat.format(value, args);
    }

    private <E extends Enum<?>> CAL10NResourceBundle lookup(E key) throws MessageConveyorException {
        Class<?> declaringClass = key.getDeclaringClass();
        String baseName = AnnotationExtractor.getBaseName(key.getDeclaringClass());
        if (baseName == null) {
            throw new MessageConveyorException("Missing @BaseName annotation in enum type [" + key.getClass().getName() + "]. See also " + "http://cal10n.qos.ch/codes.html#missingBaseNameAnnotation");
        }
        String charset = AnnotationExtractor.getCharset(declaringClass, this.locale);
        CAL10NResourceBundle rb = CAL10NResourceBundleFinder.getBundle(declaringClass.getClassLoader(), baseName, this.locale, charset);
        if (rb == null) {
            throw new MessageConveyorException("Failed to locate resource bundle [" + baseName + "] for locale [" + this.locale + "] for enum type [" + key.getDeclaringClass().getName() + "]");
        }
        return rb;
    }

    @Override
    public String getMessage(MessageParameterObj mpo) throws MessageConveyorException {
        if (mpo == null) {
            throw new IllegalArgumentException("MessageParameterObj argumument cannot be null");
        }
        return this.getMessage(mpo.getKey(), mpo.getArgs());
    }
}

