/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.reflection;

import java.beans.Introspector;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Qualifier;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.reflection.HierarchyDiscovery;
import org.slf4j.cal10n.LocLogger;
import org.slf4j.ext.XLogger;

public class Reflections {
    static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.UTIL);
    static final XLogger xLog = LoggerFactory.loggerFactory().getXLogger(Category.UTIL);
    public static final Type[] EMPTY_TYPES = new Type[0];
    public static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    public static final Class<?>[] EMPTY_CLASSES = new Class[0];

    public static Map<Class<?>, Type> buildTypeMap(Set<Type> types) {
        HashMap map = new HashMap();
        for (Type type : types) {
            Class clazz = Reflections.getRawType(type);
            if (clazz == null) continue;
            map.put(clazz, type);
        }
        return map;
    }

    public static boolean isCacheable(Set<Annotation> annotations) {
        for (Annotation qualifier : annotations) {
            Class<?> clazz = qualifier.getClass();
            if (!clazz.isAnonymousClass() && (!clazz.isMemberClass() || !Reflections.isStatic(clazz))) continue;
            return false;
        }
        return true;
    }

    public static boolean isCacheable(Annotation[] annotations) {
        for (Annotation qualifier : annotations) {
            Class<?> clazz = qualifier.getClass();
            if (!clazz.isAnonymousClass() && (!clazz.isMemberClass() || !Reflections.isStatic(clazz))) continue;
            return false;
        }
        return true;
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static String getPropertyName(Method method) {
        String methodName = method.getName();
        if (methodName.matches("^(get).*")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.matches("^(is).*")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        return null;
    }

    public static boolean isFinal(Class<?> clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    public static int getNesting(Class<?> clazz) {
        if (Reflections.isNonStaticInnerClass(clazz)) {
            return 1 + Reflections.getNesting(clazz.getDeclaringClass());
        }
        return 0;
    }

    public static boolean isNonStaticInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !Reflections.isStatic(clazz);
    }

    public static boolean isFinal(Member member) {
        return Modifier.isFinal(member.getModifiers());
    }

    public static boolean isPrivate(Member member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    public static boolean isTypeOrAnyMethodFinal(Class<?> type) {
        return Reflections.getNonPrivateFinalMethodOrType(type) != null;
    }

    public static Object getNonPrivateFinalMethodOrType(Class<?> type) {
        if (Reflections.isFinal(type)) {
            return type;
        }
        for (Method method : type.getDeclaredMethods()) {
            if (!Reflections.isFinal(method) || Reflections.isPrivate(method)) continue;
            return method;
        }
        return null;
    }

    public static boolean isPackagePrivate(int mod) {
        return !Modifier.isPrivate(mod) && !Modifier.isProtected(mod) && !Modifier.isPublic(mod);
    }

    public static boolean isStatic(Class<?> type) {
        return Modifier.isStatic(type.getModifiers());
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public static boolean isTransient(Member member) {
        return Modifier.isTransient(member.getModifiers());
    }

    public static boolean isAbstract(Method method) {
        return Modifier.isAbstract(method.getModifiers());
    }

    public static Type[] getActualTypeArguments(Type type) {
        Type resolvedType = new HierarchyDiscovery(type).getResolvedType();
        if (resolvedType instanceof ParameterizedType) {
            return ((ParameterizedType)resolvedType).getActualTypeArguments();
        }
        return EMPTY_TYPES;
    }

    public static boolean isArrayType(Class<?> rawType) {
        return rawType.isArray();
    }

    public static boolean isParameterizedType(Class<?> type) {
        return type.getTypeParameters().length > 0;
    }

    public static boolean isParamerterizedTypeWithWildcard(Class<?> type) {
        return Reflections.isParameterizedType(type) && Reflections.containsWildcards(type.getTypeParameters());
    }

    public static boolean containsWildcards(Type[] types) {
        for (Type type : types) {
            if (!(type instanceof WildcardType)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isBindings(Annotation binding) {
        boolean isBindingAnnotation = false;
        if (binding.annotationType().isAnnotationPresent(Qualifier.class) && binding.annotationType().isAnnotationPresent(Retention.class) && binding.annotationType().getAnnotation(Retention.class).value().equals((Object)RetentionPolicy.RUNTIME)) {
            isBindingAnnotation = true;
        }
        return isBindingAnnotation;
    }

    public static boolean isAssignableFrom(Type type1, Set<? extends Type> types2) {
        for (Type type : types2) {
            if (!Reflections.isAssignableFrom(type1, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(Type requiredType, Set<? extends Type> beanTypes) {
        for (Type type : beanTypes) {
            if (!Reflections.matches(requiredType, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableTo(Type type1, Type[] types2) {
        return Reflections.isAssignableFrom(types2, type1);
    }

    public static boolean isAssignableFrom(Type type1, Type[] types2) {
        for (Type type2 : types2) {
            if (!Reflections.isAssignableFrom(type1, type2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Type type1, Type type2) {
        TypeHolder typeHolder1 = TypeHolder.wrap(type1);
        if (typeHolder1 != null && typeHolder1.isAssignableFrom(type2)) {
            return true;
        }
        return Reflections.processWildcardTypesAndTypeVariables(type1, type2);
    }

    public static boolean matches(Type requiredType, Type beanType) {
        TypeHolder requiredTypeHolder = TypeHolder.wrap(requiredType);
        if (requiredTypeHolder != null && requiredTypeHolder.matches(beanType)) {
            return true;
        }
        return Reflections.processWildcardTypesAndTypeVariables(requiredType, beanType);
    }

    private static boolean processWildcardTypesAndTypeVariables(Type requiredType, Type beanType) {
        TypeVariable typeVariable;
        WildcardType wildcardType;
        if (requiredType instanceof WildcardType && Reflections.isTypeInsideBounds(beanType, (wildcardType = (WildcardType)requiredType).getLowerBounds(), wildcardType.getUpperBounds())) {
            return true;
        }
        if (beanType instanceof WildcardType && Reflections.isTypeInsideBounds(requiredType, (wildcardType = (WildcardType)beanType).getUpperBounds(), wildcardType.getLowerBounds())) {
            return true;
        }
        if (requiredType instanceof TypeVariable && Reflections.isTypeInsideBounds(beanType, EMPTY_TYPES, (typeVariable = (TypeVariable)requiredType).getBounds())) {
            return true;
        }
        return beanType instanceof TypeVariable && Reflections.isTypeInsideBounds(requiredType, (typeVariable = (TypeVariable)beanType).getBounds(), EMPTY_TYPES);
    }

    public static boolean isTypeInsideBounds(Type type, Type[] lowerBounds, Type[] upperBounds) {
        return !(lowerBounds.length != 0 && !Reflections.isAssignableFrom(type, lowerBounds) || upperBounds.length != 0 && !Reflections.isAssignableTo(type, upperBounds));
    }

    public static boolean isAssignableFrom(Set<Type> types1, Set<Type> types2) {
        for (Type type : types1) {
            if (!Reflections.isAssignableFrom(type, types2)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(Set<Type> requiredTypes, Set<Type> beanTypes) {
        for (Type requiredType : requiredTypes) {
            if (!Reflections.matches(requiredType, beanTypes)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Set<Type> types1, Type type2) {
        for (Type type : types1) {
            if (!Reflections.isAssignableFrom(type, type2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Type[] types1, Type type2) {
        for (Type type : types1) {
            if (!Reflections.isAssignableFrom(type, type2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSerializable(Class<?> clazz) {
        return clazz.isPrimitive() || Serializable.class.isAssignableFrom(clazz);
    }

    public static boolean isPrimitive(Type type) {
        Class rawType = Reflections.getRawType(type);
        return rawType != null && rawType.isPrimitive();
    }

    public static <T> Class<T> getRawType(Type type) {
        GenericArrayType arrayType;
        Class<T> rawComponentType;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            if (((ParameterizedType)type).getRawType() instanceof Class) {
                return (Class)((ParameterizedType)type).getRawType();
            }
        } else if (type instanceof GenericArrayType && (rawComponentType = Reflections.getRawType((arrayType = (GenericArrayType)type).getGenericComponentType())) != null) {
            return Array.newInstance(rawComponentType, 0).getClass();
        }
        return null;
    }

    public static boolean isClassLoadable(String className, ResourceLoader resourceLoader) {
        try {
            resourceLoader.classForName(className);
            return true;
        }
        catch (ResourceLoadingException e) {
            return false;
        }
    }

    private static class TypeHolder {
        private Class<?> rawType;
        private Type[] actualTypeArguments;

        private TypeHolder(Class<?> rawType, Type[] actualTypeArguments) {
            this.rawType = rawType;
            this.actualTypeArguments = actualTypeArguments;
        }

        public Class<?> getRawType() {
            return this.rawType;
        }

        public Type[] getActualTypeArguments() {
            return this.actualTypeArguments;
        }

        private Class<?> getBoxedRawType() {
            return Types.boxedClass(this.getRawType());
        }

        private boolean isAssignableFrom(Type otherType) {
            TypeHolder otherTypeHolder = TypeHolder.wrap(otherType);
            if (otherTypeHolder != null) {
                return this.isAssignableFrom(otherTypeHolder);
            }
            if (otherType instanceof TypeVariable) {
                TypeVariable typeVariable = (TypeVariable)otherType;
                if (Reflections.isTypeInsideBounds(this.getRawType(), EMPTY_TYPES, typeVariable.getBounds())) {
                    return true;
                }
            }
            return false;
        }

        public boolean isAssignableFrom(TypeHolder otherTypeHolder) {
            return this.getBoxedRawType().isAssignableFrom(otherTypeHolder.getBoxedRawType()) && this.areActualTypeArgumentsAssignableFrom(otherTypeHolder.getActualTypeArguments());
        }

        private boolean matches(Type otherType) {
            TypeHolder otherTypeHolder = TypeHolder.wrap(otherType);
            return otherTypeHolder != null && this.matches(otherTypeHolder);
        }

        public boolean matches(TypeHolder otherTypeHolder) {
            return this.getBoxedRawType().equals(otherTypeHolder.getBoxedRawType()) && this.areActualTypeArgumentsAssignableFrom(otherTypeHolder.getActualTypeArguments());
        }

        private boolean areActualTypeArgumentsAssignableFrom(Type[] otherActualTypeArguments) {
            for (int i = 0; i < this.getActualTypeArguments().length; ++i) {
                Class<Object> type2;
                Type type1 = this.getActualTypeArguments()[i];
                Class<Object> clazz = type2 = otherActualTypeArguments.length > i ? otherActualTypeArguments[i] : Object.class;
                if (Reflections.isAssignableFrom(type1, type2)) continue;
                return false;
            }
            return true;
        }

        private static TypeHolder wrap(Type type) {
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Type rawType = parameterizedType.getRawType();
                if (rawType instanceof Class) {
                    Class clazz = (Class)rawType;
                    return new TypeHolder(clazz, parameterizedType.getActualTypeArguments());
                }
            } else {
                GenericArrayType arrayType;
                Type genericComponentType;
                Class rawComponentType;
                if (type instanceof Class) {
                    Class clazz = (Class)type;
                    return new TypeHolder(clazz, EMPTY_TYPES);
                }
                if (type instanceof GenericArrayType && (rawComponentType = Reflections.getRawType(genericComponentType = (arrayType = (GenericArrayType)type).getGenericComponentType())) != null) {
                    Class<?> arrayClass = Array.newInstance(rawComponentType, 0).getClass();
                    return new TypeHolder(arrayClass, Reflections.getActualTypeArguments(genericComponentType));
                }
            }
            return null;
        }
    }
}

