/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.event.TransactionalObserverNotifier;
import org.jboss.weld.literal.AnyLiteral;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.ResolvableBuilder;
import org.jboss.weld.resolution.TypeSafeObserverResolver;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.transaction.spi.TransactionServices;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.reflection.Reflections;

public class ObserverNotifier {
    private final TypeSafeObserverResolver resolver;
    private final SharedObjectCache sharedObjectCache;
    private final MetaAnnotationStore store;

    public static ObserverNotifier of(TypeSafeObserverResolver resolver, ServiceRegistry services) {
        if (services.contains(TransactionServices.class)) {
            return new TransactionalObserverNotifier(resolver, services);
        }
        return new ObserverNotifier(resolver, services);
    }

    protected ObserverNotifier(TypeSafeObserverResolver resolver, ServiceRegistry services) {
        this.resolver = resolver;
        this.sharedObjectCache = services.get(SharedObjectCache.class);
        this.store = services.get(MetaAnnotationStore.class);
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, Annotation ... bindings) {
        Observers.checkEventObjectType(this.sharedObjectCache, event);
        return this.resolveObserverMethods((Type)event.getClass(), bindings);
    }

    public void fireEvent(Object event, Annotation ... qualifiers) {
        this.fireEvent(event.getClass(), event, qualifiers);
    }

    public void fireEvent(Type eventType, Object event, Annotation ... qualifiers) {
        Observers.checkEventObjectType(this.sharedObjectCache, event);
        this.notifyObservers(event, this.resolveObserverMethods(eventType, qualifiers));
    }

    public void fireEvent(Type eventType, Object event, Set<Annotation> qualifiers) {
        Observers.checkEventObjectType(this.sharedObjectCache, event);
        this.notifyObservers(event, this.resolveObserverMethods(eventType, qualifiers));
    }

    private <T> void notifyObservers(T event, Set<ObserverMethod<? super T>> observers) {
        for (ObserverMethod<T> observerMethod : observers) {
            this.notifyObserver(event, observerMethod);
        }
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(Type eventType, Annotation ... qualifiers) {
        Resolvable resolvable = new ResolvableBuilder(this.store).addTypes(this.sharedObjectCache.getTypeClosure(eventType)).addType((Type)((Object)Object.class)).addQualifiers(qualifiers).addQualifierIfAbsent(AnyLiteral.INSTANCE).create();
        return (Set)Reflections.cast(this.resolver.resolve(resolvable, true));
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(Type eventType, Set<Annotation> qualifiers) {
        Set<Type> typeClosure = this.sharedObjectCache.getTypeClosure(eventType);
        Resolvable resolvable = new ResolvableBuilder(this.store).addTypes(typeClosure).addType((Type)((Object)Object.class)).addQualifiers(qualifiers).addQualifierIfAbsent(AnyLiteral.INSTANCE).create();
        return (Set)Reflections.cast(this.resolver.resolve(resolvable, true));
    }

    public void clear() {
        this.resolver.clear();
    }

    protected <T> void notifyObserver(T event, ObserverMethod<? super T> observer) {
        observer.notify(event);
    }
}

