/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;
import javax.inject.Inject;
import javax.inject.Scope;
import org.jboss.weld.Container;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractReceiverBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.IllegalProductException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.introspector.WeldMember;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.cache.LoadingCacheUtils;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;

public abstract class AbstractProducerBean<X, T, S extends Member>
extends AbstractReceiverBean<X, T, S> {
    private static final CacheLoader<Class<?>, Boolean> SERIALIZABLE_CHECK = new CacheLoader<Class<?>, Boolean>(){

        @Override
        public Boolean load(Class<?> from) {
            return Reflections.isSerializable(from);
        }
    };
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    private Producer<T> producer;
    private boolean passivationCapableBean;
    private boolean passivationCapableDependency;
    private LoadingCache<Class<?>, Boolean> serializationCheckCache = CacheBuilder.newBuilder().build(SERIALIZABLE_CHECK);

    public AbstractProducerBean(String idSuffix, AbstractClassBean<X> declaringBean, BeanManagerImpl beanManager, ServiceRegistry services) {
        super(idSuffix, declaringBean, beanManager, services);
    }

    @Override
    public abstract WeldMember<T, ? super X, S> getWeldAnnotated();

    @Override
    public Class<?> getBeanClass() {
        return this.getDeclaringBean().getBeanClass();
    }

    @Override
    protected void initTypes() {
        if (this.getType().isArray() || this.getType().isPrimitive()) {
            HashSet<Object> types = new HashSet<Object>();
            types.add(this.getProducerReturnType());
            types.add(Object.class);
            this.types = types;
        } else {
            super.initTypes();
        }
    }

    protected void initType() {
        try {
            this.type = this.getWeldAnnotated().getJavaClass();
        }
        catch (ClassCastException e) {
            Type type = Beans.getDeclaredBeanType(this.getClass());
            throw new WeldException(BeanMessage.PRODUCER_CAST_ERROR, (Throwable)e, this.getWeldAnnotated().getJavaClass(), type == null ? " unknown " : type);
        }
    }

    protected void checkProducerReturnType() {
        if (this.getProducerReturnType() instanceof TypeVariable || this.getProducerReturnType() instanceof WildcardType) {
            throw new DefinitionException(BeanMessage.RETURN_TYPE_MUST_BE_CONCRETE, this.getProducerReturnType());
        }
        if (this.getWeldAnnotated().isParameterizedType()) {
            for (Type type : this.getWeldAnnotated().getActualTypeArguments()) {
                if (!Dependent.class.equals(this.getScope()) && type instanceof TypeVariable) {
                    throw new DefinitionException(BeanMessage.PRODUCER_METHOD_WITH_TYPE_VARIABLE_RETURN_TYPE_MUST_BE_DEPENDENT, this.getWeldAnnotated());
                }
                if (!(type instanceof WildcardType)) continue;
                throw new DefinitionException(BeanMessage.PRODUCER_METHOD_CANNOT_HAVE_A_WILDCARD_RETURN_TYPE, this.getWeldAnnotated());
            }
        }
    }

    private Type getProducerReturnType() {
        return this.getWeldAnnotated().getBaseType();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        this.getDeclaringBean().initialize(environment);
        super.initialize(environment);
        this.checkProducerReturnType();
        this.initPassivationCapable();
    }

    private void initPassivationCapable() {
        this.passivationCapableBean = !this.getWeldAnnotated().isFinal() || Serializable.class.isAssignableFrom(this.getWeldAnnotated().getJavaClass());
        this.passivationCapableDependency = this.isNormalScoped() ? true : this.getScope().equals(Dependent.class) && this.passivationCapableBean;
    }

    @Override
    public boolean isPassivationCapableBean() {
        return this.passivationCapableBean;
    }

    @Override
    public boolean isPassivationCapableDependency() {
        return this.passivationCapableDependency;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.getProducer().getInjectionPoints();
    }

    protected T checkReturnValue(T instance) {
        if (instance == null) {
            if (!this.isDependent()) {
                throw new IllegalProductException(BeanMessage.NULL_NOT_ALLOWED_FROM_PRODUCER, this.getProducer());
            }
        } else {
            boolean passivating = this.beanManager.getServices().get(MetaAnnotationStore.class).getScopeModel(this.getScope()).isPassivating();
            boolean instanceSerializable = this.isTypeSerializable(instance.getClass());
            if (passivating && !instanceSerializable) {
                throw new IllegalProductException(BeanMessage.NON_SERIALIZABLE_PRODUCT_ERROR, this.getProducer());
            }
            InjectionPoint injectionPoint = Container.instance().services().get(CurrentInjectionPoint.class).peek();
            if (injectionPoint != null && injectionPoint.getBean() != null && !instanceSerializable && Beans.isPassivatingScope(injectionPoint.getBean(), this.beanManager)) {
                if (injectionPoint.getMember() instanceof Field) {
                    if (!injectionPoint.isTransient()) {
                        throw new IllegalProductException(BeanMessage.NON_SERIALIZABLE_FIELD_INJECTION_ERROR, this, injectionPoint);
                    }
                } else if (injectionPoint.getMember() instanceof Method) {
                    Method method = (Method)injectionPoint.getMember();
                    if (method.isAnnotationPresent(Inject.class)) {
                        throw new IllegalProductException(BeanMessage.NON_SERIALIZABLE_INITIALIZER_PARAM_INJECTION_ERROR, this, injectionPoint);
                    }
                    if (method.isAnnotationPresent(Produces.class)) {
                        throw new IllegalProductException(BeanMessage.NON_SERIALIZABLE_PRODUCER_PARAM_INJECTION_ERROR, this, injectionPoint);
                    }
                } else if (injectionPoint.getMember() instanceof Constructor) {
                    throw new IllegalProductException(BeanMessage.NON_SERIALIZABLE_CONSTRUCTOR_PARAM_INJECTION_ERROR, this, injectionPoint);
                }
            }
        }
        return instance;
    }

    @Override
    protected void checkType() {
    }

    protected boolean isTypeSerializable(Class<?> clazz) {
        return LoadingCacheUtils.getCacheValue(this.serializationCheckCache, clazz);
    }

    @Override
    protected void initScope() {
        HashSet<Annotation> scopes = new HashSet<Annotation>();
        scopes.addAll(this.getWeldAnnotated().getMetaAnnotations(Scope.class));
        scopes.addAll(this.getWeldAnnotated().getMetaAnnotations(NormalScope.class));
        if (scopes.size() > 1) {
            throw new DefinitionException(BeanMessage.ONLY_ONE_SCOPE_ALLOWED, this.getProducer());
        }
        if (scopes.size() == 1) {
            this.scope = ((Annotation)scopes.iterator().next()).annotationType();
            log.trace(BeanMessage.USING_SCOPE, this.scope, this);
            return;
        }
        this.initScopeFromStereotype();
        if (this.scope == null) {
            this.scope = Dependent.class;
            log.trace(BeanMessage.USING_DEFAULT_SCOPE, this);
        }
    }

    public void setProducer(Producer<T> producer) {
        this.producer = producer;
    }

    public Producer<T> getProducer() {
        return this.producer;
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        T instance = this.getProducer().produce(creationalContext);
        return this.checkReturnValue(instance);
    }

    protected abstract class AbstractProducer
    implements Producer<T> {
        protected AbstractProducer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T produce(CreationalContext<T> ctx) {
            CreationalContext receiverCreationalContext = AbstractProducerBean.this.beanManager.createCreationalContext((Contextual)AbstractProducerBean.this.getDeclaringBean());
            Object receiver = AbstractProducerBean.this.getReceiver(ctx, receiverCreationalContext);
            try {
                Object t = this.produce(receiver, ctx);
                return t;
            }
            finally {
                receiverCreationalContext.release();
            }
        }

        @Override
        public Set<InjectionPoint> getInjectionPoints() {
            return (Set)Reflections.cast(AbstractProducerBean.this.getWeldInjectionPoints());
        }

        protected abstract T produce(Object var1, CreationalContext<T> var2);
    }
}

