/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.ProxyObject;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.Interceptor;
import javax.inject.Scope;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.interceptor.CustomInterceptorMetadata;
import org.jboss.weld.bean.interceptor.SerializableContextualInterceptorReference;
import org.jboss.weld.bean.interceptor.WeldInterceptorClassMetadata;
import org.jboss.weld.bean.proxy.CombinedInterceptorAndDecoratorStackMethodHandler;
import org.jboss.weld.bean.proxy.DecorationHelper;
import org.jboss.weld.bean.proxy.InterceptedSubclassFactory;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.bean.proxy.TargetBeanInstance;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.context.SerializableContextualImpl;
import org.jboss.weld.ejb.EJBApiAbstraction;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.interceptor.InterceptorBindingType;
import org.jboss.weld.interceptor.builder.InterceptionModelBuilder;
import org.jboss.weld.interceptor.spi.metadata.ClassMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.interceptor.util.InterceptionUtils;
import org.jboss.weld.introspector.MethodSignature;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldConstructor;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.jlr.MethodSignatureImpl;
import org.jboss.weld.introspector.jlr.WeldConstructorImpl;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SecureReflections;
import org.slf4j.cal10n.LocLogger;

public abstract class AbstractClassBean<T>
extends AbstractBean<T, Class<T>> {
    private static final InterceptorMetadata<?>[] EMPTY_INTERCEPTOR_METADATA_ARRAY = new InterceptorMetadata[0];
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    protected WeldClass<T> annotatedItem;
    private List<Set<FieldInjectionPoint<?, ?>>> injectableFields;
    private List<Set<MethodInjectionPoint<?, ?>>> initializerMethods;
    private List<Decorator<?>> decorators;
    private boolean hasSerializationOrInvocationInterceptorMethods;
    private List<WeldMethod<?, ? super T>> postConstructMethods;
    private List<WeldMethod<?, ? super T>> preDestroyMethods;
    private InjectionTarget<T> injectionTarget;
    private ConstructorInjectionPoint<T> constructor;
    protected WeldClass<T> enhancedSubclass;
    protected WeldConstructor<T> constructorForEnhancedSubclass;
    protected ProxyFactory<T> decoratorProxyFactory;
    private boolean hasInterceptors;
    private boolean subclassed;

    private static <T> InterceptorMetadata<T>[] emptyInterceptorMetadataArray() {
        return (InterceptorMetadata[])Reflections.cast(EMPTY_INTERCEPTOR_METADATA_ARRAY);
    }

    protected AbstractClassBean(WeldClass<T> type, String idSuffix, BeanManagerImpl beanManager, ServiceRegistry services) {
        super(idSuffix, beanManager, services);
        this.annotatedItem = type;
        this.initStereotypes();
        this.initAlternative();
        this.initInitializerMethods();
        this.initInjectableFields();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        super.initialize(environment);
        this.checkBeanImplementation();
        this.initTargetClassInterceptors();
    }

    @Override
    public void initializeAfterBeanDiscovery() {
        this.initInterceptorsIfNeeded();
        this.initDecorators();
        this.initAfterInterceptorsAndDecoratorsInitialized();
        super.initializeAfterBeanDiscovery();
        boolean bl = this.subclassed = !Reflections.isFinal(this.getType()) && (this.hasDecorators() || this.hasInterceptors());
        if (this.isSubclassed()) {
            this.initEnhancedSubclass();
        }
        if (this.hasDecorators()) {
            this.decoratorProxyFactory = new ProxyFactory(this.getType(), this.getTypes(), this);
            this.decoratorProxyFactory.getProxyClass();
        }
    }

    protected void initAfterInterceptorsAndDecoratorsInitialized() {
    }

    protected void initInterceptorsIfNeeded() {
        if (this.isInterceptionCandidate() && !this.beanManager.getInterceptorModelRegistry().containsKey(this.getType())) {
            new InterceptionModelInitializer().init();
        }
        this.hasInterceptors = this.isInterceptionCandidate() && (this.hasSerializationOrInvocationInterceptorMethods || this.beanManager.getInterceptorModelRegistry().get(this.getType()) != null);
    }

    public void initDecorators() {
        this.decorators = this.getBeanManager().resolveDecorators(this.getTypes(), this.getQualifiers());
    }

    public boolean hasDecorators() {
        return this.decorators != null && this.decorators.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T applyDecorators(T instance, CreationalContext<T> creationalContext, InjectionPoint originalInjectionPoint) {
        T outerDelegate;
        assert (this.hasDecorators()) : "Bean does not have decorators";
        TargetBeanInstance beanInstance = new TargetBeanInstance(this, instance);
        DecorationHelper<T> decorationHelper = new DecorationHelper<T>(beanInstance, this, this.decoratorProxyFactory.getProxyClass(), this.beanManager, this.getContextualStore(), this.decorators);
        DecorationHelper.push(decorationHelper);
        try {
            outerDelegate = decorationHelper.getNextDelegate(originalInjectionPoint, creationalContext);
        }
        finally {
            DecorationHelper.pop();
        }
        if (outerDelegate == null) {
            throw new WeldException(BeanMessage.PROXY_INSTANTIATION_FAILED, this);
        }
        CombinedInterceptorAndDecoratorStackMethodHandler wrapperMethodHandler = (CombinedInterceptorAndDecoratorStackMethodHandler)((ProxyObject)instance).getHandler();
        wrapperMethodHandler.setOuterDecorator(outerDelegate);
        return instance;
    }

    public List<Decorator<?>> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    protected void initType() {
        this.type = this.getWeldAnnotated().getJavaClass();
    }

    protected void initInjectableFields() {
        this.injectableFields = Beans.getFieldInjectionPoints(this, this.annotatedItem, this.beanManager);
        this.addInjectionPoints(Beans.mergeFieldInjectionPoints(this.injectableFields));
    }

    protected void initInitializerMethods() {
        this.initializerMethods = Beans.getInitializerMethods(this, this.getWeldAnnotated(), this.beanManager);
        this.addInjectionPoints(Beans.getParameterInjectionPoints(this, this.initializerMethods, this.beanManager));
    }

    @Override
    protected void initScope() {
        for (WeldClass clazz = this.getWeldAnnotated(); clazz != null; clazz = clazz.getWeldSuperclass()) {
            HashSet<Annotation> scopes = new HashSet<Annotation>();
            scopes.addAll(clazz.getDeclaredMetaAnnotations(Scope.class));
            scopes.addAll(clazz.getDeclaredMetaAnnotations(NormalScope.class));
            if (scopes.size() == 1) {
                if (!this.getWeldAnnotated().isAnnotationPresent(((Annotation)scopes.iterator().next()).annotationType())) break;
                this.scope = ((Annotation)scopes.iterator().next()).annotationType();
                log.trace(BeanMessage.USING_SCOPE, this.scope, this);
                break;
            }
            if (scopes.size() <= 1) continue;
            throw new DefinitionException(BeanMessage.ONLY_ONE_SCOPE_ALLOWED, this.getWeldAnnotated());
        }
        if (this.scope == null) {
            this.initScopeFromStereotype();
        }
        if (this.scope == null) {
            this.scope = Dependent.class;
            log.trace(BeanMessage.USING_DEFAULT_SCOPE, this);
        }
    }

    protected void checkBeanImplementation() {
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        super.preSpecialize(environment);
        if (this.getWeldAnnotated().getWeldSuperclass() == null || this.getWeldAnnotated().getWeldSuperclass().getJavaClass().equals(Object.class)) {
            throw new DefinitionException(BeanMessage.SPECIALIZING_BEAN_MUST_EXTEND_A_BEAN, this);
        }
    }

    public WeldClass<T> getWeldAnnotated() {
        return this.annotatedItem;
    }

    @Override
    protected String getDefaultName() {
        return Introspector.decapitalize(this.getWeldAnnotated().getSimpleName());
    }

    public List<? extends Set<? extends MethodInjectionPoint<?, ?>>> getInitializerMethods() {
        return Collections.unmodifiableList(this.initializerMethods);
    }

    public List<? extends Set<FieldInjectionPoint<?, ?>>> getInjectableFields() {
        return Collections.unmodifiableList(this.injectableFields);
    }

    protected void initPostConstruct() {
        this.postConstructMethods = Beans.getPostConstructMethods(this.getWeldAnnotated());
    }

    protected void initPreDestroy() {
        this.preDestroyMethods = Beans.getPreDestroyMethods(this.getWeldAnnotated());
    }

    public List<WeldMethod<?, ? super T>> getPostConstruct() {
        return this.postConstructMethods;
    }

    public List<WeldMethod<?, ? super T>> getPreDestroy() {
        return this.preDestroyMethods;
    }

    protected abstract boolean isInterceptionCandidate();

    public void setInjectionTarget(InjectionTarget<T> injectionTarget) {
        this.injectionTarget = injectionTarget;
    }

    public InjectionTarget<T> getInjectionTarget() {
        return this.injectionTarget;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.getInjectionTarget().getInjectionPoints();
    }

    protected void defaultPreDestroy(T instance) {
        for (WeldMethod<?, T> method : this.getPreDestroy()) {
            if (method == null) continue;
            try {
                method.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new WeldException(BeanMessage.INVOCATION_ERROR, (Throwable)e, method, instance);
            }
        }
    }

    protected void defaultPostConstruct(T instance) {
        for (WeldMethod<?, T> method : this.getPostConstruct()) {
            if (method == null) continue;
            try {
                method.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new WeldException(BeanMessage.INVOCATION_ERROR, (Throwable)e, method, instance);
            }
        }
    }

    public boolean hasInterceptors() {
        return this.hasInterceptors;
    }

    private void initTargetClassInterceptors() {
        InterceptorMetadata interceptorClassMetadata;
        this.hasSerializationOrInvocationInterceptorMethods = !Beans.isInterceptor(this.getWeldAnnotated()) ? (interceptorClassMetadata = this.beanManager.getInterceptorMetadataReader().getTargetClassInterceptorMetadata(WeldInterceptorClassMetadata.of(this.getWeldAnnotated()))).isEligible(InterceptionType.AROUND_INVOKE) || interceptorClassMetadata.isEligible(InterceptionType.AROUND_TIMEOUT) || interceptorClassMetadata.isEligible(InterceptionType.PRE_PASSIVATE) || interceptorClassMetadata.isEligible(InterceptionType.POST_ACTIVATE) : false;
    }

    protected void checkConstructor() {
        if (!this.constructor.getWeldParameters(Disposes.class).isEmpty()) {
            throw new DefinitionException(BeanMessage.PARAMETER_ANNOTATION_NOT_ALLOWED_ON_CONSTRUCTOR, "@Disposes", this.constructor);
        }
        if (!this.constructor.getWeldParameters(Observes.class).isEmpty()) {
            throw new DefinitionException(BeanMessage.PARAMETER_ANNOTATION_NOT_ALLOWED_ON_CONSTRUCTOR, "@Observes", this.constructor);
        }
    }

    protected void initConstructor() {
        this.constructor = Beans.getBeanConstructor(this, this.getWeldAnnotated(), this.beanManager);
        this.addInjectionPoints(Beans.getParameterInjectionPoints(this, this.constructor, this.beanManager));
    }

    public ConstructorInjectionPoint<T> getConstructor() {
        return this.constructor;
    }

    protected boolean isSubclassed() {
        return this.subclassed;
    }

    protected void initEnhancedSubclass() {
        ClassTransformer transformer = this.beanManager.getServices().get(ClassTransformer.class);
        this.enhancedSubclass = transformer.loadClass(this.createEnhancedSubclass());
        this.constructorForEnhancedSubclass = WeldConstructorImpl.of(this.enhancedSubclass.getDeclaredWeldConstructor(this.getConstructor().getSignature()), this.enhancedSubclass, transformer);
    }

    protected Class<T> createEnhancedSubclass() {
        HashSet<MethodSignature> enhancedMethodSignatures = new HashSet<MethodSignature>();
        for (WeldMethod<?, ?> method : Beans.getInterceptableMethods(this.getWeldAnnotated())) {
            enhancedMethodSignatures.add(new MethodSignatureImpl(method));
        }
        return new InterceptedSubclassFactory(this.getType(), this.getTypes(), this, enhancedMethodSignatures).getProxyClass();
    }

    private ContextualStore getContextualStore() {
        return this.getServices().get(ContextualStore.class);
    }

    private class InterceptionModelInitializer {
        private Map<Interceptor<?>, InterceptorMetadata<SerializableContextual<Interceptor<?>, ?>>> interceptorMetadatas = new HashMap();
        private List<WeldMethod<?, ?>> businessMethods;
        private InterceptionModelBuilder<ClassMetadata<?>, ?> builder;

        private InterceptionModelInitializer() {
        }

        public void init() {
            this.businessMethods = Beans.getInterceptableMethods(AbstractClassBean.this.getWeldAnnotated());
            this.builder = InterceptionModelBuilder.newBuilderFor(this.getClassMetadata());
            this.initEjbInterceptors();
            this.initCdiInterceptors();
            InterceptionModel<ClassMetadata<?>, ?> interceptionModel = this.builder.build();
            if (interceptionModel.getAllInterceptors().size() > 0 || AbstractClassBean.this.hasSerializationOrInvocationInterceptorMethods) {
                if (AbstractClassBean.this.getWeldAnnotated().isFinal()) {
                    throw new DefinitionException(BeanMessage.FINAL_BEAN_CLASS_WITH_INTERCEPTORS_NOT_ALLOWED, AbstractClassBean.this);
                }
                AbstractClassBean.this.beanManager.getInterceptorModelRegistry().put(AbstractClassBean.this.getType(), interceptionModel);
            }
        }

        private ClassMetadata<T> getClassMetadata() {
            return AbstractClassBean.this.beanManager.getInterceptorMetadataReader().getClassMetadata(AbstractClassBean.this.getType());
        }

        private void initCdiInterceptors() {
            Set<InterceptorBindingType> classBindings = this.getClassInterceptorBindings();
            this.initCdiLifecycleInterceptors(classBindings);
            this.initCdiBusinessMethodInterceptors(classBindings);
        }

        private Set<InterceptorBindingType> getClassInterceptorBindings() {
            HashSet<InterceptorBindingType> classBindingAnnotations = new HashSet<InterceptorBindingType>();
            classBindingAnnotations.addAll(AbstractClassBean.this.beanManager.extractAndFlattenInterceptorBindings(AbstractClassBean.this.getWeldAnnotated().getAnnotations()));
            for (Class<Annotation> annotation : AbstractClassBean.this.getStereotypes()) {
                classBindingAnnotations.addAll(AbstractClassBean.this.beanManager.extractAndFlattenInterceptorBindings(AbstractClassBean.this.beanManager.getStereotypeDefinition(annotation)));
            }
            return classBindingAnnotations;
        }

        private void initCdiLifecycleInterceptors(Set<InterceptorBindingType> classBindings) {
            if (classBindings.size() == 0) {
                return;
            }
            if (Beans.findInterceptorBindingConflicts(classBindings)) {
                throw new DeploymentException(BeanMessage.CONFLICTING_INTERCEPTOR_BINDINGS, AbstractClassBean.this.getType());
            }
            this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.POST_CONSTRUCT, classBindings);
            this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.PRE_DESTROY, classBindings);
            this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.PRE_PASSIVATE, classBindings);
            this.initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType.POST_ACTIVATE, classBindings);
        }

        private void initLifeCycleInterceptor(javax.enterprise.inject.spi.InterceptionType interceptionType, Set<InterceptorBindingType> interceptorBindingTypes) {
            List<Interceptor<?>> resolvedInterceptors = AbstractClassBean.this.beanManager.resolveInterceptors(interceptionType, interceptorBindingTypes);
            this.builder.intercept(interceptionType).with(this.toSerializableContextualArray(resolvedInterceptors));
        }

        private void initCdiBusinessMethodInterceptors(Set<InterceptorBindingType> classBindings) {
            for (WeldMethod<?, ?> method : this.businessMethods) {
                this.initCdiBusinessMethodInterceptor(method, this.getMethodInterceptorBindings(classBindings, method));
            }
        }

        private Set<InterceptorBindingType> getMethodInterceptorBindings(Set<InterceptorBindingType> classBindingAnnotations, WeldMethod<?, ?> method) {
            HashSet<InterceptorBindingType> methodBindingAnnotations = new HashSet<InterceptorBindingType>();
            methodBindingAnnotations.addAll(classBindingAnnotations);
            methodBindingAnnotations.addAll(AbstractClassBean.this.beanManager.extractAndFlattenInterceptorBindings(method.getAnnotations()));
            return methodBindingAnnotations;
        }

        private void initCdiBusinessMethodInterceptor(WeldMethod<?, ?> method, Set<InterceptorBindingType> methodInterceptorBindings) {
            if (methodInterceptorBindings.size() == 0) {
                return;
            }
            if (Beans.findInterceptorBindingConflicts(methodInterceptorBindings)) {
                throw new DeploymentException(BeanMessage.CONFLICTING_INTERCEPTOR_BINDINGS, AbstractClassBean.this.getType() + "." + method.getName() + "()");
            }
            this.initInterceptor(javax.enterprise.inject.spi.InterceptionType.AROUND_INVOKE, method, methodInterceptorBindings);
            this.initInterceptor(javax.enterprise.inject.spi.InterceptionType.AROUND_TIMEOUT, method, methodInterceptorBindings);
        }

        private void initInterceptor(javax.enterprise.inject.spi.InterceptionType interceptionType, WeldMethod<?, ?> method, Set<InterceptorBindingType> interceptorBindingTypes) {
            List<Interceptor<?>> methodBoundInterceptors = AbstractClassBean.this.beanManager.resolveInterceptors(interceptionType, interceptorBindingTypes);
            if (methodBoundInterceptors != null && methodBoundInterceptors.size() > 0) {
                if (method.isFinal()) {
                    throw new DefinitionException(BeanMessage.FINAL_INTERCEPTED_BEAN_METHOD_NOT_ALLOWED, method, methodBoundInterceptors.get(0).getBeanClass().getName());
                }
                Method javaMethod = ((AnnotatedMethod)Reflections.cast(method)).getJavaMember();
                this.builder.intercept(interceptionType, javaMethod).with(this.toSerializableContextualArray(methodBoundInterceptors));
            }
        }

        private void initEjbInterceptors() {
            this.initClassDeclaredEjbInterceptors();
            for (WeldMethod<?, ?> method : this.businessMethods) {
                this.initMethodDeclaredEjbInterceptors(method);
            }
        }

        private void initClassDeclaredEjbInterceptors() {
            Class<?>[] classDeclaredInterceptors = null;
            if (AbstractClassBean.this.getWeldAnnotated().isAnnotationPresent(InterceptionUtils.getInterceptorsAnnotationClass())) {
                Annotation interceptorsAnnotation = AbstractClassBean.this.getWeldAnnotated().getAnnotation(InterceptionUtils.getInterceptorsAnnotationClass());
                classDeclaredInterceptors = SecureReflections.extractValues(interceptorsAnnotation);
            }
            if (classDeclaredInterceptors != null) {
                for (Class<?> clazz : classDeclaredInterceptors) {
                    this.builder.interceptAll().with(AbstractClassBean.this.beanManager.getInterceptorMetadataReader().getInterceptorMetadata(clazz));
                }
            }
        }

        private void initMethodDeclaredEjbInterceptors(WeldMethod<?, ?> method) {
            Class<?>[] methodDeclaredInterceptors;
            Method javaMethod = ((AnnotatedMethod)Reflections.cast(method)).getJavaMember();
            boolean excludeClassInterceptors = method.isAnnotationPresent(InterceptionUtils.getExcludeClassInterceptorsAnnotationClass());
            if (excludeClassInterceptors) {
                this.builder.ignoreGlobalInterceptors(javaMethod);
            }
            if ((methodDeclaredInterceptors = this.getMethodDeclaredInterceptors(method)) != null && methodDeclaredInterceptors.length > 0) {
                if (method.isFinal()) {
                    throw new DefinitionException(BeanMessage.FINAL_INTERCEPTED_BEAN_METHOD_NOT_ALLOWED, method, methodDeclaredInterceptors[0].getName());
                }
                javax.enterprise.inject.spi.InterceptionType interceptionType = this.isTimeoutAnnotationPresentOn(method) ? javax.enterprise.inject.spi.InterceptionType.AROUND_TIMEOUT : javax.enterprise.inject.spi.InterceptionType.AROUND_INVOKE;
                InterceptorMetadata[] interceptors = this.getMethodDeclaredInterceptorMetadatas(methodDeclaredInterceptors);
                this.builder.intercept(interceptionType, javaMethod).with(interceptors);
            }
        }

        private InterceptorMetadata[] getMethodDeclaredInterceptorMetadatas(Class<?>[] methodDeclaredInterceptors) {
            ArrayList list = new ArrayList();
            for (Class<?> clazz : methodDeclaredInterceptors) {
                list.add(AbstractClassBean.this.beanManager.getInterceptorMetadataReader().getInterceptorMetadata(clazz));
            }
            return list.toArray(new InterceptorMetadata[list.size()]);
        }

        private boolean isTimeoutAnnotationPresentOn(WeldMethod<?, ?> method) {
            return method.isAnnotationPresent(AbstractClassBean.this.beanManager.getServices().get(EJBApiAbstraction.class).TIMEOUT_ANNOTATION_CLASS);
        }

        private Class<?>[] getMethodDeclaredInterceptors(WeldMethod<?, ?> method) {
            Class<?>[] methodDeclaredInterceptors = null;
            if (method.isAnnotationPresent(InterceptionUtils.getInterceptorsAnnotationClass())) {
                methodDeclaredInterceptors = SecureReflections.extractValues(method.getAnnotation(InterceptionUtils.getInterceptorsAnnotationClass()));
            }
            return methodDeclaredInterceptors;
        }

        private InterceptorMetadata<SerializableContextual<?, ?>>[] toSerializableContextualArray(List<Interceptor<?>> interceptors) {
            ArrayList serializableContextuals = new ArrayList();
            for (Interceptor<?> interceptor : interceptors) {
                serializableContextuals.add(this.getCachedInterceptorMetadata(interceptor));
            }
            return serializableContextuals.toArray(AbstractClassBean.emptyInterceptorMetadataArray());
        }

        private InterceptorMetadata<SerializableContextual<Interceptor<?>, ?>> getCachedInterceptorMetadata(Interceptor<?> interceptor) {
            InterceptorMetadata<SerializableContextual<Interceptor<?>, ?>> interceptorMetadata = this.interceptorMetadatas.get(interceptor);
            if (interceptorMetadata == null) {
                interceptorMetadata = this.getInterceptorMetadata(interceptor);
                this.interceptorMetadatas.put(interceptor, interceptorMetadata);
            }
            return interceptorMetadata;
        }

        private InterceptorMetadata<SerializableContextual<Interceptor<?>, ?>> getInterceptorMetadata(Interceptor<?> interceptor) {
            SerializableContextualImpl contextual = new SerializableContextualImpl(interceptor, AbstractClassBean.this.getContextualStore());
            if (interceptor instanceof InterceptorImpl) {
                InterceptorImpl interceptorImpl = (InterceptorImpl)interceptor;
                WeldInterceptorClassMetadata classMetadata = WeldInterceptorClassMetadata.of(interceptorImpl.getWeldAnnotated());
                SerializableContextualInterceptorReference interceptorReference = new SerializableContextualInterceptorReference(contextual, classMetadata);
                return AbstractClassBean.this.beanManager.getInterceptorMetadataReader().getInterceptorMetadata(interceptorReference);
            }
            ClassMetadata<?> classMetadata = AbstractClassBean.this.beanManager.getInterceptorMetadataReader().getClassMetadata(interceptor.getBeanClass());
            return new CustomInterceptorMetadata(new SerializableContextualInterceptorReference(contextual, null), classMetadata);
        }
    }
}

