/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.util.proxy.ProxyObject;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.inject.Scope;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.proxy.CombinedInterceptorAndDecoratorStackMethodHandler;
import org.jboss.weld.bean.proxy.DecorationHelper;
import org.jboss.weld.bean.proxy.InterceptedSubclassFactory;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.bean.proxy.TargetBeanInstance;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.producer.InterceptionModelInitializer;
import org.jboss.weld.introspector.MethodSignature;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldConstructor;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.jlr.MethodSignatureImpl;
import org.jboss.weld.introspector.jlr.WeldConstructorImpl;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;

public abstract class AbstractClassBean<T>
extends AbstractBean<T, Class<T>> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    protected WeldClass<T> annotatedItem;
    private List<Set<FieldInjectionPoint<?, ?>>> injectableFields;
    private List<Set<MethodInjectionPoint<?, ?>>> initializerMethods;
    private List<Decorator<?>> decorators;
    private List<WeldMethod<?, ? super T>> postConstructMethods;
    private List<WeldMethod<?, ? super T>> preDestroyMethods;
    private InjectionTarget<T> injectionTarget;
    private ConstructorInjectionPoint<T> constructor;
    protected WeldClass<T> enhancedSubclass;
    protected WeldConstructor<T> constructorForEnhancedSubclass;
    protected ProxyFactory<T> decoratorProxyFactory;
    private boolean subclassed;

    protected AbstractClassBean(WeldClass<T> type, String idSuffix, BeanManagerImpl beanManager, ServiceRegistry services) {
        super(idSuffix, beanManager, services);
        this.annotatedItem = type;
        this.initStereotypes();
        this.initAlternative();
        this.initInitializerMethods();
        this.initInjectableFields();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        super.initialize(environment);
        this.checkBeanImplementation();
    }

    @Override
    public void initializeAfterBeanDiscovery() {
        this.initInterceptorsIfNeeded();
        this.initDecorators();
        this.initAfterInterceptorsAndDecoratorsInitialized();
        super.initializeAfterBeanDiscovery();
        boolean bl = this.subclassed = !Reflections.isFinal(this.getType()) && (this.hasDecorators() || this.hasInterceptors());
        if (this.isSubclassed()) {
            this.initEnhancedSubclass();
        }
        if (this.hasDecorators()) {
            this.decoratorProxyFactory = new ProxyFactory(this.getType(), this.getTypes(), this);
            this.decoratorProxyFactory.getProxyClass();
        }
    }

    protected void initAfterInterceptorsAndDecoratorsInitialized() {
    }

    protected void initInterceptorsIfNeeded() {
        if (this.isInterceptionCandidate() && !this.beanManager.getInterceptorModelRegistry().containsKey(this.getType())) {
            new InterceptionModelInitializer(this.beanManager, this.getWeldAnnotated(), this, this.getType()).init();
        }
    }

    public void initDecorators() {
        this.decorators = this.getBeanManager().resolveDecorators(this.getTypes(), this.getQualifiers());
    }

    public boolean hasDecorators() {
        return this.decorators != null && this.decorators.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T applyDecorators(T instance, CreationalContext<T> creationalContext, InjectionPoint originalInjectionPoint) {
        T outerDelegate;
        assert (this.hasDecorators()) : "Bean does not have decorators";
        TargetBeanInstance beanInstance = new TargetBeanInstance(this, instance);
        DecorationHelper<T> decorationHelper = new DecorationHelper<T>(beanInstance, this, this.decoratorProxyFactory.getProxyClass(), this.beanManager, this.getContextualStore(), this.decorators);
        DecorationHelper.push(decorationHelper);
        try {
            outerDelegate = decorationHelper.getNextDelegate(originalInjectionPoint, creationalContext);
        }
        finally {
            DecorationHelper.pop();
        }
        if (outerDelegate == null) {
            throw new WeldException(BeanMessage.PROXY_INSTANTIATION_FAILED, this);
        }
        CombinedInterceptorAndDecoratorStackMethodHandler wrapperMethodHandler = (CombinedInterceptorAndDecoratorStackMethodHandler)((ProxyObject)instance).getHandler();
        wrapperMethodHandler.setOuterDecorator(outerDelegate);
        return instance;
    }

    public List<Decorator<?>> getDecorators() {
        return Collections.unmodifiableList(this.decorators);
    }

    protected void initType() {
        this.type = this.getWeldAnnotated().getJavaClass();
    }

    protected void initInjectableFields() {
        this.injectableFields = Beans.getFieldInjectionPoints(this, this.annotatedItem, this.beanManager);
        this.addInjectionPoints(Beans.mergeFieldInjectionPoints(this.injectableFields));
    }

    protected void initInitializerMethods() {
        this.initializerMethods = Beans.getInitializerMethods(this, this.getWeldAnnotated(), this.beanManager);
        this.addInjectionPoints(Beans.getParameterInjectionPoints(this, this.initializerMethods, this.beanManager));
    }

    @Override
    protected void initScope() {
        for (WeldClass clazz = this.getWeldAnnotated(); clazz != null; clazz = clazz.getWeldSuperclass()) {
            HashSet<Annotation> scopes = new HashSet<Annotation>();
            scopes.addAll(clazz.getDeclaredMetaAnnotations(Scope.class));
            scopes.addAll(clazz.getDeclaredMetaAnnotations(NormalScope.class));
            if (scopes.size() == 1) {
                if (!this.getWeldAnnotated().isAnnotationPresent(((Annotation)scopes.iterator().next()).annotationType())) break;
                this.scope = ((Annotation)scopes.iterator().next()).annotationType();
                log.trace(BeanMessage.USING_SCOPE, this.scope, this);
                break;
            }
            if (scopes.size() <= 1) continue;
            throw new DefinitionException(BeanMessage.ONLY_ONE_SCOPE_ALLOWED, this.getWeldAnnotated());
        }
        if (this.scope == null) {
            this.initScopeFromStereotype();
        }
        if (this.scope == null) {
            this.scope = Dependent.class;
            log.trace(BeanMessage.USING_DEFAULT_SCOPE, this);
        }
    }

    protected void checkBeanImplementation() {
    }

    @Override
    protected void preSpecialize(BeanDeployerEnvironment environment) {
        super.preSpecialize(environment);
        if (this.getWeldAnnotated().getWeldSuperclass() == null || this.getWeldAnnotated().getWeldSuperclass().getJavaClass().equals(Object.class)) {
            throw new DefinitionException(BeanMessage.SPECIALIZING_BEAN_MUST_EXTEND_A_BEAN, this);
        }
    }

    public WeldClass<T> getWeldAnnotated() {
        return this.annotatedItem;
    }

    @Override
    protected String getDefaultName() {
        return Introspector.decapitalize(this.getWeldAnnotated().getSimpleName());
    }

    public List<? extends Set<? extends MethodInjectionPoint<?, ?>>> getInitializerMethods() {
        return Collections.unmodifiableList(this.initializerMethods);
    }

    public List<? extends Set<FieldInjectionPoint<?, ?>>> getInjectableFields() {
        return Collections.unmodifiableList(this.injectableFields);
    }

    protected void initPostConstruct() {
        this.postConstructMethods = Beans.getPostConstructMethods(this.getWeldAnnotated());
    }

    protected void initPreDestroy() {
        this.preDestroyMethods = Beans.getPreDestroyMethods(this.getWeldAnnotated());
    }

    public List<WeldMethod<?, ? super T>> getPostConstruct() {
        return this.postConstructMethods;
    }

    public List<WeldMethod<?, ? super T>> getPreDestroy() {
        return this.preDestroyMethods;
    }

    protected abstract boolean isInterceptionCandidate();

    public void setInjectionTarget(InjectionTarget<T> injectionTarget) {
        this.injectionTarget = injectionTarget;
    }

    public InjectionTarget<T> getInjectionTarget() {
        return this.injectionTarget;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.getInjectionTarget().getInjectionPoints();
    }

    protected void defaultPreDestroy(T instance) {
        for (WeldMethod<?, T> method : this.getPreDestroy()) {
            if (method == null) continue;
            try {
                method.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new WeldException(BeanMessage.INVOCATION_ERROR, (Throwable)e, method, instance);
            }
        }
    }

    protected void defaultPostConstruct(T instance) {
        for (WeldMethod<?, T> method : this.getPostConstruct()) {
            if (method == null) continue;
            try {
                method.invoke(instance, new Object[0]);
            }
            catch (Exception e) {
                throw new WeldException(BeanMessage.INVOCATION_ERROR, (Throwable)e, method, instance);
            }
        }
    }

    public boolean hasInterceptors() {
        if (this.isInterceptionCandidate()) {
            return this.beanManager.getInterceptorModelRegistry().get(this.getType()) != null;
        }
        return false;
    }

    protected void checkConstructor() {
        if (!this.constructor.getWeldParameters(Disposes.class).isEmpty()) {
            throw new DefinitionException(BeanMessage.PARAMETER_ANNOTATION_NOT_ALLOWED_ON_CONSTRUCTOR, "@Disposes", this.constructor);
        }
        if (!this.constructor.getWeldParameters(Observes.class).isEmpty()) {
            throw new DefinitionException(BeanMessage.PARAMETER_ANNOTATION_NOT_ALLOWED_ON_CONSTRUCTOR, "@Observes", this.constructor);
        }
    }

    protected void initConstructor() {
        this.constructor = Beans.getBeanConstructor(this, this.getWeldAnnotated(), this.beanManager);
        this.addInjectionPoints(Beans.getParameterInjectionPoints(this, this.constructor, this.beanManager));
    }

    public ConstructorInjectionPoint<T> getConstructor() {
        return this.constructor;
    }

    protected boolean isSubclassed() {
        return this.subclassed;
    }

    protected void initEnhancedSubclass() {
        ClassTransformer transformer = this.beanManager.getServices().get(ClassTransformer.class);
        this.enhancedSubclass = transformer.loadClass(this.createEnhancedSubclass());
        this.constructorForEnhancedSubclass = WeldConstructorImpl.of(this.enhancedSubclass.getDeclaredWeldConstructor(this.getConstructor().getSignature()), this.enhancedSubclass, transformer);
    }

    protected Class<T> createEnhancedSubclass() {
        HashSet<MethodSignature> enhancedMethodSignatures = new HashSet<MethodSignature>();
        for (WeldMethod<?, ?> method : Beans.getInterceptableMethods(this.getWeldAnnotated())) {
            enhancedMethodSignatures.add(new MethodSignatureImpl(method));
        }
        return new InterceptedSubclassFactory(this.getType(), this.getTypes(), this, enhancedMethodSignatures).getProxyClass();
    }

    private ContextualStore getContextualStore() {
        return this.getServices().get(ContextualStore.class);
    }
}

