/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import java.lang.annotation.Annotation;
import java.util.List;
import javassist.util.proxy.ProxyObject;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.proxy.AbstractBeanInstance;
import org.jboss.weld.bean.proxy.CombinedInterceptorAndDecoratorStackMethodHandler;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.bean.proxy.TargetBeanInstance;
import org.jboss.weld.injection.ConstructorInjectionPoint;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.OnDemandBeanInstance;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.WeldConstructor;
import org.jboss.weld.manager.BeanManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyClassConstructorInjectionPointWrapper<T>
extends ConstructorInjectionPoint<T> {
    private ConstructorInjectionPoint<T> originalConstructorInjectionPoint;
    private Object decoratorDelegate = null;
    private boolean decorator;
    private final Bean<?> bean;

    public ProxyClassConstructorInjectionPointWrapper(Bean<T> declaringBean, WeldConstructor<T> weldConstructor, ConstructorInjectionPoint<T> originalConstructorInjectionPoint) {
        super(declaringBean, weldConstructor);
        this.decorator = declaringBean instanceof Decorator;
        this.originalConstructorInjectionPoint = originalConstructorInjectionPoint;
        this.bean = declaringBean;
    }

    @Override
    public List<ParameterInjectionPoint<?, T>> getWeldParameters() {
        return this.originalConstructorInjectionPoint.getWeldParameters();
    }

    @Override
    protected Object[] getParameterValues(List<ParameterInjectionPoint<?, T>> parameters, Object specialVal, Class<? extends Annotation> specialParam, BeanManagerImpl manager, CreationalContext<?> creationalContext) {
        Object[] parameterValues = super.getParameterValues(parameters, specialVal, specialParam, manager, creationalContext);
        for (ParameterInjectionPoint<?, T> parameter : this.getWeldParameters()) {
            if (!parameter.isDelegate()) continue;
            this.decoratorDelegate = parameterValues[parameter.getPosition()];
        }
        return parameterValues;
    }

    @Override
    public T newInstance(BeanManagerImpl manager, CreationalContext<?> creationalContext) {
        Object instance = super.newInstance(manager, creationalContext);
        if (this.decorator) {
            AbstractBeanInstance beanInstance = null;
            if (this.decoratorDelegate != null) {
                beanInstance = new TargetBeanInstance(this.decoratorDelegate);
            } else if (this.bean instanceof DecoratorImpl) {
                DecoratorImpl di = (DecoratorImpl)this.bean;
                WeldInjectionPoint<?, ?> ip = di.getDelegateInjectionPoint();
                if (ip instanceof FieldInjectionPoint) {
                    beanInstance = new OnDemandBeanInstance(new FieldInstanceProvider(ip, instance));
                } else if (ip instanceof MethodInjectionPoint) {
                    beanInstance = new OnDemandBeanInstance(new MethodInstanceProvider(ip, instance));
                } else if (ip instanceof ParameterInjectionPoint) {
                    beanInstance = new OnDemandBeanInstance(new ParameterInstanceProvider(ip, manager, creationalContext));
                } else {
                    throw new IllegalArgumentException("Invalid InjectionPoint: " + ip);
                }
            }
            ProxyFactory.setBeanInstance(instance, beanInstance, this.bean);
        } else if (instance instanceof ProxyObject) {
            ((ProxyObject)instance).setHandler(new CombinedInterceptorAndDecoratorStackMethodHandler());
        }
        return instance;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodInstanceProvider<T>
    implements OnDemandBeanInstance.InstanceProvider {
        private final WeldInjectionPoint ip;
        private final T instance;

        public MethodInstanceProvider(WeldInjectionPoint ip, T instance) {
            this.ip = ip;
            this.instance = instance;
        }

        @Override
        public Object provideInstance() {
            MethodInjectionPoint mip = (MethodInjectionPoint)this.ip;
            try {
                return mip.delegate().invokeOnInstance(this.instance, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParameterInstanceProvider
    implements OnDemandBeanInstance.InstanceProvider {
        private final WeldInjectionPoint ip;
        private final BeanManagerImpl manager;
        private final CreationalContext<?> creationalContext;

        public ParameterInstanceProvider(WeldInjectionPoint ip, BeanManagerImpl manager, CreationalContext<?> creationalContext) {
            this.ip = ip;
            this.manager = manager;
            this.creationalContext = creationalContext;
        }

        @Override
        public Object provideInstance() {
            ParameterInjectionPoint pip = (ParameterInjectionPoint)this.ip;
            return pip.getValueToInject(this.manager, this.creationalContext);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FieldInstanceProvider<T>
    implements OnDemandBeanInstance.InstanceProvider {
        private final WeldInjectionPoint ip;
        private final T instance;

        public FieldInstanceProvider(WeldInjectionPoint ip, T instance) {
            this.ip = ip;
            this.instance = instance;
        }

        @Override
        public Object provideInstance() {
            FieldInjectionPoint fip = (FieldInjectionPoint)this.ip;
            return fip.delegate().get(this.instance);
        }
    }
}

