/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.Callable;
import org.jboss.weld.interceptor.proxy.InterceptorException;
import org.jboss.weld.interceptor.proxy.LifecycleMixin;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.interceptor.util.InterceptionTypeRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptionUtils {
    public static final String POST_CONSTRUCT = "lifecycle_mixin_$$_postConstruct";
    public static final String PRE_DESTROY = "lifecycle_mixin_$$_preDestroy";
    private static final Class<? extends Annotation> INTERCEPTORS_ANNOTATION_CLASS;
    private static final Class<? extends Annotation> EXCLUDE_CLASS_INTERCEPTORS_ANNOTATION_CLASS;

    private static void executePostConstruct(Object proxy, Callable callback) {
        if (proxy instanceof LifecycleMixin) {
            LifecycleMixin lifecycleMixin = (LifecycleMixin)proxy;
            lifecycleMixin.lifecycle_mixin_$$_postConstruct();
        }
        if (callback != null) {
            try {
                callback.call();
            }
            catch (Exception e) {
                throw new InterceptorException(e);
            }
        }
    }

    public static void executePostConstruct(Object proxy) {
        InterceptionUtils.executePostConstruct(proxy, null);
    }

    private static void executePredestroy(Object proxy, Callable callback) {
        if (proxy instanceof LifecycleMixin) {
            LifecycleMixin lifecycleMixin = (LifecycleMixin)proxy;
            lifecycleMixin.lifecycle_mixin_$$_preDestroy();
        }
        if (callback != null) {
            try {
                callback.call();
            }
            catch (Exception e) {
                throw new InterceptorException(e);
            }
        }
    }

    public static void executePredestroy(Object proxy) {
        InterceptionUtils.executePredestroy(proxy, null);
    }

    public static boolean isInterceptionCandidate(Method method) {
        if (method.getDeclaringClass().equals(Object.class)) {
            return false;
        }
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            return false;
        }
        for (InterceptionType interceptionType : InterceptionTypeRegistry.getSupportedInterceptionTypes()) {
            if (method.getAnnotation(InterceptionTypeRegistry.getAnnotationClass(interceptionType)) == null) continue;
            return false;
        }
        return true;
    }

    public static Class<? extends Annotation> getInterceptorsAnnotationClass() {
        return INTERCEPTORS_ANNOTATION_CLASS;
    }

    public static Class<? extends Annotation> getExcludeClassInterceptorsAnnotationClass() {
        return EXCLUDE_CLASS_INTERCEPTORS_ANNOTATION_CLASS;
    }

    static {
        Class<?> interceptorAnnotation = null;
        Class<?> excludeClass = null;
        try {
            interceptorAnnotation = Class.forName("javax.interceptor.Interceptors");
            excludeClass = Class.forName("javax.interceptor.ExcludeClassInterceptors");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        INTERCEPTORS_ANNOTATION_CLASS = interceptorAnnotation;
        EXCLUDE_CLASS_INTERCEPTORS_ANNOTATION_CLASS = excludeClass;
    }
}

