/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.Container;
import org.jboss.weld.bean.proxy.ClientProxyFactory;
import org.jboss.weld.bean.proxy.ContextBeanInstance;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;

public class ClientProxyProvider {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    private Function<Bean<Object>, Object> createClientProxy;
    private final ConcurrentMap<Bean<Object>, Object> pool;

    public ClientProxyProvider(String contextId) {
        this.createClientProxy = new CreateClientProxy(contextId);
        this.pool = new MapMaker().makeComputingMap(this.createClientProxy);
    }

    private static <T> T createClientProxy(String contextId, Bean<T> bean, String id) throws RuntimeException {
        ContextBeanInstance<T> beanInstance = new ContextBeanInstance<T>(bean, id, contextId);
        Proxies.TypeInfo typeInfo = Proxies.TypeInfo.of(bean.getTypes());
        Object proxy = new ClientProxyFactory(contextId, typeInfo.getSuperClass(), bean.getTypes(), bean).create(beanInstance);
        log.trace(BeanMessage.CREATED_NEW_CLIENT_PROXY_TYPE, proxy.getClass(), bean, id);
        return proxy;
    }

    public <T> T getClientProxy(Bean<T> bean) {
        Object proxy = Reflections.cast(this.pool.get(bean));
        log.trace(BeanMessage.LOOKED_UP_CLIENT_PROXY, proxy.getClass(), bean);
        return proxy;
    }

    public String toString() {
        return "Proxy pool with " + this.pool.size() + " proxies";
    }

    public void clear() {
        this.pool.clear();
    }

    private static final class CreateClientProxy
    implements Function<Bean<Object>, Object> {
        private final String contextId;

        public CreateClientProxy(String contextId) {
            this.contextId = contextId;
        }

        @Override
        public Object apply(Bean<Object> from) {
            String id = Container.instance(this.contextId).services().get(ContextualStore.class).putIfAbsent(from);
            if (id == null) {
                throw new DefinitionException(BeanMessage.BEAN_ID_CREATION_FAILED, from);
            }
            return ClientProxyProvider.createClientProxy(this.contextId, from, id);
        }
    }
}

