/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.ObserverException;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Qualifier;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bootstrap.events.AbstractContainerEvent;
import org.jboss.weld.event.ObserverFactory;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.WeldParameter;
import org.jboss.weld.logging.messages.EventMessage;
import org.jboss.weld.logging.messages.ValidatorMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.TypeVariableResolver;

public class ObserverMethodImpl<T, X>
implements ObserverMethod<T> {
    public static final String ID_PREFIX = ObserverMethodImpl.class.getPackage().getName();
    public static final String ID_SEPARATOR = "-";
    private final Set<Annotation> bindings;
    private final Type eventType;
    protected BeanManagerImpl beanManager;
    private final Reception reception;
    protected final RIBean<X> declaringBean;
    protected final MethodInjectionPoint<T, ? super X> observerMethod;
    protected TransactionPhase transactionPhase;
    private final String id;
    private final boolean lifecycle;
    private final Set<WeldInjectionPoint<?, ?>> injectionPoints;
    private final Set<WeldInjectionPoint<?, ?>> newInjectionPoints;

    protected ObserverMethodImpl(WeldMethod<T, ? super X> observer, RIBean<X> declaringBean, BeanManagerImpl manager) {
        this.beanManager = manager;
        this.declaringBean = declaringBean;
        this.observerMethod = MethodInjectionPoint.of(this.beanManager.getContextId(), declaringBean, observer);
        WeldParameter eventArgument = this.observerMethod.getAnnotatedParameters(Observes.class).get(0);
        this.eventType = TypeVariableResolver.resolveVariables(declaringBean.getBeanClass(), eventArgument.getBaseType());
        this.id = ID_PREFIX + ID_SEPARATOR + ObserverMethod.class.getSimpleName() + ID_SEPARATOR + declaringBean.getBeanClass().getName() + "." + observer.getSignature();
        this.bindings = new HashSet<Annotation>(eventArgument.getMetaAnnotations(Qualifier.class));
        this.reception = eventArgument.getAnnotation(Observes.class).notifyObserver();
        this.transactionPhase = ObserverFactory.getTransactionalPhase(observer);
        this.injectionPoints = new HashSet();
        this.newInjectionPoints = new HashSet();
        for (ParameterInjectionPoint<?, ?> injectionPoint : Beans.getParameterInjectionPoints(manager.getContextId(), null, this.observerMethod)) {
            if (injectionPoint.isAnnotationPresent(Observes.class)) continue;
            if (injectionPoint.isAnnotationPresent(New.class)) {
                this.newInjectionPoints.add(injectionPoint);
            }
            this.injectionPoints.add(injectionPoint);
        }
        this.lifecycle = Extension.class.isAssignableFrom(declaringBean.getType());
    }

    public Set<WeldInjectionPoint<?, ?>> getInjectionPoints() {
        return Collections.unmodifiableSet(this.injectionPoints);
    }

    public Set<WeldInjectionPoint<?, ?>> getNewInjectionPoints() {
        return Collections.unmodifiableSet(this.newInjectionPoints);
    }

    private void checkObserverMethod() {
        List eventObjects = this.observerMethod.getAnnotatedParameters(Observes.class);
        if (this.reception.equals((Object)Reception.IF_EXISTS) && this.declaringBean.getScope().equals(Dependent.class)) {
            throw new DefinitionException(EventMessage.INVALID_SCOPED_CONDITIONAL_OBSERVER, this);
        }
        if (eventObjects.size() > 1) {
            throw new DefinitionException(EventMessage.MULTIPLE_EVENT_PARAMETERS, this);
        }
        List disposeParams = this.observerMethod.getAnnotatedParameters(Disposes.class);
        if (disposeParams.size() > 0) {
            throw new DefinitionException(EventMessage.INVALID_DISPOSES_PARAMETER, this);
        }
        if (this.observerMethod.isAnnotationPresent(Produces.class)) {
            throw new DefinitionException(EventMessage.INVALID_PRODUCER, this);
        }
        if (this.observerMethod.isAnnotationPresent(Inject.class)) {
            throw new DefinitionException(EventMessage.INVALID_INITIALIZER, this);
        }
        for (ParameterInjectionPoint<?, X> parameter : this.getMethod().getWeldParameters()) {
            if (!parameter.isAnnotationPresent(Named.class) || !parameter.getAnnotation(Named.class).value().equals("")) continue;
            throw new DefinitionException(ValidatorMessage.NON_FIELD_INJECTION_POINT_CANNOT_USE_NAMED, this.getMethod());
        }
    }

    @Override
    public Class<X> getBeanClass() {
        return this.declaringBean.getType();
    }

    public RIBean<X> getDeclaringBean() {
        return this.declaringBean;
    }

    public Annotation[] getBindingsAsArray() {
        return this.bindings.toArray(new Annotation[this.bindings.size()]);
    }

    @Override
    public Reception getReception() {
        return this.reception;
    }

    @Override
    public Set<Annotation> getObservedQualifiers() {
        return this.bindings;
    }

    @Override
    public Type getObservedType() {
        return this.eventType;
    }

    @Override
    public TransactionPhase getTransactionPhase() {
        return this.transactionPhase;
    }

    public MethodInjectionPoint<T, ? super X> getMethod() {
        return this.observerMethod;
    }

    public void initialize() {
        this.checkObserverMethod();
    }

    @Override
    public void notify(T event) {
        if (this.ignore(event)) {
            return;
        }
        this.sendEvent(event);
    }

    protected void sendEvent(T event) {
        if (this.observerMethod.isStatic()) {
            this.sendEvent(event, null, this.beanManager.createCreationalContext((Contextual)this.declaringBean));
        } else if (this.reception.equals((Object)Reception.IF_EXISTS)) {
            Object receiver = this.getReceiverIfExists();
            if (receiver != null) {
                this.sendEvent(event, receiver, null);
            }
        } else {
            CreationalContext creationalContext = this.beanManager.createCreationalContext((Contextual)this.declaringBean);
            Object receiver = this.beanManager.getReference(this.declaringBean, creationalContext, false);
            this.sendEvent(event, receiver, creationalContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(T event, Object receiver, CreationalContext<?> creationalContext) {
        try {
            if (receiver == null) {
                this.observerMethod.invokeWithSpecialValue(receiver, Observes.class, event, this.beanManager, creationalContext, ObserverException.class);
            } else {
                this.observerMethod.invokeOnInstanceWithSpecialValue(receiver, Observes.class, event, this.beanManager, creationalContext, ObserverException.class);
            }
        }
        finally {
            if (creationalContext != null) {
                creationalContext.release();
            }
        }
    }

    private Object getReceiverIfExists() {
        try {
            return this.beanManager.getReference(this.declaringBean, null, false);
        }
        catch (ContextNotActiveException e) {
            return null;
        }
    }

    protected boolean ignore(T event) {
        Class<?> eventType = event.getClass();
        return !this.lifecycle && AbstractContainerEvent.class.isAssignableFrom(eventType);
    }

    public String toString() {
        return this.observerMethod.toString();
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObserverMethodImpl) {
            ObserverMethodImpl that = (ObserverMethodImpl)obj;
            return this.getId().equals(that.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

