/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.exceptions.UnsupportedOperationException;
import org.jboss.weld.injection.Exceptions;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.introspector.ConstructorSignature;
import org.jboss.weld.introspector.ForwardingWeldConstructor;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldConstructor;
import org.jboss.weld.introspector.WeldParameter;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.reflection.Reflections;

public class ConstructorInjectionPoint<T>
extends ForwardingWeldConstructor<T>
implements WeldInjectionPoint<T, Constructor<T>>,
Serializable {
    @SuppressWarnings(value={"SE_BAD_FIELD"}, justification="If the bean is not serializable, we won't ever try to serialize the injection point")
    private final Bean<T> declaringBean;
    private final WeldConstructor<T> constructor;
    private final String contextId;

    public static <T> ConstructorInjectionPoint<T> of(String contextId, Bean<T> declaringBean, WeldConstructor<T> constructor) {
        return new ConstructorInjectionPoint<T>(contextId, declaringBean, constructor);
    }

    protected ConstructorInjectionPoint(String contextId, Bean<T> declaringBean, WeldConstructor<T> constructor) {
        this.declaringBean = declaringBean;
        this.constructor = constructor;
        this.contextId = contextId;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ConstructorInjectionPoint) {
            ConstructorInjectionPoint ip = (ConstructorInjectionPoint)obj;
            if (AnnotatedTypes.compareAnnotatedCallable(this.constructor, ip.constructor)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.constructor.hashCode();
    }

    @Override
    protected WeldConstructor<T> delegate() {
        return this.constructor;
    }

    @Override
    public Bean<?> getBean() {
        return this.declaringBean;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.delegate().getQualifiers();
    }

    public T newInstance(BeanManagerImpl manager, CreationalContext<?> creationalContext) {
        try {
            return this.delegate().newInstance(this.getParameterValues(this.getWeldParameters(), null, null, manager, creationalContext));
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (InstantiationException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
        catch (InvocationTargetException e) {
            Exceptions.rethrowException(e);
        }
        return null;
    }

    @Override
    public List<ParameterInjectionPoint<?, T>> getWeldParameters() {
        final List delegate = super.getWeldParameters();
        return new ForwardingParameterInjectionPointList(this.contextId){

            protected Bean<T> declaringBean() {
                return ConstructorInjectionPoint.this.declaringBean;
            }

            protected List<? extends WeldParameter<?, T>> delegate() {
                return delegate;
            }
        };
    }

    @Override
    public void inject(Object declaringInstance, Object value) {
        throw new UnsupportedOperationException();
    }

    protected Object[] getParameterValues(List<ParameterInjectionPoint<?, T>> parameters, Object specialVal, Class<? extends Annotation> specialParam, BeanManagerImpl manager, CreationalContext<?> creationalContext) {
        Object[] parameterValues = new Object[parameters.size()];
        Iterator<ParameterInjectionPoint<?, T>> iterator = parameters.iterator();
        for (int i = 0; i < parameterValues.length; ++i) {
            ParameterInjectionPoint<?, T> param = iterator.next();
            parameterValues[i] = specialParam != null && param.isAnnotationPresent(specialParam) ? specialVal : param.getValueToInject(manager, creationalContext);
        }
        return parameterValues;
    }

    @Override
    public Type getType() {
        return this.getJavaClass();
    }

    @Override
    public Member getMember() {
        return this.getJavaMember();
    }

    @Override
    public Annotated getAnnotated() {
        return this.delegate();
    }

    @Override
    public boolean isDelegate() {
        return false;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this.contextId, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException(BeanMessage.PROXY_REQUIRED, new Object[0]);
    }

    private static class SerializationProxy<T>
    extends WeldInjectionPoint.WeldInjectionPointSerializationProxy<T, Constructor<T>> {
        private static final long serialVersionUID = 9181171328831559650L;
        private final ConstructorSignature signature;

        public SerializationProxy(String contextId, ConstructorInjectionPoint<T> injectionPoint) {
            super(contextId, injectionPoint);
            this.signature = injectionPoint.getSignature();
        }

        private Object readResolve() {
            WeldConstructor<T> constructor = this.getWeldConstructor();
            Bean bean = this.getDeclaringBean();
            if (constructor == null || bean == null && this.getDeclaringBeanId() != null) {
                throw new IllegalStateException(ReflectionMessage.UNABLE_TO_GET_CONSTRUCTOR_ON_DESERIALIZATION, this.getDeclaringBeanId(), this.getDeclaringWeldClass(), this.signature);
            }
            return ConstructorInjectionPoint.of(this.contextId, this.getDeclaringBean(), this.getWeldConstructor());
        }

        protected WeldConstructor<T> getWeldConstructor() {
            return this.getDeclaringWeldClass().getDeclaredWeldConstructor(this.signature);
        }

        @Override
        protected WeldClass<T> getDeclaringWeldClass() {
            return (WeldClass)Reflections.cast(super.getDeclaringWeldClass());
        }
    }

    private static abstract class ForwardingParameterInjectionPointList<T, X>
    extends AbstractList<ParameterInjectionPoint<T, X>> {
        private final String contextId;

        public ForwardingParameterInjectionPointList(String contextId) {
            this.contextId = contextId;
        }

        protected abstract List<? extends WeldParameter<T, X>> delegate();

        protected abstract Bean<X> declaringBean();

        @Override
        public ParameterInjectionPoint<T, X> get(int index) {
            return ParameterInjectionPoint.of(this.contextId, this.declaringBean(), this.delegate().get(index));
        }

        @Override
        public int size() {
            return this.delegate().size();
        }
    }
}

