/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Set;
import javax.decorator.Delegate;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.jboss.weld.bean.proxy.DecoratorProxy;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.injection.Exceptions;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.introspector.ForwardingWeldField;
import org.jboss.weld.introspector.WeldClass;
import org.jboss.weld.introspector.WeldField;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.TypeVariableResolver;

public class FieldInjectionPoint<T, X>
extends ForwardingWeldField<T, X>
implements WeldInjectionPoint<T, Field>,
Serializable {
    @SuppressWarnings(value={"SE_BAD_FIELD"}, justification="If the bean is not serializable, we won't ever try to serialize the injection point")
    private final Bean<?> declaringBean;
    private final WeldClass<?> injectionTargetClass;
    private final WeldField<T, X> field;
    private final boolean delegate;
    private final boolean cacheable;
    private Bean<?> cachedBean;
    private Type type;
    private final String contextId;

    public static <T, X> FieldInjectionPoint<T, X> of(String contextId, Bean<?> declaringBean, WeldClass<?> injectionTargetClass, WeldField<T, X> field) {
        return new FieldInjectionPoint<T, X>(contextId, declaringBean, injectionTargetClass, field);
    }

    protected FieldInjectionPoint(String contextId, Bean<?> declaringBean, WeldClass<?> injectionTargetClass, WeldField<T, X> field) {
        this.declaringBean = declaringBean;
        this.injectionTargetClass = injectionTargetClass;
        this.field = field;
        this.contextId = contextId;
        this.delegate = this.isAnnotationPresent(Inject.class) && this.isAnnotationPresent(Delegate.class) && declaringBean instanceof Decorator;
        this.cacheable = !this.delegate && !InjectionPoint.class.isAssignableFrom(((Field)field.getJavaMember()).getType()) && !Instance.class.isAssignableFrom(((Field)field.getJavaMember()).getType());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FieldInjectionPoint) {
            FieldInjectionPoint ip = (FieldInjectionPoint)obj;
            if (AnnotatedTypes.compareAnnotatedField(this.field, ip.field)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.field.hashCode();
    }

    @Override
    protected WeldField<T, X> delegate() {
        return this.field;
    }

    @Override
    public Bean<?> getBean() {
        return this.declaringBean;
    }

    public WeldClass<?> getInjectionTargetClass() {
        return this.injectionTargetClass;
    }

    public WeldField<T, X> getWeldField() {
        return this.field;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.delegate().getQualifiers();
    }

    public void inject(Object declaringInstance, BeanManagerImpl manager, CreationalContext<?> creationalContext) {
        try {
            Object objectToInject;
            Object instanceToInject = declaringInstance;
            if (!(instanceToInject instanceof DecoratorProxy) && declaringInstance instanceof TargetInstanceProxy) {
                instanceToInject = ((TargetInstanceProxy)Reflections.cast(declaringInstance)).getTargetInstance();
            }
            if (!this.cacheable) {
                objectToInject = manager.getInjectableReference(this, creationalContext);
            } else {
                if (this.cachedBean == null) {
                    this.cachedBean = manager.resolve(manager.getBeans(this));
                }
                objectToInject = manager.getReference(this, this.cachedBean, creationalContext);
            }
            this.delegate().set(instanceToInject, objectToInject);
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
    }

    @Override
    public void inject(Object declaringInstance, Object value) {
        try {
            Object instanceToInject = declaringInstance;
            if (!(instanceToInject instanceof DecoratorProxy) && instanceToInject instanceof TargetInstanceProxy) {
                instanceToInject = ((TargetInstanceProxy)Reflections.cast(declaringInstance)).getTargetInstance();
            }
            this.delegate().set(instanceToInject, value);
        }
        catch (IllegalArgumentException e) {
            Exceptions.rethrowException(e);
        }
        catch (IllegalAccessException e) {
            Exceptions.rethrowException(e);
        }
    }

    @Override
    public Annotated getAnnotated() {
        return this.delegate();
    }

    @Override
    public boolean isDelegate() {
        return this.delegate;
    }

    @Override
    public Type getType() {
        if (this.type == null) {
            this.type = TypeVariableResolver.resolveVariables(this.getBean() == null ? this.getInjectionTargetClass().getJavaClass() : this.getBean().getBeanClass(), this.getBaseType());
        }
        return this.type;
    }

    @Override
    public Member getMember() {
        return this.getJavaMember();
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this.contextId, this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException(BeanMessage.PROXY_REQUIRED, new Object[0]);
    }

    private static class SerializationProxy<T>
    extends WeldInjectionPoint.WeldInjectionPointSerializationProxy<T, Field> {
        private static final long serialVersionUID = -3491482804822264969L;
        private final String fieldName;
        private final String injectionTargetClassName;

        public SerializationProxy(String contextId, FieldInjectionPoint<T, ?> injectionPoint) {
            super(contextId, injectionPoint);
            this.fieldName = injectionPoint.getName();
            this.injectionTargetClassName = injectionPoint.getInjectionTargetClass().getName();
        }

        protected WeldClass<?> getInjectionTargetClass() {
            Class<?> clazz = this.getService(ResourceLoader.class).classForName(this.injectionTargetClassName);
            return this.getService(ClassTransformer.class).loadClass(clazz);
        }

        private Object readResolve() {
            WeldField<T, ?> field = this.getWeldField();
            if (field == null || this.getDeclaringBean() == null && this.getDeclaringBeanId() != null) {
                throw new IllegalStateException(ReflectionMessage.UNABLE_TO_GET_FIELD_ON_DESERIALIZATION, this.getDeclaringBeanId(), this.getDeclaringWeldClass(), this.fieldName);
            }
            return FieldInjectionPoint.of(this.contextId, this.getDeclaringBean(), this.getInjectionTargetClass(), this.getWeldField());
        }

        protected WeldField<T, ?> getWeldField() {
            return this.getDeclaringWeldClass().getDeclaredWeldField(this.fieldName);
        }
    }
}

