/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractReceiverBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.attributes.BeanAttributesFactory;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.introspector.WeldParameter;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SecureReflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisposalMethod<X, T>
extends AbstractReceiverBean<X, T, Method> {
    protected MethodInjectionPoint<T, ? super X> disposalMethodInjectionPoint;
    private WeldParameter<?, ? super X> disposesParameter;
    private boolean injectionPointMetadataParameter = false;
    private boolean beanMetadataParameter = false;

    public static <X, T> DisposalMethod<X, T> of(BeanManagerImpl manager, WeldMethod<T, ? super X> method, AbstractClassBean<X> declaringBean) {
        return new DisposalMethod<X, T>(manager, method, declaringBean);
    }

    protected DisposalMethod(BeanManagerImpl beanManager, WeldMethod<T, ? super X> disposalMethod, AbstractClassBean<X> declaringBean) {
        super(BeanAttributesFactory.forDisposerMethod(disposalMethod, declaringBean.isAlternative(), beanManager), DisposalMethod.class.getSimpleName() + "-" + declaringBean.getWeldAnnotated().getName() + disposalMethod.getSignature().toString(), declaringBean, beanManager, beanManager.getServices());
        this.disposalMethodInjectionPoint = MethodInjectionPoint.ofObserverOrDisposerMethod(disposalMethod, this, beanManager);
        this.initType();
        this.addInjectionPoints(Beans.filterOutSpecialParameterInjectionPoints(this.disposalMethodInjectionPoint.getParameterInjectionPoints()));
    }

    private void initDisposesParameter() {
        this.disposesParameter = this.getWeldAnnotated().getWeldParameters(Disposes.class).get(0);
    }

    private void initMetadataParameters() {
        for (Class<?> type : this.getWeldAnnotated().getParameterTypesAsArray()) {
            if (InjectionPoint.class.equals(type)) {
                this.injectionPointMetadataParameter = true;
            }
            if (!Bean.class.equals(Reflections.getRawType(type))) continue;
            this.beanMetadataParameter = true;
        }
    }

    public WeldParameter<?, ? super X> getDisposesParameter() {
        return this.disposesParameter;
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        super.initialize(environment);
        this.checkDisposalMethod();
        this.initDisposesParameter();
        this.initMetadataParameters();
    }

    protected void initType() {
        this.type = (Class)Reflections.cast(this.disposalMethodInjectionPoint.getAnnotated().getWeldParameters(Disposes.class).get(0).getJavaClass());
    }

    @Override
    public WeldMethod<T, ? super X> getWeldAnnotated() {
        return this.disposalMethodInjectionPoint.getAnnotated();
    }

    @Override
    public boolean isPassivationCapableBean() {
        return false;
    }

    @Override
    public boolean isPassivationCapableDependency() {
        return false;
    }

    @Override
    public boolean isProxyable() {
        return true;
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        return null;
    }

    public void invokeDisposeMethod(Object instance, CreationalContext<?> creationalContext) {
        Object receiverInstance = this.getReceiver(creationalContext);
        if (receiverInstance == null) {
            this.disposalMethodInjectionPoint.invokeWithSpecialValue(null, Disposes.class, instance, this.beanManager, creationalContext, IllegalArgumentException.class);
        } else {
            this.disposalMethodInjectionPoint.invokeOnInstanceWithSpecialValue(receiverInstance, Disposes.class, instance, this.beanManager, creationalContext, IllegalArgumentException.class);
        }
    }

    private void checkDisposalMethod() {
        if (!this.disposalMethodInjectionPoint.getAnnotated().getWeldParameters().get(0).isAnnotationPresent(Disposes.class)) {
            throw new DefinitionException(BeanMessage.DISPOSE_NOT_FIRST_PARAM, this.disposalMethodInjectionPoint);
        }
        if (this.disposalMethodInjectionPoint.getAnnotated().getWeldParameters(Disposes.class).size() > 1) {
            throw new DefinitionException(BeanMessage.MULTIPLE_DISPOSE_PARAMS, this.disposalMethodInjectionPoint);
        }
        if (this.disposalMethodInjectionPoint.getAnnotated().getWeldParameters(Observes.class).size() > 0) {
            throw new DefinitionException(BeanMessage.INCONSISTENT_ANNOTATIONS_ON_METHOD, "@Observes", "@Disposes", this.disposalMethodInjectionPoint);
        }
        if (this.disposalMethodInjectionPoint.getAnnotated().getAnnotation(Inject.class) != null) {
            throw new DefinitionException(BeanMessage.INCONSISTENT_ANNOTATIONS_ON_METHOD, "@Intitializer", "@Disposes", this.disposalMethodInjectionPoint);
        }
        if (this.disposalMethodInjectionPoint.getAnnotated().getAnnotation(Produces.class) != null) {
            throw new DefinitionException(BeanMessage.INCONSISTENT_ANNOTATIONS_ON_METHOD, "@Produces", "@Disposes", this.disposalMethodInjectionPoint);
        }
        if (this.getDeclaringBean() instanceof SessionBean) {
            boolean methodDeclaredOnTypes = false;
            for (Type type : this.getDeclaringBean().getTypes()) {
                Class clazz;
                if (!(type instanceof Class) || !SecureReflections.isMethodExists(clazz = (Class)type, this.disposalMethodInjectionPoint.getAnnotated().getName(), this.disposalMethodInjectionPoint.getAnnotated().getParameterTypesAsArray())) continue;
                methodDeclaredOnTypes = true;
            }
            if (!methodDeclaredOnTypes) {
                throw new DefinitionException(BeanMessage.METHOD_NOT_BUSINESS_METHOD, this.getWeldAnnotated(), this.getDeclaringBean());
            }
        }
    }

    @Override
    protected void checkType() {
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }

    @Override
    public AbstractBean<?, ?> getSpecializedBean() {
        return null;
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean hasInjectionPointMetadataParameter() {
        return this.injectionPointMetadataParameter;
    }

    public boolean hasBeanMetadataParameter() {
        return this.beanMetadataParameter;
    }

    @Override
    public String toString() {
        return "Disposer method [" + this.getDisposesParameter().getDeclaringCallable() + "]";
    }
}

