/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.logging.messages.ValidatorMessage;
import org.jboss.weld.manager.Enabled;
import org.jboss.weld.metadata.MetadataImpl;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnabledBuilder {
    private final List<Metadata<Class<?>>> decorators;
    private final List<Metadata<Class<?>>> interceptors;
    private final Set<Metadata<Class<? extends Annotation>>> alternativeStereotypes;
    private final Set<Metadata<Class<?>>> alternativeClasses;

    public static EnabledBuilder of(BeansXml beansXml, ResourceLoader resourceLoader) {
        if (beansXml == null) {
            return new EnabledBuilder();
        }
        ClassLoader classLoader = new ClassLoader(resourceLoader);
        ClassLoader annotationLoader = new ClassLoader(resourceLoader);
        return new EnabledBuilder(new ArrayList(Lists.transform(beansXml.getEnabledDecorators(), classLoader)), new ArrayList(Lists.transform(beansXml.getEnabledInterceptors(), classLoader)), EnabledBuilder.listToSet(Lists.transform(beansXml.getEnabledAlternativeStereotypes(), annotationLoader), ValidatorMessage.ALTERNATIVE_STEREOTYPE_SPECIFIED_MULTIPLE_TIMES), EnabledBuilder.listToSet(Lists.transform(beansXml.getEnabledAlternativeClasses(), classLoader), ValidatorMessage.ALTERNATIVE_BEAN_CLASS_SPECIFIED_MULTIPLE_TIMES));
    }

    protected EnabledBuilder() {
        this(new ArrayList(), new ArrayList(), new HashSet<Metadata<Class<? extends Annotation>>>(), new HashSet());
    }

    protected EnabledBuilder(List<Metadata<Class<?>>> decorators, List<Metadata<Class<?>>> interceptors, Set<Metadata<Class<? extends Annotation>>> alternativeStereotypes, Set<Metadata<Class<?>>> alternativeClasses) {
        this.decorators = decorators;
        this.interceptors = interceptors;
        this.alternativeStereotypes = alternativeStereotypes;
        this.alternativeClasses = alternativeClasses;
    }

    private static <T> Set<T> listToSet(List<T> list, ValidatorMessage duplicateMessage) {
        HashSet<T> result = new HashSet<T>();
        for (T item : list) {
            if (result.add(item)) continue;
            throw new DeploymentException(duplicateMessage, item);
        }
        return result;
    }

    public List<Metadata<Class<?>>> getDecorators() {
        return this.decorators;
    }

    public List<Metadata<Class<?>>> getInterceptors() {
        return this.interceptors;
    }

    public Set<Metadata<Class<? extends Annotation>>> getAlternativeStereotypes() {
        return this.alternativeStereotypes;
    }

    public Set<Metadata<Class<?>>> getAlternativeClasses() {
        return this.alternativeClasses;
    }

    public Enabled create() {
        return new Enabled(new HashSet<Metadata<Class<? extends Annotation>>>(this.alternativeStereotypes), new HashSet(this.alternativeClasses), new ArrayList(this.decorators), new ArrayList(this.interceptors));
    }

    public void clear() {
        this.decorators.clear();
        this.interceptors.clear();
        this.alternativeClasses.clear();
        this.alternativeStereotypes.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassLoader<T>
    implements Function<Metadata<String>, Metadata<Class<? extends T>>> {
        private final ResourceLoader resourceLoader;

        public ClassLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
        }

        @Override
        public Metadata<Class<? extends T>> apply(Metadata<String> from) {
            String location = from.getLocation();
            try {
                return new MetadataImpl<Class<? extends T>>(Reflections.cast(this.resourceLoader.classForName(from.getValue())), location);
            }
            catch (ResourceLoadingException e) {
                throw new DeploymentException(BootstrapMessage.ERROR_LOADING_BEANS_XML_ENTRY, e.getCause(), from.getValue(), from.getLocation());
            }
            catch (Exception e) {
                throw new DeploymentException(BootstrapMessage.ERROR_LOADING_BEANS_XML_ENTRY, (Throwable)e, from.getValue(), from.getLocation());
            }
        }
    }
}

