/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.serialization;

import java.io.IOException;
import java.io.ObjectInputStream;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.Container;
import org.jboss.weld.serialization.SerializableHolder;
import org.jboss.weld.serialization.spi.ContextualStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanHolder<T>
implements SerializableHolder<Bean<T>> {
    private static final long serialVersionUID = -3726981726872809169L;
    private transient Bean<T> bean;
    private final String beanId;

    public static <T> BeanHolder<T> of(Bean<T> bean) {
        return new BeanHolder<T>(bean);
    }

    public BeanHolder(Bean<T> bean) {
        this.bean = bean;
        this.beanId = bean == null ? null : Container.instance().services().get(ContextualStore.class).putIfAbsent(bean);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.beanId != null) {
            this.bean = (Bean)Container.instance().services().get(ContextualStore.class).getContextual(this.beanId);
        }
    }

    @Override
    public Bean<T> get() {
        return this.bean;
    }
}

