/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.serialization;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.introspector.ConstructorSignature;
import org.jboss.weld.introspector.WeldConstructor;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.serialization.AbstractWeldAnnotatedHolder;
import org.jboss.weld.serialization.SerializableHolder;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveredWeldConstructorSerializableHolder<T>
extends AbstractWeldAnnotatedHolder<T>
implements SerializableHolder<WeldConstructor<T>> {
    private static final long serialVersionUID = -3994479067557140156L;
    private final ConstructorSignature signature;
    private transient WeldConstructor<T> constructor;

    public static <T> DiscoveredWeldConstructorSerializableHolder<T> of(WeldConstructor<T> constructor) {
        return new DiscoveredWeldConstructorSerializableHolder<T>(constructor);
    }

    public DiscoveredWeldConstructorSerializableHolder(WeldConstructor<T> constructor) {
        super(constructor.getDeclaringType().getJavaClass());
        this.constructor = constructor;
        this.signature = constructor.getSignature();
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        is.defaultReadObject();
        this.constructor = (WeldConstructor)Reflections.cast(this.getDeclaringWeldClass().getDeclaredWeldConstructor(this.signature));
        if (this.constructor == null) {
            throw new IllegalStateException(ReflectionMessage.UNABLE_TO_GET_CONSTRUCTOR_ON_DESERIALIZATION, this.getDeclaringWeldClass(), this.signature);
        }
    }

    @Override
    public WeldConstructor<T> get() {
        return this.constructor;
    }
}

