/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.serialization;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.introspector.MethodSignature;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.logging.messages.ReflectionMessage;
import org.jboss.weld.serialization.AbstractWeldAnnotatedHolder;
import org.jboss.weld.serialization.SerializableHolder;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveredWeldMethodSerializableHolder<T, X>
extends AbstractWeldAnnotatedHolder<X>
implements SerializableHolder<WeldMethod<T, X>> {
    private static final long serialVersionUID = 1742767397227399280L;
    private final MethodSignature signature;
    private transient WeldMethod<T, X> method;

    public static <T, X> DiscoveredWeldMethodSerializableHolder<T, X> of(WeldMethod<T, X> method) {
        return new DiscoveredWeldMethodSerializableHolder<T, X>(method);
    }

    private DiscoveredWeldMethodSerializableHolder(WeldMethod<T, X> method) {
        super(method.getDeclaringType().getJavaClass());
        this.method = method;
        this.signature = method.getSignature();
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        is.defaultReadObject();
        this.method = (WeldMethod)Reflections.cast(this.getDeclaringWeldClass().getDeclaredWeldMethod(this.signature));
        if (this.method == null) {
            throw new IllegalStateException(ReflectionMessage.UNABLE_TO_GET_METHOD_ON_DESERIALIZATION, this.getDeclaringWeldClass(), this.signature);
        }
    }

    @Override
    public WeldMethod<T, X> get() {
        return this.method;
    }
}

