/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.reflection;

import java.beans.Introspector;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Qualifier;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.reflection.HierarchyDiscovery;
import org.slf4j.cal10n.LocLogger;
import org.slf4j.ext.XLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflections {
    static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.UTIL);
    static final XLogger xLog = LoggerFactory.loggerFactory().getXLogger(Category.UTIL);
    public static final Type[] EMPTY_TYPES = new Type[0];
    public static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    public static final Class<?>[] EMPTY_CLASSES = new Class[0];

    public static Map<Class<?>, Type> buildTypeMap(Set<Type> types) {
        HashMap map = new HashMap();
        for (Type type : types) {
            if (type instanceof Class) {
                map.put((Class)type, type);
                continue;
            }
            if (type instanceof ParameterizedType) {
                if (!(((ParameterizedType)type).getRawType() instanceof Class)) continue;
                map.put((Class)((ParameterizedType)type).getRawType(), type);
                continue;
            }
            if (!(type instanceof TypeVariable)) continue;
        }
        return map;
    }

    public static boolean isCacheable(Set<Annotation> annotations) {
        for (Annotation qualifier : annotations) {
            Class<?> clazz = qualifier.getClass();
            if (!clazz.isAnonymousClass() && (!clazz.isMemberClass() || !Reflections.isStatic(clazz))) continue;
            return false;
        }
        return true;
    }

    public static boolean isCacheable(Annotation[] annotations) {
        for (Annotation qualifier : annotations) {
            Class<?> clazz = qualifier.getClass();
            if (!clazz.isAnonymousClass() && (!clazz.isMemberClass() || !Reflections.isStatic(clazz))) continue;
            return false;
        }
        return true;
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static String getPropertyName(Method method) {
        String methodName = method.getName();
        if (methodName.matches("^(get).*")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.matches("^(is).*")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        return null;
    }

    public static boolean isFinal(Class<?> clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    public static int getNesting(Class<?> clazz) {
        if (clazz.isMemberClass() && !Reflections.isStatic(clazz)) {
            return 1 + Reflections.getNesting(clazz.getDeclaringClass());
        }
        return 0;
    }

    public static boolean isFinal(Member member) {
        return Modifier.isFinal(member.getModifiers());
    }

    public static boolean isPrivate(Member member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    public static boolean isTypeOrAnyMethodFinal(Class<?> type) {
        return Reflections.getNonPrivateFinalMethodOrType(type) != null;
    }

    public static Object getNonPrivateFinalMethodOrType(Class<?> type) {
        if (Reflections.isFinal(type)) {
            return type;
        }
        for (Method method : type.getDeclaredMethods()) {
            if (!Reflections.isFinal(method) || Reflections.isPrivate(method) || Reflections.isStatic(method)) continue;
            return method;
        }
        return null;
    }

    public static boolean isPackagePrivate(int mod) {
        return !Modifier.isPrivate(mod) && !Modifier.isProtected(mod) && !Modifier.isPublic(mod);
    }

    public static boolean isStatic(Class<?> type) {
        return Modifier.isStatic(type.getModifiers());
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public static boolean isTransient(Member member) {
        return Modifier.isTransient(member.getModifiers());
    }

    public static boolean isAbstract(Method method) {
        return Modifier.isAbstract(method.getModifiers());
    }

    public static Type[] getActualTypeArguments(Class<?> clazz) {
        Type type = new HierarchyDiscovery(clazz).getResolvedType();
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return EMPTY_TYPES;
    }

    public static Type[] getActualTypeArguments(Type type) {
        Type resolvedType = new HierarchyDiscovery(type).getResolvedType();
        if (resolvedType instanceof ParameterizedType) {
            return ((ParameterizedType)resolvedType).getActualTypeArguments();
        }
        return EMPTY_TYPES;
    }

    public static boolean isArrayType(Class<?> rawType) {
        return rawType.isArray();
    }

    public static boolean isParameterizedType(Class<?> type) {
        return type.getTypeParameters().length > 0;
    }

    public static boolean isParamerterizedTypeWithWildcard(Class<?> type) {
        if (Reflections.isParameterizedType(type)) {
            return Reflections.containsWildcards(type.getTypeParameters());
        }
        return false;
    }

    public static boolean containsWildcards(Type[] types) {
        for (Type type : types) {
            if (!(type instanceof WildcardType)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean isBindings(Annotation binding) {
        boolean isBindingAnnotation = false;
        if (binding.annotationType().isAnnotationPresent(Qualifier.class) && binding.annotationType().isAnnotationPresent(Retention.class) && binding.annotationType().getAnnotation(Retention.class).value().equals((Object)RetentionPolicy.RUNTIME)) {
            isBindingAnnotation = true;
        }
        return isBindingAnnotation;
    }

    public static boolean isAssignableFrom(Class<?> rawType1, Type[] actualTypeArguments1, Class<?> rawType2, Type[] actualTypeArguments2) {
        return Types.boxedClass(rawType1).isAssignableFrom(Types.boxedClass(rawType2)) && Reflections.isAssignableFrom(actualTypeArguments1, actualTypeArguments2);
    }

    public static boolean matches(Class<?> rawType1, Type[] actualTypeArguments1, Class<?> rawType2, Type[] actualTypeArguments2) {
        return Types.boxedClass(rawType1).equals(Types.boxedClass(rawType2)) && Reflections.isAssignableFrom(actualTypeArguments1, actualTypeArguments2);
    }

    public static boolean isAssignableFrom(Type[] actualTypeArguments1, Type[] actualTypeArguments2) {
        for (int i = 0; i < actualTypeArguments1.length; ++i) {
            Type type1 = actualTypeArguments1[i];
            Object type2 = Object.class;
            if (actualTypeArguments2.length > i) {
                type2 = actualTypeArguments2[i];
            }
            if (Reflections.isAssignableFrom(type1, type2)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAssignableFrom(Type type1, Set<? extends Type> types2) {
        for (Type type : types2) {
            if (!Reflections.isAssignableFrom(type1, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(Type type1, Set<? extends Type> types2) {
        for (Type type : types2) {
            if (!Reflections.matches(type1, type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Type type1, Type[] types2) {
        for (Type type2 : types2) {
            if (!Reflections.isAssignableFrom(type1, type2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Type type1, Type type2) {
        TypeVariable typeVariable;
        WildcardType wildcardType;
        ParameterizedType parameterizedType1;
        Class clazz;
        if (type1 instanceof Class && Reflections.isAssignableFrom(clazz = (Class)type1, EMPTY_TYPES, type2)) {
            return true;
        }
        if (type1 instanceof ParameterizedType && (parameterizedType1 = (ParameterizedType)type1).getRawType() instanceof Class && Reflections.isAssignableFrom((Class)parameterizedType1.getRawType(), parameterizedType1.getActualTypeArguments(), type2)) {
            return true;
        }
        if (type1 instanceof WildcardType && Reflections.isTypeBounded(type2, (wildcardType = (WildcardType)type1).getLowerBounds(), wildcardType.getUpperBounds())) {
            return true;
        }
        if (type2 instanceof WildcardType && Reflections.isTypeBounded(type1, (wildcardType = (WildcardType)type2).getUpperBounds(), wildcardType.getLowerBounds())) {
            return true;
        }
        if (type1 instanceof TypeVariable && Reflections.isTypeBounded(type2, EMPTY_TYPES, (typeVariable = (TypeVariable)type1).getBounds())) {
            return true;
        }
        return type2 instanceof TypeVariable && Reflections.isTypeBounded(type1, (typeVariable = (TypeVariable)type2).getBounds(), EMPTY_TYPES);
    }

    public static boolean matches(Type type1, Type type2) {
        TypeVariable typeVariable;
        WildcardType wildcardType;
        ParameterizedType parameterizedType1;
        Class clazz;
        if (type1 instanceof Class && Reflections.matches(clazz = (Class)type1, EMPTY_TYPES, type2)) {
            return true;
        }
        if (type1 instanceof ParameterizedType && (parameterizedType1 = (ParameterizedType)type1).getRawType() instanceof Class && Reflections.matches((Class)parameterizedType1.getRawType(), parameterizedType1.getActualTypeArguments(), type2)) {
            return true;
        }
        if (type1 instanceof WildcardType && Reflections.isTypeBounded(type2, (wildcardType = (WildcardType)type1).getLowerBounds(), wildcardType.getUpperBounds())) {
            return true;
        }
        if (type2 instanceof WildcardType && Reflections.isTypeBounded(type1, (wildcardType = (WildcardType)type2).getUpperBounds(), wildcardType.getLowerBounds())) {
            return true;
        }
        if (type1 instanceof TypeVariable && Reflections.isTypeBounded(type2, EMPTY_TYPES, (typeVariable = (TypeVariable)type1).getBounds())) {
            return true;
        }
        return type2 instanceof TypeVariable && Reflections.isTypeBounded(type1, (typeVariable = (TypeVariable)type2).getBounds(), EMPTY_TYPES);
    }

    public static boolean isTypeBounded(Type type, Type[] lowerBounds, Type[] upperBounds) {
        if (lowerBounds.length > 0 && !Reflections.isAssignableFrom(type, lowerBounds)) {
            return false;
        }
        return upperBounds.length <= 0 || Reflections.isAssignableFrom(upperBounds, type);
    }

    public static boolean isAssignableFrom(Class<?> rawType1, Type[] actualTypeArguments1, Type type2) {
        TypeVariable typeVariable;
        Class clazz;
        ParameterizedType parameterizedType;
        return type2 instanceof ParameterizedType ? (parameterizedType = (ParameterizedType)type2).getRawType() instanceof Class && Reflections.isAssignableFrom(rawType1, actualTypeArguments1, (Class)parameterizedType.getRawType(), parameterizedType.getActualTypeArguments()) : (type2 instanceof Class ? Reflections.isAssignableFrom(rawType1, actualTypeArguments1, clazz = (Class)type2, EMPTY_TYPES) : type2 instanceof TypeVariable && Reflections.isTypeBounded(rawType1, actualTypeArguments1, (typeVariable = (TypeVariable)type2).getBounds()));
    }

    public static boolean matches(Class<?> rawType1, Type[] actualTypeArguments1, Type type2) {
        Class clazz;
        ParameterizedType parameterizedType;
        return type2 instanceof ParameterizedType ? (parameterizedType = (ParameterizedType)type2).getRawType() instanceof Class && Reflections.matches(rawType1, actualTypeArguments1, (Class)parameterizedType.getRawType(), parameterizedType.getActualTypeArguments()) : type2 instanceof Class && Reflections.matches(rawType1, actualTypeArguments1, clazz = (Class)type2, EMPTY_TYPES);
    }

    public static boolean isAssignableFrom(Set<Type> types1, Set<Type> types2) {
        for (Type type : types1) {
            if (!Reflections.isAssignableFrom(type, types2)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(Set<Type> types1, Set<Type> types2) {
        for (Type type : types1) {
            if (!Reflections.matches(type, types2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Set<Type> types1, Type type2) {
        for (Type type : types1) {
            if (!Reflections.isAssignableFrom(type, type2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAssignableFrom(Type[] types1, Type type2) {
        for (Type type : types1) {
            if (!Reflections.isAssignableFrom(type, type2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSerializable(Class<?> clazz) {
        return clazz.isPrimitive() || Serializable.class.isAssignableFrom(clazz);
    }

    public static boolean isPrimitive(Type type) {
        Class rawType = Reflections.getRawType(type);
        return rawType == null ? false : rawType.isPrimitive();
    }

    public static <T> Class<T> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() instanceof Class) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return null;
    }

    public static boolean isClassLoadable(String className, ResourceLoader resourceLoader) {
        try {
            resourceLoader.classForName(className);
            return true;
        }
        catch (ResourceLoadingException e) {
            return false;
        }
    }

    public static boolean isEnum(Class<?> clazz) {
        return clazz.isEnum() || clazz.getSuperclass() != null && clazz.getSuperclass().isEnum();
    }
}

