/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.enhanced.jlr;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedParameter;
import org.jboss.weld.annotated.enhanced.ConstructorSignature;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedConstructor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedParameter;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.jlr.AbstractEnhancedAnnotatedCallable;
import org.jboss.weld.annotated.enhanced.jlr.ConstructorSignatureImpl;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedParameterImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhancedAnnotatedConstructorImpl<T>
extends AbstractEnhancedAnnotatedCallable<T, T, Constructor<T>>
implements EnhancedAnnotatedConstructor<T> {
    private final List<EnhancedAnnotatedParameter<?, T>> parameters;
    private final ConstructorSignature signature;
    private final AnnotatedConstructor<T> slim;

    public static <T> EnhancedAnnotatedConstructor<T> of(AnnotatedConstructor<T> annotatedConstructor, EnhancedAnnotatedType<T> declaringClass, ClassTransformer classTransformer) {
        return new EnhancedAnnotatedConstructorImpl<T>(annotatedConstructor, EnhancedAnnotatedConstructorImpl.buildAnnotationMap(annotatedConstructor.getAnnotations()), EnhancedAnnotatedConstructorImpl.buildAnnotationMap(annotatedConstructor.getAnnotations()), declaringClass, classTransformer);
    }

    private EnhancedAnnotatedConstructorImpl(AnnotatedConstructor<T> annotatedConstructor, Map<Class<? extends Annotation>, Annotation> annotationMap, Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap, EnhancedAnnotatedType<T> declaringClass, ClassTransformer classTransformer) {
        super(annotatedConstructor, annotationMap, declaredAnnotationMap, classTransformer, declaringClass);
        this.slim = annotatedConstructor;
        ArrayList parameters = new ArrayList();
        EnhancedAnnotatedConstructorImpl.validateParameterCount(annotatedConstructor);
        for (AnnotatedParameter annotatedParameter : annotatedConstructor.getParameters()) {
            EnhancedAnnotatedParameter parameter = EnhancedAnnotatedParameterImpl.of(annotatedParameter, this, classTransformer);
            parameters.add(parameter);
        }
        this.parameters = WeldCollections.immutableList(parameters);
        this.signature = new ConstructorSignatureImpl(this);
    }

    public Constructor<T> getAnnotatedConstructor() {
        return this.slim.getJavaMember();
    }

    @Override
    public Constructor<T> getDelegate() {
        return this.slim.getJavaMember();
    }

    @Override
    public List<EnhancedAnnotatedParameter<?, T>> getEnhancedParameters() {
        return this.parameters;
    }

    @Override
    public List<EnhancedAnnotatedParameter<?, T>> getEnhancedParameters(Class<? extends Annotation> annotationType) {
        ArrayList ret = new ArrayList();
        for (EnhancedAnnotatedParameter<?, T> parameter : this.parameters) {
            if (!parameter.isAnnotationPresent(annotationType)) continue;
            ret.add(parameter);
        }
        return ret;
    }

    public boolean equals(Object other) {
        if (super.equals(other) && other instanceof EnhancedAnnotatedConstructor) {
            EnhancedAnnotatedConstructor that = (EnhancedAnnotatedConstructor)other;
            return ((Constructor)this.getJavaMember()).equals(that.getJavaMember()) && ((Object)this.getEnhancedParameters()).equals(that.getEnhancedParameters());
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + ((Constructor)this.getJavaMember()).hashCode();
        hash = hash * 31 + ((Object)this.getEnhancedParameters()).hashCode();
        return hash;
    }

    @Override
    public String toString() {
        return Formats.formatAnnotatedConstructor(this);
    }

    @Override
    public ConstructorSignature getSignature() {
        return this.signature;
    }

    @Override
    public List<AnnotatedParameter<T>> getParameters() {
        return (List)Reflections.cast(this.parameters);
    }

    @Override
    public boolean isGeneric() {
        return ((Constructor)this.getJavaMember()).getTypeParameters().length > 0;
    }

    @Override
    public AnnotatedConstructor<T> slim() {
        return this.slim;
    }
}

