/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.enhanced.jlr;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.annotated.enhanced.ConstructorSignature;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedConstructor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.annotated.enhanced.jlr.AbstractEnhancedAnnotated;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedConstructorImpl;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedFieldImpl;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedMethodImpl;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.collections.ArraySetMultimap;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhancedAnnotatedTypeImpl<T>
extends AbstractEnhancedAnnotated<T, Class<T>>
implements EnhancedAnnotatedType<T> {
    private final EnhancedAnnotatedType<? super T> superclass;
    private final Set<EnhancedAnnotatedField<?, ? super T>> fields;
    private final ArrayListMultimap<Class<? extends Annotation>, EnhancedAnnotatedField<?, ?>> annotatedFields;
    private final ArraySet<EnhancedAnnotatedField<?, ? super T>> declaredFields;
    private final ArrayListMultimap<Class<? extends Annotation>, EnhancedAnnotatedField<?, ? super T>> declaredAnnotatedFields;
    private final Set<EnhancedAnnotatedMethod<?, ? super T>> methods;
    private final ArrayListMultimap<Class<? extends Annotation>, EnhancedAnnotatedMethod<?, ?>> annotatedMethods;
    private final ArraySet<EnhancedAnnotatedMethod<?, ? super T>> declaredMethods;
    private final ArrayListMultimap<Class<? extends Annotation>, EnhancedAnnotatedMethod<?, ? super T>> declaredAnnotatedMethods;
    private final ArrayListMultimap<Class<? extends Annotation>, EnhancedAnnotatedMethod<?, ? super T>> declaredMethodsByAnnotatedParameters;
    private final ArraySet<EnhancedAnnotatedConstructor<T>> constructors;
    private final Map<ConstructorSignature, EnhancedAnnotatedConstructor<?>> declaredConstructorsBySignature;
    private final Map<Class<? extends Annotation>, List<Annotation>> declaredMetaAnnotationMap;
    private final boolean discovered;
    private final AnnotatedType<T> slim;

    public static <T> EnhancedAnnotatedType<T> of(SlimAnnotatedType<T> annotatedType, ClassTransformer classTransformer) {
        if (annotatedType instanceof BackedAnnotatedType) {
            return new EnhancedAnnotatedTypeImpl<T>(annotatedType, EnhancedAnnotatedTypeImpl.buildAnnotationMap(annotatedType.getAnnotations()), EnhancedAnnotatedTypeImpl.buildAnnotationMap(annotatedType.getJavaClass().getDeclaredAnnotations()), classTransformer);
        }
        return new EnhancedAnnotatedTypeImpl<T>(annotatedType, EnhancedAnnotatedTypeImpl.buildAnnotationMap(annotatedType.getAnnotations()), EnhancedAnnotatedTypeImpl.buildAnnotationMap(annotatedType.getAnnotations()), classTransformer);
    }

    protected EnhancedAnnotatedTypeImpl(SlimAnnotatedType<T> annotatedType, Map<Class<? extends Annotation>, Annotation> annotationMap, Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap, ClassTransformer classTransformer) {
        super(annotatedType, annotationMap, declaredAnnotationMap, classTransformer);
        Class superclass;
        this.slim = annotatedType;
        this.discovered = annotatedType instanceof BackedAnnotatedType;
        this.superclass = this.discovered ? ((superclass = annotatedType.getJavaClass().getSuperclass()) == null ? null : classTransformer.getEnhancedAnnotatedType(superclass)) : classTransformer.getEnhancedAnnotatedType(Object.class);
        this.declaredAnnotatedFields = ArrayListMultimap.create();
        Set<EnhancedAnnotatedField<Object, Object>> fieldsTemp = null;
        ArrayList declaredFieldsTemp = new ArrayList();
        Class javaClass = annotatedType.getJavaClass();
        if (this.discovered) {
            this.annotatedFields = null;
            if (javaClass != Object.class) {
                for (AnnotatedField annotatedField : annotatedType.getFields()) {
                    if (!annotatedField.getJavaMember().getDeclaringClass().equals(javaClass)) continue;
                    EnhancedAnnotatedFieldImpl annotatedField2 = EnhancedAnnotatedFieldImpl.of(annotatedField, this, classTransformer);
                    declaredFieldsTemp.add(annotatedField2);
                    for (Annotation annotation : annotatedField2.getAnnotations()) {
                        this.declaredAnnotatedFields.put(annotation.annotationType(), (Object)annotatedField2);
                    }
                }
                fieldsTemp = new ArraySet(declaredFieldsTemp).trimToSize();
                if (this.superclass != null && this.superclass.getJavaClass() != Object.class) {
                    fieldsTemp = Sets.union(fieldsTemp, (Set)Reflections.cast(this.superclass.getFields()));
                }
            }
            this.declaredFields = new ArraySet(declaredFieldsTemp);
        } else {
            this.annotatedFields = ArrayListMultimap.create();
            fieldsTemp = new HashSet();
            for (AnnotatedField annotatedField : annotatedType.getFields()) {
                EnhancedAnnotatedFieldImpl weldField = EnhancedAnnotatedFieldImpl.of(annotatedField, this, classTransformer);
                fieldsTemp.add(weldField);
                if (annotatedField.getDeclaringType().getJavaClass().equals(javaClass)) {
                    declaredFieldsTemp.add(weldField);
                }
                for (Annotation annotation : weldField.getAnnotations()) {
                    this.annotatedFields.put(annotation.annotationType(), (Object)weldField);
                    if (!annotatedField.getDeclaringType().getJavaClass().equals(javaClass)) continue;
                    this.declaredAnnotatedFields.put(annotation.annotationType(), (Object)weldField);
                }
            }
            this.declaredFields = new ArraySet(declaredFieldsTemp);
            fieldsTemp = new ArraySet(fieldsTemp).trimToSize();
            this.annotatedFields.trimToSize();
        }
        this.fields = fieldsTemp;
        this.declaredFields.trimToSize();
        this.declaredAnnotatedFields.trimToSize();
        this.constructors = new ArraySet();
        this.declaredConstructorsBySignature = new HashMap();
        for (AnnotatedConstructor annotatedConstructor : annotatedType.getConstructors()) {
            EnhancedAnnotatedConstructor weldConstructor = EnhancedAnnotatedConstructorImpl.of(annotatedConstructor, this, classTransformer);
            this.constructors.add(weldConstructor);
            this.declaredConstructorsBySignature.put(weldConstructor.getSignature(), weldConstructor);
        }
        this.constructors.trimToSize();
        this.declaredAnnotatedMethods = ArrayListMultimap.create();
        this.declaredMethodsByAnnotatedParameters = ArrayListMultimap.create();
        Set<EnhancedAnnotatedMethod<Object, Object>> methodsTemp = null;
        ArrayList arrayList = new ArrayList();
        if (this.discovered) {
            this.annotatedMethods = null;
            if (!javaClass.equals(Object.class)) {
                for (AnnotatedMethod method : annotatedType.getMethods()) {
                    if (!method.getJavaMember().getDeclaringClass().equals(javaClass)) continue;
                    EnhancedAnnotatedMethodImpl weldMethod = EnhancedAnnotatedMethodImpl.of(method, this, classTransformer);
                    arrayList.add(weldMethod);
                    for (Annotation annotation : weldMethod.getAnnotations()) {
                        this.declaredAnnotatedMethods.put(annotation.annotationType(), (Object)weldMethod);
                    }
                    for (Class annotationType : EnhancedAnnotatedMethod.MAPPED_PARAMETER_ANNOTATIONS) {
                        if (weldMethod.getEnhancedParameters(annotationType).size() <= 0) continue;
                        this.declaredMethodsByAnnotatedParameters.put((Object)annotationType, weldMethod);
                    }
                }
                methodsTemp = new ArraySet(arrayList).trimToSize();
                if (this.superclass != null) {
                    EnhancedAnnotatedType<T> current = this.superclass;
                    while (current.getJavaClass() != Object.class) {
                        Set superClassMethods = (Set)Reflections.cast(current.getDeclaredEnhancedMethods());
                        methodsTemp = Sets.union(methodsTemp, superClassMethods);
                        current = current.getEnhancedSuperclass();
                    }
                }
            }
            this.declaredMethods = new ArraySet(arrayList);
        } else {
            this.annotatedMethods = ArrayListMultimap.create();
            methodsTemp = new HashSet();
            for (AnnotatedMethod method : annotatedType.getMethods()) {
                EnhancedAnnotatedMethodImpl enhancedMethod = EnhancedAnnotatedMethodImpl.of(method, this, classTransformer);
                methodsTemp.add(enhancedMethod);
                if (method.getJavaMember().getDeclaringClass().equals(javaClass)) {
                    arrayList.add(enhancedMethod);
                }
                for (Annotation annotation : enhancedMethod.getAnnotations()) {
                    this.annotatedMethods.put(annotation.annotationType(), (Object)enhancedMethod);
                    if (!method.getJavaMember().getDeclaringClass().equals(javaClass)) continue;
                    this.declaredAnnotatedMethods.put(annotation.annotationType(), (Object)enhancedMethod);
                }
                for (Class annotationType : EnhancedAnnotatedMethod.MAPPED_PARAMETER_ANNOTATIONS) {
                    if (enhancedMethod.getEnhancedParameters(annotationType).size() <= 0 || !method.getJavaMember().getDeclaringClass().equals(javaClass)) continue;
                    this.declaredMethodsByAnnotatedParameters.put((Object)annotationType, enhancedMethod);
                }
            }
            this.declaredMethods = new ArraySet(arrayList);
            methodsTemp = new ArraySet(methodsTemp).trimToSize();
            this.annotatedMethods.trimToSize();
        }
        this.methods = methodsTemp;
        this.declaredMethods.trimToSize();
        this.declaredAnnotatedMethods.trimToSize();
        this.declaredMethodsByAnnotatedParameters.trimToSize();
        ArraySetMultimap<Class<? extends Annotation>, Annotation> declaredMetaAnnotationMap = new ArraySetMultimap<Class<? extends Annotation>, Annotation>();
        for (Annotation declaredAnnotation : declaredAnnotationMap.values()) {
            EnhancedAnnotatedTypeImpl.addMetaAnnotations(declaredMetaAnnotationMap, declaredAnnotation, declaredAnnotation.annotationType().getAnnotations(), true);
            EnhancedAnnotatedTypeImpl.addMetaAnnotations(declaredMetaAnnotationMap, declaredAnnotation, classTransformer.getTypeStore().get(declaredAnnotation.annotationType()), true);
            declaredMetaAnnotationMap.putSingleElement(declaredAnnotation.annotationType(), declaredAnnotation);
        }
        this.declaredMetaAnnotationMap = WeldCollections.immutableMap(declaredMetaAnnotationMap);
    }

    public Class<? extends T> getAnnotatedClass() {
        return this.getJavaClass();
    }

    @Override
    public Class<T> getDelegate() {
        return this.getJavaClass();
    }

    @Override
    public Collection<EnhancedAnnotatedField<?, ? super T>> getEnhancedFields() {
        return Collections.unmodifiableCollection(this.fields);
    }

    @Override
    public Collection<EnhancedAnnotatedField<?, ? super T>> getDeclaredEnhancedFields() {
        return Collections.unmodifiableCollection(this.declaredFields);
    }

    @Override
    public <F> EnhancedAnnotatedField<F, ?> getDeclaredEnhancedField(String fieldName) {
        for (EnhancedAnnotatedField<?, T> field : this.declaredFields) {
            if (!field.getName().equals(fieldName)) continue;
            return (EnhancedAnnotatedField)this.cast(field);
        }
        return null;
    }

    @Override
    public Collection<EnhancedAnnotatedField<?, ? super T>> getDeclaredEnhancedFields(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableCollection(this.declaredAnnotatedFields.get(annotationType));
    }

    @Override
    public EnhancedAnnotatedConstructor<T> getDeclaredEnhancedConstructor(ConstructorSignature signature) {
        return (EnhancedAnnotatedConstructor)this.cast(this.declaredConstructorsBySignature.get(signature));
    }

    @Override
    public Collection<EnhancedAnnotatedField<?, ?>> getEnhancedFields(Class<? extends Annotation> annotationType) {
        if (this.annotatedFields == null) {
            ArrayList aggregatedFields = new ArrayList(this.declaredAnnotatedFields.get(annotationType));
            if (this.superclass != null && this.superclass.getJavaClass() != Object.class) {
                aggregatedFields.addAll(this.superclass.getEnhancedFields(annotationType));
            }
            return Collections.unmodifiableCollection(aggregatedFields);
        }
        return Collections.unmodifiableCollection(this.annotatedFields.get(annotationType));
    }

    @Override
    public boolean isLocalClass() {
        return this.getJavaClass().isLocalClass();
    }

    @Override
    public boolean isAnonymousClass() {
        return this.getJavaClass().isAnonymousClass();
    }

    @Override
    public boolean isMemberClass() {
        return this.getJavaClass().isMemberClass();
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.getJavaClass().getModifiers());
    }

    @Override
    public boolean isEnum() {
        return this.getJavaClass().isEnum();
    }

    @Override
    public boolean isSerializable() {
        return Reflections.isSerializable(this.getJavaClass());
    }

    @Override
    public Collection<EnhancedAnnotatedMethod<?, ?>> getEnhancedMethods(Class<? extends Annotation> annotationType) {
        if (this.annotatedMethods == null) {
            ArrayList aggregateMethods = new ArrayList(this.declaredAnnotatedMethods.get(annotationType));
            if (this.superclass != null && this.superclass.getJavaClass() != Object.class) {
                aggregateMethods.addAll(this.superclass.getDeclaredEnhancedMethods(annotationType));
            }
            return Collections.unmodifiableCollection(aggregateMethods);
        }
        return Collections.unmodifiableCollection(this.annotatedMethods.get(annotationType));
    }

    @Override
    public Collection<EnhancedAnnotatedMethod<?, ? super T>> getDeclaredEnhancedMethods(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableCollection(this.declaredAnnotatedMethods.get(annotationType));
    }

    @Override
    public Collection<EnhancedAnnotatedConstructor<T>> getEnhancedConstructors() {
        return Collections.unmodifiableCollection(this.constructors);
    }

    @Override
    public Collection<EnhancedAnnotatedConstructor<T>> getEnhancedConstructors(Class<? extends Annotation> annotationType) {
        HashSet<EnhancedAnnotatedConstructor<T>> ret = new HashSet<EnhancedAnnotatedConstructor<T>>();
        for (EnhancedAnnotatedConstructor<T> constructor : this.constructors) {
            if (!constructor.isAnnotationPresent(annotationType)) continue;
            ret.add(constructor);
        }
        return ret;
    }

    @Override
    public EnhancedAnnotatedConstructor<T> getNoArgsEnhancedConstructor() {
        for (EnhancedAnnotatedConstructor<T> constructor : this.constructors) {
            if (((Constructor)constructor.getJavaMember()).getParameterTypes().length != 0) continue;
            return constructor;
        }
        return null;
    }

    @Override
    public Collection<EnhancedAnnotatedMethod<?, ? super T>> getDeclaredEnhancedMethodsWithAnnotatedParameters(Class<? extends Annotation> annotationType) {
        return Collections.unmodifiableCollection(this.declaredMethodsByAnnotatedParameters.get(annotationType));
    }

    @Override
    public EnhancedAnnotatedMethod<?, ?> getEnhancedMethod(Method methodDescriptor) {
        for (EnhancedAnnotatedMethod<?, T> annotatedMethod : this.getEnhancedMethods()) {
            if (!annotatedMethod.getName().equals(methodDescriptor.getName()) || !Arrays.equals(annotatedMethod.getParameterTypesAsArray(), methodDescriptor.getParameterTypes())) continue;
            return annotatedMethod;
        }
        return null;
    }

    @Override
    public Collection<EnhancedAnnotatedMethod<?, ? super T>> getEnhancedMethods() {
        return Collections.unmodifiableSet(this.methods);
    }

    @Override
    public EnhancedAnnotatedMethod<?, ?> getDeclaredEnhancedMethod(Method method) {
        for (EnhancedAnnotatedMethod<?, T> annotatedMethod : this.declaredMethods) {
            if (!annotatedMethod.getName().equals(method.getName()) || !Arrays.equals(annotatedMethod.getParameterTypesAsArray(), method.getParameterTypes())) continue;
            return annotatedMethod;
        }
        return null;
    }

    @Override
    public Collection<EnhancedAnnotatedMethod<?, ? super T>> getDeclaredEnhancedMethods() {
        return Collections.unmodifiableSet(this.declaredMethods);
    }

    @Override
    public <M> EnhancedAnnotatedMethod<M, ?> getDeclaredEnhancedMethod(MethodSignature signature) {
        for (EnhancedAnnotatedMethod<?, T> method : this.declaredMethods) {
            if (!method.getSignature().equals(signature)) continue;
            return (EnhancedAnnotatedMethod)this.cast(method);
        }
        return null;
    }

    @Override
    public <M> EnhancedAnnotatedMethod<M, ?> getEnhancedMethod(MethodSignature signature) {
        EnhancedAnnotatedMethod method = (EnhancedAnnotatedMethod)this.cast(this.getDeclaredEnhancedMethod(signature));
        if (method == null && this.superclass != null && this.superclass.getJavaClass() != Object.class) {
            method = this.superclass.getEnhancedMethod(signature);
        }
        return method;
    }

    public String toString() {
        return Formats.formatAnnotatedType(this);
    }

    @Override
    public String getSimpleName() {
        return this.getJavaClass().getSimpleName();
    }

    @Override
    public boolean isStatic() {
        return Reflections.isStatic(this.getDelegate());
    }

    @Override
    public boolean isFinal() {
        return Reflections.isFinal(this.getDelegate());
    }

    @Override
    public boolean isPublic() {
        return Modifier.isFinal(this.getJavaClass().getModifiers());
    }

    @Override
    public boolean isGeneric() {
        return this.getJavaClass().getTypeParameters().length > 0;
    }

    @Override
    public String getName() {
        return this.getJavaClass().getName();
    }

    @Override
    public EnhancedAnnotatedType<? super T> getEnhancedSuperclass() {
        return this.superclass;
    }

    @Override
    public boolean isEquivalent(Class<?> clazz) {
        return this.getDelegate().equals(clazz);
    }

    @Override
    public boolean isPrivate() {
        return Modifier.isPrivate(this.getJavaClass().getModifiers());
    }

    @Override
    public boolean isPackagePrivate() {
        return Reflections.isPackagePrivate(this.getJavaClass().getModifiers());
    }

    @Override
    public Package getPackage() {
        return this.getJavaClass().getPackage();
    }

    @Override
    public <U> EnhancedAnnotatedType<? extends U> asEnhancedSubclass(EnhancedAnnotatedType<U> clazz) {
        return (EnhancedAnnotatedType)this.cast(this);
    }

    @Override
    public <S> S cast(Object object) {
        return (S)Reflections.cast(object);
    }

    @Override
    public Set<AnnotatedConstructor<T>> getConstructors() {
        return Collections.unmodifiableSet((Set)Reflections.cast(this.constructors));
    }

    @Override
    public Set<AnnotatedField<? super T>> getFields() {
        return (Set)this.cast(this.fields);
    }

    @Override
    public Set<AnnotatedMethod<? super T>> getMethods() {
        return (Set)this.cast(this.methods);
    }

    public Set<Annotation> getDeclaredMetaAnnotations(Class<? extends Annotation> metaAnnotationType) {
        return Collections.unmodifiableSet(new ArraySet(this.declaredMetaAnnotationMap.get(metaAnnotationType)));
    }

    @Override
    public boolean isDiscovered() {
        return this.discovered;
    }

    @Override
    public AnnotatedType<T> slim() {
        return this.slim;
    }
}

