/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim.backed;

import com.google.common.collect.ImmutableSet;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedField;
import org.jboss.weld.Container;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedMember;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.resources.MemberTransformer;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.serialization.FieldHolder;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackedAnnotatedField<X>
extends BackedAnnotatedMember<X>
implements AnnotatedField<X>,
Serializable {
    private final Field field;

    public static <X, Y extends X> AnnotatedField<X> of(Field field, BackedAnnotatedType<Y> declaringType, SharedObjectCache cache) {
        BackedAnnotatedType downcastDeclaringType = (BackedAnnotatedType)Reflections.cast(declaringType);
        return new BackedAnnotatedField<X>(field.getGenericType(), field, downcastDeclaringType, cache);
    }

    public BackedAnnotatedField(Type baseType, Field field, BackedAnnotatedType<X> declaringType, SharedObjectCache cache) {
        super(baseType, declaringType, cache);
        this.field = field;
    }

    @Override
    public Field getJavaMember() {
        return this.field;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return this.field.getAnnotation(annotationType);
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return ImmutableSet.copyOf(this.field.getAnnotations());
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.field.isAnnotationPresent(annotationType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BackedAnnotatedField other = (BackedAnnotatedField)obj;
        return !(this.field == null ? other.field != null : !this.field.equals(other.field));
    }

    public String toString() {
        return Formats.formatAnnotatedField(this);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this.field);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException(BeanMessage.PROXY_REQUIRED, new Object[0]);
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = -8041111397369568219L;
        private final FieldHolder field;

        public SerializationProxy(Field field) {
            this.field = new FieldHolder(field);
        }

        private Object readResolve() {
            return Container.instance().services().get(MemberTransformer.class).loadBackedMember((Member)this.field.get());
        }
    }
}

