/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim.backed;

import com.google.common.collect.ImmutableSet;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedParameter;
import org.jboss.weld.annotated.slim.backed.BackedAnnotated;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.resources.SharedObjectCache;
import org.jboss.weld.resources.SharedObjectFacade;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackedAnnotatedParameter<X>
extends BackedAnnotated
implements AnnotatedParameter<X>,
Serializable {
    private final int position;
    private final AnnotatedCallable<X> declaringCallable;
    private transient Set<Annotation> annotations;

    public static <X> AnnotatedParameter<X> of(Type baseType, Annotation[] annotations, int position, AnnotatedCallable<X> declaringCallable, SharedObjectCache cache) {
        return new BackedAnnotatedParameter<X>(baseType, annotations, position, declaringCallable, cache);
    }

    public BackedAnnotatedParameter(Type baseType, Annotation[] annotations, int position, AnnotatedCallable<X> declaringCallable, SharedObjectCache cache) {
        super(baseType, cache);
        this.position = position;
        this.declaringCallable = declaringCallable;
        this.annotations = SharedObjectFacade.wrap(ImmutableSet.copyOf(annotations));
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public AnnotatedCallable<X> getDeclaringCallable() {
        return this.declaringCallable;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        for (Annotation annotation : this.getAnnotations()) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return (T)((Annotation)Reflections.cast(annotation));
        }
        return null;
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.declaringCallable == null ? 0 : this.declaringCallable.hashCode());
        result = 31 * result + this.position;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BackedAnnotatedParameter other = (BackedAnnotatedParameter)obj;
        if (this.declaringCallable == null ? other.declaringCallable != null : !this.declaringCallable.equals(other.declaringCallable)) {
            return false;
        }
        return this.position == other.position;
    }

    public String toString() {
        return Formats.formatAnnotatedParameter(this);
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException(BeanMessage.PROXY_REQUIRED, new Object[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializationProxy<X>
    implements Serializable {
        private static final long serialVersionUID = 8784172191880064479L;
        private final AnnotatedCallable<X> callable;
        private final int position;

        public SerializationProxy(BackedAnnotatedParameter<X> parameter) {
            this.callable = parameter.getDeclaringCallable();
            this.position = parameter.getPosition();
        }

        private Object readResolve() {
            return this.callable.getParameters().get(this.position);
        }
    }
}

