/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.slim.backed;

import com.google.common.collect.ImmutableSet;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import org.jboss.weld.Container;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.backed.BackedAnnotated;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedConstructor;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedField;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedMethod;
import org.jboss.weld.exceptions.InvalidObjectException;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.LazyValueHolder;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SecureReflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackedAnnotatedType<X>
extends BackedAnnotated
implements SlimAnnotatedType<X>,
Serializable {
    private final Class<X> javaClass;
    private final LazyValueHolder<Set<AnnotatedConstructor<X>>> constructors;
    private final LazyValueHolder<Set<AnnotatedMethod<? super X>>> methods;
    private final LazyValueHolder<Set<AnnotatedField<? super X>>> fields;
    private final ClassTransformer transformer;

    public static <X> BackedAnnotatedType<X> of(Class<X> javaClass, ClassTransformer classTransformer) {
        return BackedAnnotatedType.of(javaClass, javaClass, classTransformer);
    }

    public static <X> BackedAnnotatedType<X> of(Class<X> javaClass, Type baseType, ClassTransformer classTransformer) {
        return new BackedAnnotatedType<X>(javaClass, baseType, classTransformer);
    }

    public BackedAnnotatedType(Class<X> rawType, Type baseType, ClassTransformer classTransformer) {
        super(baseType, classTransformer.getSharedObjectCache());
        this.javaClass = rawType;
        this.transformer = classTransformer;
        this.constructors = new BackedAnnotatedConstructors();
        this.fields = new BackedAnnotatedFields();
        this.methods = new BackedAnnotatedMethods();
    }

    private <T> BackedAnnotatedType<T> getDeclaringAnnotatedType(Member member, ClassTransformer transformer) {
        if (member.getDeclaringClass().equals(this.getJavaClass())) {
            return (BackedAnnotatedType)Reflections.cast(this);
        }
        return transformer.getAnnotatedType((Class)Reflections.cast(member.getDeclaringClass()));
    }

    @Override
    public Class<X> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public Set<AnnotatedConstructor<X>> getConstructors() {
        return this.constructors.get();
    }

    @Override
    public Set<AnnotatedMethod<? super X>> getMethods() {
        return this.methods.get();
    }

    @Override
    public Set<AnnotatedField<? super X>> getFields() {
        return this.fields.get();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return this.javaClass.getAnnotation(annotationType);
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return ImmutableSet.copyOf(this.javaClass.getAnnotations());
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.javaClass.isAnnotationPresent(annotationType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getBaseType() == null ? 0 : this.getBaseType().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BackedAnnotatedType other = (BackedAnnotatedType)obj;
        return !(this.getBaseType() == null ? other.getBaseType() != null : !this.getBaseType().equals(other.getBaseType()));
    }

    public String toString() {
        return Formats.formatAnnotatedType(this);
    }

    public void clear() {
        this.constructors.clear();
        this.fields.clear();
        this.methods.clear();
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializationProxy<X>(this.javaClass);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException(BeanMessage.PROXY_REQUIRED, new Object[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BackedAnnotatedMethods
    extends EagerlyInitializedLazyValueHolder<Set<AnnotatedMethod<? super X>>> {
        private BackedAnnotatedMethods() {
        }

        @Override
        protected Set<AnnotatedMethod<? super X>> computeValue() {
            ArraySet methods = new ArraySet();
            for (Class clazz = BackedAnnotatedType.this.javaClass; clazz != Object.class && clazz != null; clazz = clazz.getSuperclass()) {
                for (Method method : SecureReflections.getDeclaredMethods(clazz)) {
                    methods.add(BackedAnnotatedMethod.of(method, BackedAnnotatedType.this.getDeclaringAnnotatedType(method, BackedAnnotatedType.this.transformer), BackedAnnotatedType.this.transformer.getSharedObjectCache()));
                }
            }
            return WeldCollections.immutableSet(methods);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BackedAnnotatedFields
    extends EagerlyInitializedLazyValueHolder<Set<AnnotatedField<? super X>>> {
        private BackedAnnotatedFields() {
        }

        @Override
        protected Set<AnnotatedField<? super X>> computeValue() {
            ArraySet fields = new ArraySet();
            for (Class clazz = BackedAnnotatedType.this.javaClass; clazz != Object.class && clazz != null; clazz = clazz.getSuperclass()) {
                for (Field field : SecureReflections.getDeclaredFields(clazz)) {
                    fields.add(BackedAnnotatedField.of(field, BackedAnnotatedType.this.getDeclaringAnnotatedType(field, BackedAnnotatedType.this.transformer), BackedAnnotatedType.this.transformer.getSharedObjectCache()));
                }
            }
            return WeldCollections.immutableSet(fields);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BackedAnnotatedConstructors
    extends EagerlyInitializedLazyValueHolder<Set<AnnotatedConstructor<X>>> {
        private BackedAnnotatedConstructors() {
        }

        @Override
        protected Set<AnnotatedConstructor<X>> computeValue() {
            Constructor<?>[] declaredConstructors = SecureReflections.getDeclaredConstructors(BackedAnnotatedType.this.javaClass);
            ArraySet constructors = new ArraySet(declaredConstructors.length);
            for (Constructor<?> constructor : declaredConstructors) {
                Constructor c = (Constructor)Reflections.cast(constructor);
                constructors.add(BackedAnnotatedConstructor.of(c, BackedAnnotatedType.this, BackedAnnotatedType.this.transformer.getSharedObjectCache()));
            }
            return WeldCollections.immutableSet(constructors);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class EagerlyInitializedLazyValueHolder<T>
    extends LazyValueHolder<T> {
        public EagerlyInitializedLazyValueHolder() {
            this.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SerializationProxy<X>
    implements Serializable {
        private static final long serialVersionUID = 6346909556206514705L;
        private final Class<X> javaClass;

        public SerializationProxy(Class<X> javaClass) {
            this.javaClass = javaClass;
        }

        private Object readResolve() {
            return Container.instance().services().get(ClassTransformer.class).getAnnotatedType(this.javaClass);
        }
    }
}

