/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.New;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.inject.Named;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotated;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.attributes.ImmutableBeanAttributes;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.util.BeansClosure;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.collections.WeldCollections;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBean<T, S>
extends RIBean<T> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    protected Class<T> type;
    private Set<WeldInjectionPoint<?, ?>> injectionPoints = new ArraySet();
    private Set<WeldInjectionPoint<?, ?>> delegateInjectionPoints = new ArraySet();
    private Set<WeldInjectionPoint<?, ?>> newInjectionPoints = new ArraySet();
    private final ServiceRegistry services;
    private boolean preInitialized;
    private boolean proxyRequired;

    public AbstractBean(BeanAttributes<T> attributes, String idSuffix, BeanManagerImpl beanManager, ServiceRegistry services) {
        super(attributes, idSuffix, beanManager);
        this.services = services;
    }

    @Override
    public void cleanupAfterBoot() {
        this.injectionPoints = WeldCollections.immutableSet(this.injectionPoints);
        this.delegateInjectionPoints = WeldCollections.immutableSet(this.delegateInjectionPoints);
        this.newInjectionPoints = WeldCollections.immutableSet(this.newInjectionPoints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preInitialize() {
        AbstractBean abstractBean = this;
        synchronized (abstractBean) {
            if (this.isSpecializing() && !this.preInitialized) {
                this.preInitialized = true;
                this.preSpecialize();
                this.specialize();
                this.checkSpecialization();
                this.postSpecialize();
                this.finishSpecialization();
            }
        }
    }

    @Override
    public void internalInitialize(BeanDeployerEnvironment environment) {
        this.preInitialize();
        log.trace(BeanMessage.CREATING_BEAN, this.getType());
        this.checkDelegateInjectionPoints();
        this.proxyRequired = this.getScope() != null ? this.getBeanManager().getServices().get(MetaAnnotationStore.class).getScopeModel(this.getScope()).isNormal() : false;
        log.trace(BeanMessage.QUALIFIERS_USED, this.getQualifiers(), this);
        log.trace(BeanMessage.USING_NAME, this.getName(), this);
        log.trace(BeanMessage.USING_SCOPE, this.getScope(), this);
    }

    protected void checkDelegateInjectionPoints() {
        if (this.delegateInjectionPoints.size() > 0) {
            throw new DefinitionException(BeanMessage.DELEGATE_NOT_ON_DECORATOR, this);
        }
    }

    @Override
    public void initializeAfterBeanDiscovery() {
        this.checkType();
    }

    protected abstract void checkType();

    protected void addInjectionPoint(WeldInjectionPoint<?, ?> injectionPoint) {
        if (injectionPoint.isDelegate()) {
            this.delegateInjectionPoints.add(injectionPoint);
        }
        if (injectionPoint.getQualifier(New.class) != null) {
            this.newInjectionPoints.add(injectionPoint);
        }
        this.injectionPoints.add(injectionPoint);
    }

    protected void addInjectionPoints(Iterable<? extends WeldInjectionPoint<?, ?>> injectionPoints) {
        for (WeldInjectionPoint<?, ?> injectionPoint : injectionPoints) {
            this.addInjectionPoint(injectionPoint);
        }
    }

    protected Set<WeldInjectionPoint<?, ?>> getDelegateInjectionPoints() {
        return this.delegateInjectionPoints;
    }

    protected static Set<Type> getTypedTypes(Map<Class<?>, Type> typeClosure, Class<?> rawType, Typed typed) {
        HashSet<Type> types = new HashSet<Type>();
        for (Class<?> specifiedClass : typed.value()) {
            Type tmp = typeClosure.get(specifiedClass);
            if (tmp == null) {
                throw new DefinitionException(BeanMessage.TYPED_CLASS_NOT_IN_HIERARCHY, specifiedClass.getName(), rawType);
            }
            types.add(tmp);
        }
        types.add((Type)((Object)Object.class));
        return types;
    }

    public void checkSpecialization() {
        if (this.isSpecializing()) {
            if (this.getEnhancedAnnotated().isAnnotationPresent(Named.class) && this.getSpecializedBean().getName() != null) {
                throw new DefinitionException(BeanMessage.NAME_NOT_ALLOWED_ON_SPECIALIZATION, this.getEnhancedAnnotated());
            }
            for (Type type : this.getSpecializedBean().getTypes()) {
                if (this.getTypes().contains(type)) continue;
                throw new DefinitionException(BeanMessage.SPECIALIZING_BEAN_MISSING_SPECIALIZED_TYPE, this, type, this.getSpecializedBean());
            }
        }
    }

    protected void postSpecialize() {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        qualifiers.addAll(this.attributes().getQualifiers());
        qualifiers.addAll(this.getSpecializedBean().getQualifiers());
        String name = this.attributes().getName();
        if (this.isSpecializing() && this.getSpecializedBean().getName() != null) {
            name = this.getSpecializedBean().getName();
        }
        this.setAttributes(new ImmutableBeanAttributes(qualifiers, name, this.attributes()));
    }

    protected void finishSpecialization() {
        BeansClosure closure = BeansClosure.getClosure(this.beanManager);
        closure.addSpecialized(this.getSpecializedBean(), this);
    }

    protected void preSpecialize() {
    }

    protected void specialize() {
    }

    public abstract Annotated getAnnotated();

    public abstract EnhancedAnnotated<T, S> getEnhancedAnnotated();

    public abstract AbstractBean<?, ?> getSpecializedBean();

    @Override
    public Set<WeldInjectionPoint<?, ?>> getWeldInjectionPoints() {
        return this.injectionPoints;
    }

    public Set<WeldInjectionPoint<?, ?>> getNewInjectionPoints() {
        return this.newInjectionPoints;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public boolean isDependent() {
        return Dependent.class.equals(this.getScope());
    }

    public boolean isNormalScoped() {
        return this.getBeanManager().getServices().get(MetaAnnotationStore.class).getScopeModel(this.getScope()).isNormal();
    }

    @Override
    public boolean isSpecializing() {
        return this.getEnhancedAnnotated().isAnnotationPresent(Specializes.class);
    }

    @Override
    public boolean isProxyRequired() {
        return this.proxyRequired;
    }

    protected ServiceRegistry getServices() {
        return this.services;
    }

    public abstract boolean hasDefaultProducer();
}

