/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import org.jboss.weld.Container;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.CustomDecoratorWrapper;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.interceptor.WeldInterceptorClassMetadata;
import org.jboss.weld.bean.interceptor.WeldInterceptorInstantiator;
import org.jboss.weld.bean.proxy.CombinedInterceptorAndDecoratorStackMethodHandler;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.context.CreationalContextImpl;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.injection.CurrentInjectionPoint;
import org.jboss.weld.injection.InjectionContextImpl;
import org.jboss.weld.injection.ProxyClassConstructorInjectionPointWrapper;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.interceptor.proxy.DefaultInvocationContextFactory;
import org.jboss.weld.interceptor.proxy.InterceptorProxyCreatorImpl;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.util.InterceptionUtils;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.BeansClosure;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;
import org.slf4j.ext.XLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedBean<T>
extends AbstractClassBean<T> {
    private static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    private static final XLogger xLog = LoggerFactory.loggerFactory().getXLogger(Category.BEAN);
    private Set<WeldInjectionPoint<?, ?>> ejbInjectionPoints;
    private Set<WeldInjectionPoint<?, ?>> persistenceContextInjectionPoints;
    private Set<WeldInjectionPoint<?, ?>> persistenceUnitInjectionPoints;
    private Set<WeldInjectionPoint<?, ?>> resourceInjectionPoints;
    private ManagedBean<?> specializedBean;
    private final boolean proxiable;

    public static <T> ManagedBean<T> of(BeanAttributes<T> attributes, EnhancedAnnotatedType<T> clazz, BeanManagerImpl beanManager, ServiceRegistry services) {
        if (clazz.isDiscovered()) {
            return new ManagedBean<T>(attributes, clazz, ManagedBean.createSimpleId(ManagedBean.class.getSimpleName(), clazz), beanManager, services);
        }
        return new ManagedBean<T>(attributes, clazz, ManagedBean.createId(ManagedBean.class.getSimpleName(), clazz), beanManager, services);
    }

    protected static String createSimpleId(String beanType, EnhancedAnnotatedType<?> clazz) {
        return beanType + "-" + clazz.getBaseType();
    }

    protected static String createId(String beanType, EnhancedAnnotatedType<?> clazz) {
        return beanType + "-" + AnnotatedTypes.createTypeId(clazz);
    }

    protected ManagedBean(BeanAttributes<T> attributes, EnhancedAnnotatedType<T> type, String idSuffix, BeanManagerImpl beanManager, ServiceRegistry services) {
        super(attributes, type, idSuffix, beanManager, services);
        this.initInitializerMethods(beanManager);
        this.initInjectableFields(beanManager);
        this.proxiable = Proxies.isTypesProxyable(type.getTypeClosure());
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        T instance = this.getInjectionTarget().produce(creationalContext);
        this.getInjectionTarget().inject(instance, creationalContext);
        this.getInjectionTarget().postConstruct(instance);
        return instance;
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        try {
            this.getInjectionTarget().preDestroy(instance);
            if (creationalContext instanceof CreationalContextImpl) {
                ((CreationalContextImpl)creationalContext).release(this, instance);
            } else {
                creationalContext.release();
            }
        }
        catch (Exception e) {
            log.error(BeanMessage.ERROR_DESTROYING, this, instance);
            xLog.throwing(XLogger.Level.DEBUG, e);
        }
    }

    @Override
    public void internalInitialize(BeanDeployerEnvironment environment) {
        super.internalInitialize(environment);
        this.initPostConstruct();
        this.initPreDestroy();
        this.initEEInjectionPoints();
        this.setInjectionTarget(new ManagedBeanInjectionTarget(this));
    }

    @Override
    public void initializeAfterBeanDiscovery() {
        super.initializeAfterBeanDiscovery();
        if (this.getInjectionTarget() instanceof ManagedBeanInjectionTarget) {
            ((ManagedBeanInjectionTarget)Reflections.cast(this.getInjectionTarget())).initializeAfterBeanDiscovery((EnhancedAnnotatedType)this.getEnhancedAnnotated());
        }
    }

    protected T createInstance(CreationalContext<T> ctx) {
        if (!this.isSubclassed()) {
            return this.getConstructor().newInstance(this.beanManager, ctx);
        }
        ProxyClassConstructorInjectionPointWrapper constructorInjectionPointWrapper = new ProxyClassConstructorInjectionPointWrapper(this, this.constructorForEnhancedSubclass, this.getConstructor(), this.beanManager);
        return constructorInjectionPointWrapper.newInstance(this.beanManager, ctx);
    }

    private void initEEInjectionPoints() {
        this.ejbInjectionPoints = Beans.getEjbInjectionPoints(this, this.getEnhancedAnnotated(), this.getBeanManager());
        this.persistenceContextInjectionPoints = Beans.getPersistenceContextInjectionPoints(this, this.getEnhancedAnnotated(), this.getBeanManager());
        this.persistenceUnitInjectionPoints = Beans.getPersistenceUnitInjectionPoints(this, this.getEnhancedAnnotated(), this.getBeanManager());
        this.resourceInjectionPoints = Beans.getResourceInjectionPoints(this, this.getEnhancedAnnotated(), this.beanManager);
    }

    @Override
    protected void checkType() {
        if (this.getEnhancedAnnotated().isAnonymousClass() || this.getEnhancedAnnotated().isMemberClass() && !this.getEnhancedAnnotated().isStatic()) {
            throw new DefinitionException(BeanMessage.SIMPLE_BEAN_AS_NON_STATIC_INNER_CLASS_NOT_ALLOWED, this.type);
        }
        if (!this.isDependent() && this.getEnhancedAnnotated().isParameterizedType()) {
            throw new DefinitionException(BeanMessage.BEAN_MUST_BE_DEPENDENT, this.type);
        }
        boolean passivating = this.beanManager.getServices().get(MetaAnnotationStore.class).getScopeModel(this.getScope()).isPassivating();
        if (passivating && !this.isPassivationCapableBean()) {
            throw new DeploymentException(BeanMessage.PASSIVATING_BEAN_NEEDS_SERIALIZABLE_IMPL, this);
        }
        if (this.hasDecorators()) {
            if (this.getEnhancedAnnotated().isFinal()) {
                throw new DeploymentException(BeanMessage.FINAL_BEAN_CLASS_WITH_DECORATORS_NOT_ALLOWED, this);
            }
            for (Decorator<?> decorator : this.getDecorators()) {
                EnhancedAnnotatedType<?> decoratorClass;
                if (decorator instanceof DecoratorImpl) {
                    DecoratorImpl decoratorBean = (DecoratorImpl)decorator;
                    decoratorClass = decoratorBean.getEnhancedAnnotated();
                } else if (decorator instanceof CustomDecoratorWrapper) {
                    decoratorClass = ((CustomDecoratorWrapper)decorator).getEnhancedAnnotated();
                } else {
                    throw new IllegalStateException(BeanMessage.NON_CONTAINER_DECORATOR, decorator);
                }
                for (EnhancedAnnotatedMethod<?, ?> decoratorMethod : decoratorClass.getEnhancedMethods()) {
                    EnhancedAnnotatedMethod method = this.getEnhancedAnnotated().getEnhancedMethod(decoratorMethod.getSignature());
                    if (method == null || method.isStatic() || method.isPrivate() || !method.isFinal()) continue;
                    throw new DeploymentException(BeanMessage.FINAL_BEAN_CLASS_WITH_INTERCEPTORS_NOT_ALLOWED, method, decoratorMethod);
                }
            }
        }
    }

    @Override
    protected void checkBeanImplementation() {
        super.checkBeanImplementation();
        if (this.isNormalScoped()) {
            for (EnhancedAnnotatedField field : this.getEnhancedAnnotated().getEnhancedFields()) {
                if (!field.isPublic() || field.isStatic()) continue;
                throw new DefinitionException(BeanMessage.PUBLIC_FIELD_ON_NORMAL_SCOPED_BEAN_NOT_ALLOWED, this.getEnhancedAnnotated());
            }
        }
    }

    @Override
    protected void preSpecialize() {
        super.preSpecialize();
        BeansClosure closure = BeansClosure.getClosure(this.beanManager);
        if (closure.isEJB(this.getEnhancedAnnotated().getEnhancedSuperclass())) {
            throw new DefinitionException(BeanMessage.SPECIALIZING_BEAN_MUST_EXTEND_A_BEAN, this);
        }
    }

    @Override
    protected void specialize() {
        BeansClosure closure = BeansClosure.getClosure(this.beanManager);
        Bean<?> specializedBean = closure.getClassBean(this.getEnhancedAnnotated().getEnhancedSuperclass());
        if (specializedBean == null) {
            throw new DefinitionException(BeanMessage.SPECIALIZING_BEAN_MUST_EXTEND_A_BEAN, this);
        }
        if (!(specializedBean instanceof ManagedBean)) {
            throw new DefinitionException(BeanMessage.SPECIALIZING_BEAN_MUST_EXTEND_A_BEAN, this);
        }
        this.specializedBean = (ManagedBean)specializedBean;
    }

    @Override
    public ManagedBean<?> getSpecializedBean() {
        return this.specializedBean;
    }

    @Override
    protected boolean isInterceptionCandidate() {
        return !(this instanceof InterceptorImpl) && !(this instanceof DecoratorImpl);
    }

    protected T applyInterceptors(T instance, CreationalContext<T> creationalContext, WeldInterceptorClassMetadata<T> weldInterceptorClassMetadata) {
        try {
            WeldInterceptorInstantiator<T> interceptorInstantiator = new WeldInterceptorInstantiator<T>(this.beanManager, creationalContext);
            InterceptorProxyCreatorImpl interceptorProxyCreator = new InterceptorProxyCreatorImpl(interceptorInstantiator, new DefaultInvocationContextFactory(), (InterceptionModel)this.beanManager.getInterceptorModelRegistry().get(this.getType()));
            MethodHandler methodHandler = interceptorProxyCreator.createSubclassingMethodHandler(null, weldInterceptorClassMetadata);
            CombinedInterceptorAndDecoratorStackMethodHandler wrapperMethodHandler = (CombinedInterceptorAndDecoratorStackMethodHandler)((ProxyObject)instance).getHandler();
            wrapperMethodHandler.setInterceptorMethodHandler(methodHandler);
        }
        catch (Exception e) {
            throw new DeploymentException(e);
        }
        return instance;
    }

    @Override
    public String toString() {
        return "Managed Bean [" + this.getBeanClass().toString() + "] with qualifiers [" + Formats.formatAnnotations(this.getQualifiers()) + "]";
    }

    @Override
    public boolean isProxyable() {
        return this.proxiable;
    }

    @Override
    public boolean hasDefaultProducer() {
        return this.getInjectionTarget() instanceof ManagedBeanInjectionTarget;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ManagedBeanInjectionTarget<T>
    implements InjectionTarget<T> {
        private final ManagedBean<T> bean;
        private volatile WeldInterceptorClassMetadata<T> weldInterceptorClassMetadata;

        private ManagedBeanInjectionTarget(ManagedBean<T> bean) {
            this.bean = bean;
        }

        private void initializeAfterBeanDiscovery(EnhancedAnnotatedType<T> type) {
            if (this.bean.hasInterceptors()) {
                this.weldInterceptorClassMetadata = WeldInterceptorClassMetadata.of(type);
            }
        }

        protected ManagedBean<T> getBean() {
            return this.bean;
        }

        @Override
        public void inject(final T instance, final CreationalContext<T> ctx) {
            new InjectionContextImpl<T>(this.bean.getBeanManager(), this, (AnnotatedType)this.getBean().getAnnotated(), instance){

                @Override
                public void proceed() {
                    Beans.injectEEFields(instance, ManagedBeanInjectionTarget.this.bean.getBeanManager(), ManagedBeanInjectionTarget.this.bean.ejbInjectionPoints, ManagedBeanInjectionTarget.this.bean.persistenceContextInjectionPoints, ManagedBeanInjectionTarget.this.bean.persistenceUnitInjectionPoints, ManagedBeanInjectionTarget.this.bean.resourceInjectionPoints);
                    Beans.injectFieldsAndInitializers(instance, ctx, ManagedBeanInjectionTarget.this.bean.getBeanManager(), ManagedBeanInjectionTarget.this.bean.getInjectableFields(), ManagedBeanInjectionTarget.this.bean.getInitializerMethods());
                }
            }.run();
        }

        @Override
        public void postConstruct(T instance) {
            if (this.bean.hasInterceptors()) {
                InterceptionUtils.executePostConstruct(instance);
            } else {
                this.bean.defaultPostConstruct(instance);
            }
        }

        @Override
        public void preDestroy(T instance) {
            if (this.bean.hasInterceptors()) {
                InterceptionUtils.executePredestroy(instance);
            } else {
                this.bean.defaultPreDestroy(instance);
            }
        }

        @Override
        public void dispose(T instance) {
        }

        @Override
        public Set<InjectionPoint> getInjectionPoints() {
            return (Set)Reflections.cast(this.bean.getWeldInjectionPoints());
        }

        @Override
        public T produce(CreationalContext<T> ctx) {
            T instance;
            if (!this.bean.hasDecorators()) {
                instance = this.bean.createInstance(ctx);
                if (!this.bean.isDependent()) {
                    ctx.push(instance);
                }
            } else {
                T undecoratedInstance = this.bean.createInstance(ctx);
                instance = this.bean.applyDecorators(undecoratedInstance, ctx, Container.instance().services().get(CurrentInjectionPoint.class).peek());
            }
            if (this.bean.hasInterceptors()) {
                return this.bean.applyInterceptors(instance, ctx, this.weldInterceptorClassMetadata);
            }
            return instance;
        }
    }
}

