/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.reflect.Field;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.inject.Inject;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedField;
import org.jboss.weld.annotated.runtime.RuntimeAnnotatedMembers;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerField<X, T>
extends AbstractProducerBean<X, T, Field> {
    private final AnnotatedField<? super X> annotatedField;
    private volatile EnhancedAnnotatedField<T, ? super X> enhancedAnnotatedField;
    private final boolean proxiable;

    public static <X, T> ProducerField<X, T> of(BeanAttributes<T> attributes, EnhancedAnnotatedField<T, ? super X> field, AbstractClassBean<X> declaringBean, BeanManagerImpl beanManager, ServiceRegistry services) {
        return new ProducerField<X, T>(attributes, field, declaringBean, beanManager, services);
    }

    protected ProducerField(BeanAttributes<T> attributes, EnhancedAnnotatedField<T, ? super X> field, AbstractClassBean<X> declaringBean, BeanManagerImpl manager, ServiceRegistry services) {
        super(attributes, ProducerField.createId(field, declaringBean), declaringBean, manager, services);
        this.enhancedAnnotatedField = field;
        this.annotatedField = field.slim();
        this.initType();
        this.proxiable = Proxies.isTypesProxyable(field.getTypeClosure());
    }

    protected static String createId(EnhancedAnnotatedField<?, ?> field, AbstractClassBean<?> declaringBean) {
        if (declaringBean.getEnhancedAnnotated().isDiscovered()) {
            StringBuilder sb = new StringBuilder();
            sb.append(ProducerField.class.getSimpleName());
            sb.append("-");
            sb.append(declaringBean.getEnhancedAnnotated().getName());
            sb.append(".");
            sb.append(field.getName());
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ProducerField.class.getSimpleName());
        sb.append("-");
        sb.append(AnnotatedTypes.createTypeId(declaringBean.getEnhancedAnnotated()));
        sb.append(".");
        sb.append(AnnotatedTypes.createFieldId(field));
        return sb.toString();
    }

    @Override
    public void internalInitialize(BeanDeployerEnvironment environment) {
        super.internalInitialize(environment);
        this.setProducer(new AbstractProducerBean.AbstractProducer(){

            @Override
            public T produce(Object receiver, CreationalContext<T> creationalContext) {
                if (receiver instanceof TargetInstanceProxy) {
                    receiver = ((TargetInstanceProxy)Reflections.cast(receiver)).getTargetInstance();
                }
                return RuntimeAnnotatedMembers.getFieldValue(ProducerField.this.getAnnotated(), receiver);
            }

            public String toString() {
                return ProducerField.this.getAnnotated().toString();
            }
        });
        this.checkProducerField();
    }

    protected void checkProducerField() {
        if (this.getEnhancedAnnotated().isAnnotationPresent(Inject.class)) {
            throw new DefinitionException(BeanMessage.INJECTED_FIELD_CANNOT_BE_PRODUCER, this.getEnhancedAnnotated(), this.getEnhancedAnnotated().getDeclaringType());
        }
        if (this.getDeclaringBean() instanceof SessionBean && !this.getEnhancedAnnotated().isStatic()) {
            throw new DefinitionException(BeanMessage.PRODUCER_FIELD_ON_SESSION_BEAN_MUST_BE_STATIC, this.getEnhancedAnnotated(), this.getEnhancedAnnotated().getDeclaringType());
        }
    }

    @Override
    public AnnotatedField<? super X> getAnnotated() {
        return this.annotatedField;
    }

    @Override
    public EnhancedAnnotatedField<T, ? super X> getEnhancedAnnotated() {
        return Beans.checkEnhancedAnnotatedAvailable(this.enhancedAnnotatedField);
    }

    @Override
    public void cleanupAfterBoot() {
        super.cleanupAfterBoot();
        this.enhancedAnnotatedField = null;
    }

    @Override
    public AbstractBean<?, ?> getSpecializedBean() {
        return null;
    }

    @Override
    public boolean isSpecializing() {
        return false;
    }

    @Override
    public String toString() {
        return "Producer Field [" + Formats.formatType(this.getAnnotated().getBaseType()) + "] with qualifiers [" + Formats.formatAnnotations(this.getQualifiers()) + "] declared as [" + this.getAnnotated() + "]";
    }

    @Override
    public boolean isProxyable() {
        return this.proxiable;
    }
}

