/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.BeanAttributes;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.AbstractProducerBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.ParameterInjectionPoint;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.BeansClosure;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.SecureReflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProducerMethod<X, T>
extends AbstractProducerBean<X, T, Method> {
    private final MethodInjectionPoint<T, ? super X> method;
    private ProducerMethod<?, ?> specializedBean;
    private final boolean proxiable;
    private volatile EnhancedAnnotatedMethod<T, ? super X> enhancedAnnotatedMethod;

    public static <X, T> ProducerMethod<X, T> of(BeanAttributes<T> attributes, EnhancedAnnotatedMethod<T, ? super X> method, AbstractClassBean<X> declaringBean, BeanManagerImpl beanManager, ServiceRegistry services) {
        return new ProducerMethod<X, T>(attributes, method, declaringBean, beanManager, services);
    }

    protected ProducerMethod(BeanAttributes<T> attributes, EnhancedAnnotatedMethod<T, ? super X> method, AbstractClassBean<X> declaringBean, BeanManagerImpl beanManager, ServiceRegistry services) {
        super(attributes, ProducerMethod.createId(method, declaringBean), declaringBean, beanManager, services);
        this.enhancedAnnotatedMethod = method;
        this.method = MethodInjectionPoint.of(method, this, beanManager);
        this.initType();
        this.initProducerMethodInjectableParameters();
        this.proxiable = Proxies.isTypesProxyable(method.getTypeClosure());
    }

    protected static <T, X> String createId(EnhancedAnnotatedMethod<T, ? super X> method, AbstractClassBean<X> declaringBean) {
        if (declaringBean.getEnhancedAnnotated().isDiscovered()) {
            StringBuilder sb = new StringBuilder();
            sb.append(ProducerMethod.class.getSimpleName());
            sb.append("-");
            sb.append(declaringBean.getEnhancedAnnotated().getName());
            sb.append(method.getSignature().toString());
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ProducerMethod.class.getSimpleName());
        sb.append("-");
        sb.append(AnnotatedTypes.createTypeId(declaringBean.getEnhancedAnnotated()));
        sb.append(AnnotatedTypes.createCallableId(method));
        return sb.toString();
    }

    @Override
    public void internalInitialize(BeanDeployerEnvironment environment) {
        super.internalInitialize(environment);
        this.checkProducerMethod();
        this.setProducer(new AbstractProducerBean.AbstractProducer(){

            @Override
            public T produce(Object receiver, CreationalContext<T> creationalContext) {
                if (receiver != null) {
                    return ProducerMethod.this.method.invokeOnInstance(receiver, ProducerMethod.this.beanManager, creationalContext, CreationException.class);
                }
                return ProducerMethod.this.method.invoke(null, ProducerMethod.this.beanManager, creationalContext, CreationException.class);
            }

            public String toString() {
                return ProducerMethod.this.method.toString();
            }
        });
    }

    protected void initProducerMethodInjectableParameters() {
        for (ParameterInjectionPoint ip : this.method.getParameterInjectionPoints()) {
            this.addInjectionPoint(ip);
        }
    }

    protected void checkProducerMethod() {
        if (this.getEnhancedAnnotated().getEnhancedParameters(Observes.class).size() > 0) {
            throw new DefinitionException(BeanMessage.INCONSISTENT_ANNOTATIONS_ON_METHOD, "@Produces", "@Observes");
        }
        if (this.getEnhancedAnnotated().getEnhancedParameters(Disposes.class).size() > 0) {
            throw new DefinitionException(BeanMessage.INCONSISTENT_ANNOTATIONS_ON_METHOD, "@Produces", "@Disposes");
        }
        if (this.getDeclaringBean() instanceof SessionBean) {
            boolean methodDeclaredOnTypes = false;
            for (Type type : this.getDeclaringBean().getTypes()) {
                if (!(type instanceof Class) || !SecureReflections.isMethodExists((Class)type, this.getEnhancedAnnotated().getName(), this.getEnhancedAnnotated().getParameterTypesAsArray())) continue;
                methodDeclaredOnTypes = true;
            }
            if (!methodDeclaredOnTypes) {
                throw new DefinitionException(BeanMessage.METHOD_NOT_BUSINESS_METHOD, this, this.getDeclaringBean());
            }
        }
    }

    @Override
    public AnnotatedMethod<? super X> getAnnotated() {
        return this.method.getAnnotated();
    }

    @Override
    public EnhancedAnnotatedMethod<T, ? super X> getEnhancedAnnotated() {
        return Beans.checkEnhancedAnnotatedAvailable(this.enhancedAnnotatedMethod);
    }

    @Override
    public void cleanupAfterBoot() {
        super.cleanupAfterBoot();
        this.enhancedAnnotatedMethod = null;
    }

    @Override
    public AbstractBean<?, ?> getSpecializedBean() {
        return this.specializedBean;
    }

    @Override
    protected void preSpecialize() {
        if (this.getDeclaringBean().getEnhancedAnnotated().getEnhancedSuperclass().getDeclaredEnhancedMethod((Method)this.getEnhancedAnnotated().getJavaMember()) == null) {
            throw new DefinitionException(BeanMessage.PRODUCER_METHOD_NOT_SPECIALIZING, this);
        }
    }

    @Override
    protected void specialize() {
        EnhancedAnnotatedMethod<?, ?> superClassMethod;
        BeansClosure closure = BeansClosure.getClosure(this.beanManager);
        ProducerMethod<?, ?> check = closure.getProducerMethod(superClassMethod = this.getDeclaringBean().getEnhancedAnnotated().getEnhancedSuperclass().getEnhancedMethod((Method)this.getEnhancedAnnotated().getJavaMember()));
        if (check == null) {
            throw new IllegalStateException(BeanMessage.PRODUCER_METHOD_NOT_SPECIALIZING, this);
        }
        this.specializedBean = check;
    }

    @Override
    public String toString() {
        return "Producer Method [" + Formats.formatType(this.getAnnotated().getBaseType()) + "] with qualifiers [" + Formats.formatAnnotations(this.getQualifiers()) + "] declared as [" + this.getAnnotated() + "]";
    }

    @Override
    public boolean isProxyable() {
        return this.proxiable;
    }
}

