/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.interceptor.Interceptor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.jlr.MethodSignatureImpl;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.interceptor.InterceptorBindingsAdapter;
import org.jboss.weld.bean.proxy.DecorationHelper;
import org.jboss.weld.bean.proxy.EnterpriseBeanInstance;
import org.jboss.weld.bean.proxy.EnterpriseBeanProxyMethodHandler;
import org.jboss.weld.bean.proxy.EnterpriseProxyFactory;
import org.jboss.weld.bean.proxy.EnterpriseTargetBeanInstance;
import org.jboss.weld.bean.proxy.Marker;
import org.jboss.weld.bean.proxy.ProxyFactory;
import org.jboss.weld.bean.proxy.TargetBeanInstance;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.ejb.api.SessionObjectReference;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;
import org.jboss.weld.ejb.spi.EjbServices;
import org.jboss.weld.exceptions.CreationException;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.exceptions.IllegalArgumentException;
import org.jboss.weld.exceptions.IllegalStateException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.injection.InjectionContextImpl;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.BeansClosure;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SecureReflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionBean<T>
extends AbstractClassBean<T> {
    private final InternalEjbDescriptor<T> ejbDescriptor;
    private Class<T> proxyClass;
    private SessionBean<?> specializedBean;

    public static <T> SessionBean<T> of(BeanAttributes<T> attributes, InternalEjbDescriptor<T> ejbDescriptor, BeanManagerImpl beanManager, EnhancedAnnotatedType<T> type, ServiceRegistry services) {
        return new SessionBean<T>(attributes, type, ejbDescriptor, SessionBean.createId(SessionBean.class.getSimpleName(), ejbDescriptor, type), beanManager, services);
    }

    protected static String createId(String beanType, InternalEjbDescriptor<?> ejbDescriptor) {
        return beanType + "-" + ejbDescriptor.getEjbName();
    }

    protected static String createId(String beanType, InternalEjbDescriptor<?> ejbDescriptor, EnhancedAnnotatedType<?> type) {
        if (type.isDiscovered()) {
            return SessionBean.createId(beanType, ejbDescriptor);
        }
        return beanType + "-" + ejbDescriptor.getEjbName() + AnnotatedTypes.createTypeId(type);
    }

    protected SessionBean(BeanAttributes<T> attributes, EnhancedAnnotatedType<T> type, InternalEjbDescriptor<T> ejbDescriptor, String idSuffix, BeanManagerImpl manager, ServiceRegistry services) {
        super(attributes, type, idSuffix, manager, services);
        this.ejbDescriptor = ejbDescriptor;
        this.initInitializerMethods(this.beanManager);
        this.initInjectableFields(this.beanManager);
    }

    @Override
    public void internalInitialize(BeanDeployerEnvironment environment) {
        super.internalInitialize(environment);
        this.initProxyClass();
        this.checkEJBTypeAllowed();
        this.checkConflictingRoles();
        this.checkObserverMethods();
        this.checkScopeAllowed();
        this.setInjectionTarget(new SessionBeanInjectionTarget());
    }

    @Override
    public void initializeAfterBeanDiscovery() {
        super.initializeAfterBeanDiscovery();
        this.registerInterceptors();
    }

    protected T createInstance(CreationalContext<T> ctx) {
        return this.getConstructor().newInstance(this.beanManager, ctx);
    }

    protected void initProxyClass() {
        this.proxyClass = new EnterpriseProxyFactory(this.getEnhancedAnnotated().getJavaClass(), this).getProxyClass();
    }

    protected void checkConflictingRoles() {
        if (this.getType().isAnnotationPresent(Interceptor.class)) {
            throw new DefinitionException(BeanMessage.EJB_CANNOT_BE_INTERCEPTOR, this.getType());
        }
        if (this.getType().isAnnotationPresent(Decorator.class)) {
            throw new DefinitionException(BeanMessage.EJB_CANNOT_BE_DECORATOR, this.getType());
        }
    }

    protected void checkScopeAllowed() {
        if (this.ejbDescriptor.isStateless() && !this.isDependent()) {
            throw new DefinitionException(BeanMessage.SCOPE_NOT_ALLOWED_ON_STATELESS_SESSION_BEAN, this.getScope(), this.getType());
        }
        if (this.ejbDescriptor.isSingleton() && !this.isDependent() && !this.getScope().equals(ApplicationScoped.class)) {
            throw new DefinitionException(BeanMessage.SCOPE_NOT_ALLOWED_ON_SINGLETON_BEAN, this.getScope(), this.getType());
        }
    }

    @Override
    protected void preSpecialize() {
        super.preSpecialize();
        BeansClosure closure = BeansClosure.getClosure(this.beanManager);
        if (!closure.isEJB(this.getEnhancedAnnotated().getEnhancedSuperclass())) {
            throw new DefinitionException(BeanMessage.SPECIALIZING_ENTERPRISE_BEAN_MUST_EXTEND_AN_ENTERPRISE_BEAN, this);
        }
    }

    @Override
    protected void specialize() {
        BeansClosure closure = BeansClosure.getClosure(this.beanManager);
        Bean<?> specializedBean = closure.getClassBean(this.getEnhancedAnnotated().getEnhancedSuperclass());
        if (specializedBean == null) {
            throw new IllegalStateException(BeanMessage.SPECIALIZING_ENTERPRISE_BEAN_MUST_EXTEND_AN_ENTERPRISE_BEAN, this);
        }
        if (!(specializedBean instanceof SessionBean)) {
            throw new IllegalStateException(BeanMessage.SPECIALIZING_ENTERPRISE_BEAN_MUST_EXTEND_AN_ENTERPRISE_BEAN, this);
        }
        this.specializedBean = (SessionBean)specializedBean;
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        try {
            T instance = SecureReflections.newInstance(this.proxyClass);
            creationalContext.push(instance);
            ProxyFactory.setBeanInstance(instance, new EnterpriseTargetBeanInstance(this.getAnnotated().getJavaClass(), new EnterpriseBeanProxyMethodHandler<T>(this, creationalContext)), this);
            if (this.hasDecorators()) {
                instance = this.applyDecorators(instance, creationalContext, null);
            }
            return instance;
        }
        catch (InstantiationException e) {
            throw new WeldException(BeanMessage.PROXY_INSTANTIATION_FAILED, (Throwable)e, this);
        }
        catch (IllegalAccessException e) {
            throw new WeldException(BeanMessage.PROXY_INSTANTIATION_BEAN_ACCESS_FAILED, (Throwable)e, this);
        }
        catch (Exception e) {
            throw new CreationException(BeanMessage.EJB_NOT_FOUND, (Throwable)e, this.proxyClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T applyDecorators(T instance, CreationalContext<T> creationalContext, InjectionPoint originalInjectionPoint) {
        assert (this.hasDecorators()) : "Bean does not have decorators";
        T proxy = null;
        TargetBeanInstance beanInstance = new TargetBeanInstance(this, instance);
        DecorationHelper decorationHelper = new DecorationHelper(beanInstance, this, this.decoratorProxyFactory.getProxyClass(), this.beanManager, this.getServices().get(ContextualStore.class), this.getDecorators());
        DecorationHelper.push(decorationHelper);
        try {
            proxy = decorationHelper.getNextDelegate(originalInjectionPoint, creationalContext);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            DecorationHelper.pop();
            throw throwable;
        }
        DecorationHelper.pop();
        if (proxy == null) {
            throw new WeldException(BeanMessage.PROXY_INSTANTIATION_FAILED, this);
        }
        return proxy;
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        if (instance == null) {
            throw new IllegalArgumentException(BeanMessage.CANNOT_DESTROY_NULL_BEAN, this);
        }
        if (!(instance instanceof EnterpriseBeanInstance)) {
            throw new IllegalArgumentException(BeanMessage.CANNOT_DESTROY_ENTERPRISE_BEAN_NOT_CREATED, instance);
        }
        EnterpriseBeanInstance enterpriseBeanInstance = (EnterpriseBeanInstance)instance;
        enterpriseBeanInstance.destroy(Marker.INSTANCE, this, creationalContext);
        creationalContext.release();
    }

    private void checkEJBTypeAllowed() {
        if (this.ejbDescriptor.isMessageDriven()) {
            throw new DefinitionException(BeanMessage.MESSAGE_DRIVEN_BEANS_CANNOT_BE_MANAGED, this);
        }
    }

    @Override
    protected void checkType() {
        if (!this.getScope().equals(Dependent.class) && this.getEnhancedAnnotated().isGeneric()) {
            throw new DefinitionException(BeanMessage.GENERIC_SESSION_BEAN_MUST_BE_DEPENDENT, this);
        }
        boolean passivating = this.beanManager.getServices().get(MetaAnnotationStore.class).getScopeModel(this.getScope()).isPassivating();
        if (passivating && !this.isPassivationCapableBean()) {
            throw new DeploymentException(BeanMessage.PASSIVATING_BEAN_NEEDS_SERIALIZABLE_IMPL, this);
        }
    }

    public InternalEjbDescriptor<T> getEjbDescriptor() {
        return this.ejbDescriptor;
    }

    public boolean isClientCanCallRemoveMethods() {
        return this.getEjbDescriptor().isStateful() && this.isDependent();
    }

    @Override
    public AbstractBean<?, ?> getSpecializedBean() {
        return this.specializedBean;
    }

    protected void checkObserverMethods() {
        List observerMethods = Beans.getObserverMethods(this.getEnhancedAnnotated());
        if (!observerMethods.isEmpty()) {
            HashSet<MethodSignatureImpl> businessMethodSignatures = new HashSet<MethodSignatureImpl>();
            for (BusinessInterfaceDescriptor<?> businessInterfaceDescriptor : this.ejbDescriptor.getLocalBusinessInterfaces()) {
                for (Method m : businessInterfaceDescriptor.getInterface().getDeclaredMethods()) {
                    businessMethodSignatures.add(new MethodSignatureImpl(m));
                }
            }
            for (BusinessInterfaceDescriptor<?> businessInterfaceDescriptor : this.ejbDescriptor.getRemoteBusinessInterfaces()) {
                for (Method m : businessInterfaceDescriptor.getInterface().getDeclaredMethods()) {
                    businessMethodSignatures.add(new MethodSignatureImpl(m));
                }
            }
            for (EnhancedAnnotatedMethod enhancedAnnotatedMethod : observerMethods) {
                if (enhancedAnnotatedMethod.isStatic() || businessMethodSignatures.contains(new MethodSignatureImpl(enhancedAnnotatedMethod))) continue;
                throw new DefinitionException(BeanMessage.OBSERVER_METHOD_MUST_BE_STATIC_OR_BUSINESS, enhancedAnnotatedMethod, this.getEnhancedAnnotated());
            }
        }
    }

    public SessionObjectReference createReference() {
        return this.beanManager.getServices().get(EjbServices.class).resolveEjb(this.getEjbDescriptor().delegate());
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    @Override
    protected boolean isInterceptionCandidate() {
        return true;
    }

    protected void registerInterceptors() {
        InterceptionModel model = (InterceptionModel)this.beanManager.getInterceptorModelRegistry().get(this.ejbDescriptor.getBeanClass());
        if (model != null) {
            this.getBeanManager().getServices().get(EjbServices.class).registerInterceptors(this.getEjbDescriptor().delegate(), new InterceptorBindingsAdapter(model));
        }
    }

    @Override
    public String toString() {
        return "Session bean [" + this.getBeanClass() + " with qualifiers [" + Formats.formatAnnotations(this.getQualifiers()) + "]; local interfaces are [" + Formats.formatBusinessInterfaceDescriptors(this.getEjbDescriptor().getLocalBusinessInterfaces()) + "]";
    }

    @Override
    public boolean isProxyable() {
        return true;
    }

    @Override
    public boolean hasDefaultProducer() {
        return this.getInjectionTarget() instanceof SessionBeanInjectionTarget;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SessionBeanInjectionTarget
    implements InjectionTarget<T> {
        private SessionBeanInjectionTarget() {
        }

        @Override
        public void inject(final T instance, final CreationalContext<T> ctx) {
            new InjectionContextImpl<T>(SessionBean.this.getBeanManager(), this, (AnnotatedType)SessionBean.this.getAnnotated(), instance){

                @Override
                public void proceed() {
                    Beans.injectFieldsAndInitializers(instance, ctx, SessionBean.this.getBeanManager(), SessionBean.this.getInjectableFields(), SessionBean.this.getInitializerMethods());
                }
            }.run();
        }

        @Override
        public void postConstruct(T instance) {
            SessionBean.this.defaultPostConstruct(instance);
        }

        @Override
        public void preDestroy(T instance) {
            SessionBean.this.defaultPreDestroy(instance);
        }

        @Override
        public void dispose(T instance) {
        }

        @Override
        public Set<InjectionPoint> getInjectionPoints() {
            return (Set)Reflections.cast(SessionBean.this.getWeldInjectionPoints());
        }

        @Override
        public T produce(CreationalContext<T> ctx) {
            return SessionBean.this.createInstance(ctx);
        }
    }
}

