/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.jboss.classfilewriter.ClassFile;
import org.jboss.classfilewriter.ClassMethod;
import org.jboss.classfilewriter.DuplicateMemberException;
import org.jboss.classfilewriter.code.BranchEnd;
import org.jboss.classfilewriter.code.CodeAttribute;
import org.jboss.weld.Container;
import org.jboss.weld.bean.proxy.BeanInstance;
import org.jboss.weld.bean.proxy.BytecodeMethodResolver;
import org.jboss.weld.bean.proxy.ClassHierarchyComparator;
import org.jboss.weld.bean.proxy.DefaultBytecodeMethodResolver;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.bean.proxy.ProxyMethodHandler;
import org.jboss.weld.bean.proxy.ProxyObject;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.interceptor.proxy.LifecycleMixin;
import org.jboss.weld.interceptor.util.proxy.TargetInstanceProxy;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BeanMessage;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.ProxyServices;
import org.jboss.weld.util.Proxies;
import org.jboss.weld.util.bytecode.Boxing;
import org.jboss.weld.util.bytecode.BytecodeUtils;
import org.jboss.weld.util.bytecode.ClassFileUtils;
import org.jboss.weld.util.bytecode.ConstructorUtils;
import org.jboss.weld.util.bytecode.DeferredBytecode;
import org.jboss.weld.util.bytecode.DescriptorUtils;
import org.jboss.weld.util.bytecode.MethodInformation;
import org.jboss.weld.util.bytecode.RuntimeMethodInformation;
import org.jboss.weld.util.collections.ArraySet;
import org.jboss.weld.util.reflection.Reflections;
import org.jboss.weld.util.reflection.SecureReflections;
import org.jboss.weld.util.reflection.instantiation.InstantiatorFactory;
import org.slf4j.cal10n.LocLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyFactory<T> {
    protected static final LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.BEAN);
    public static final String PROXY_SUFFIX = "$Proxy$";
    public static final String DEFAULT_PROXY_PACKAGE = "org.jboss.weld.proxies";
    private final Class<?> beanType;
    private final Set<Class<?>> additionalInterfaces = new LinkedHashSet();
    private final ClassLoader classLoader;
    private final String baseProxyName;
    private final Bean<?> bean;
    private final Class<?> proxiedBeanType;
    public static final String CONSTRUCTED_FLAG_NAME = "constructed";
    protected static final BytecodeMethodResolver DEFAULT_METHOD_RESOLVER = new DefaultBytecodeMethodResolver();

    public ProxyFactory(Class<?> proxiedBeanType, Set<? extends Type> typeClosure, Bean<?> bean) {
        this(proxiedBeanType, typeClosure, ProxyFactory.getProxyName(proxiedBeanType, typeClosure, bean), bean);
    }

    /*
     * WARNING - void declaration
     */
    public ProxyFactory(Class<?> proxiedBeanType, Set<? extends Type> typeClosure, String proxyName, Bean<?> bean) {
        void var6_10;
        Class clazz;
        this.bean = bean;
        this.proxiedBeanType = proxiedBeanType;
        for (Type type : typeClosure) {
            Class c = Reflections.getRawType(type);
            if (!c.isInterface()) continue;
            this.addInterface(c);
        }
        Proxies.TypeInfo typeInfo = Proxies.TypeInfo.of(typeClosure);
        Class<?> clazz2 = typeInfo.getSuperClass();
        Class clazz3 = clazz = clazz2 == null ? Object.class : clazz2;
        if (clazz.equals(Object.class) && this.additionalInterfaces.isEmpty()) {
            Class<?> clazz4 = proxiedBeanType;
        }
        this.beanType = var6_10;
        this.addDefaultAdditionalInterfaces();
        this.baseProxyName = proxyName;
        this.classLoader = ProxyFactory.resolveClassLoaderForBeanProxy(bean, typeInfo);
        ArrayList list = new ArrayList(this.additionalInterfaces);
        Collections.sort(list, ClassHierarchyComparator.INSTANCE);
        this.additionalInterfaces.clear();
        this.additionalInterfaces.addAll(list);
    }

    static String getProxyName(Class<?> proxiedBeanType, Set<? extends Type> typeClosure, Bean<?> bean) {
        String className;
        String proxyPackage;
        Proxies.TypeInfo typeInfo = Proxies.TypeInfo.of(typeClosure);
        if (proxiedBeanType.equals(Object.class)) {
            Class<?> superInterface = typeInfo.getSuperInterface();
            if (superInterface == null) {
                throw new IllegalArgumentException("Proxied bean type cannot be java.lang.Object without an interface");
            }
            proxyPackage = DEFAULT_PROXY_PACKAGE;
        } else {
            proxyPackage = proxiedBeanType.getPackage() == null ? DEFAULT_PROXY_PACKAGE : proxiedBeanType.getPackage().getName();
        }
        if (typeInfo.getSuperClass() == Object.class) {
            StringBuilder name = new StringBuilder();
            className = ProxyFactory.createCompoundProxyName(bean, typeInfo, name) + PROXY_SUFFIX;
        } else {
            boolean typeModified = false;
            for (Class<?> iface : typeInfo.getInterfaces()) {
                if (iface.isAssignableFrom(typeInfo.getSuperClass())) continue;
                typeModified = true;
                break;
            }
            if (typeModified) {
                StringBuilder name = new StringBuilder(typeInfo.getSuperClass().getSimpleName() + "$");
                className = ProxyFactory.createCompoundProxyName(bean, typeInfo, name) + PROXY_SUFFIX;
            } else {
                className = typeInfo.getSuperClass().getSimpleName() + PROXY_SUFFIX;
            }
        }
        return proxyPackage + '.' + className;
    }

    private static String createCompoundProxyName(Bean<?> bean, Proxies.TypeInfo typeInfo, StringBuilder name) {
        ArrayList<String> interfaces = new ArrayList<String>();
        for (Class<?> type : typeInfo.getInterfaces()) {
            interfaces.add(type.getSimpleName());
        }
        Collections.sort(interfaces);
        for (String iface : interfaces) {
            name.append(iface);
            name.append('$');
        }
        String id = Container.instance().services().get(ContextualStore.class).putIfAbsent(bean);
        name.append(id.hashCode());
        String className = name.toString();
        return className;
    }

    public void addInterface(Class<?> newInterface) {
        if (!newInterface.isInterface()) {
            throw new IllegalArgumentException(newInterface + " is not an interface");
        }
        this.additionalInterfaces.add(newInterface);
    }

    public T create(BeanInstance beanInstance) {
        T proxy;
        Class<T> proxyClass = this.getProxyClass();
        try {
            InstantiatorFactory factory = Container.instance().services().get(InstantiatorFactory.class);
            proxy = factory != null && factory.useInstantiators() ? SecureReflections.newUnsafeInstance(proxyClass) : SecureReflections.newInstance(proxyClass);
        }
        catch (InstantiationException e) {
            throw new DefinitionException(BeanMessage.PROXY_INSTANTIATION_FAILED, (Throwable)e, this);
        }
        catch (IllegalAccessException e) {
            throw new DefinitionException(BeanMessage.PROXY_INSTANTIATION_BEAN_ACCESS_FAILED, (Throwable)e, this);
        }
        ((ProxyObject)proxy).setHandler(new ProxyMethodHandler(beanInstance, this.bean));
        return proxy;
    }

    public Class<T> getProxyClass() {
        String suffix = "_$$_Weld" + this.getProxyNameSuffix();
        String proxyClassName = this.getBaseProxyName();
        if (!proxyClassName.endsWith(suffix)) {
            proxyClassName = proxyClassName + suffix;
        }
        if (proxyClassName.startsWith("java")) {
            proxyClassName = proxyClassName.replaceFirst("java", "org.jboss.weld");
        }
        Class proxyClass = null;
        log.trace("Retrieving/generating proxy class " + proxyClassName);
        try {
            proxyClass = (Class)Reflections.cast(this.classLoader.loadClass(proxyClassName));
        }
        catch (ClassNotFoundException e) {
            try {
                proxyClass = this.createProxyClass(proxyClassName);
            }
            catch (Throwable e1) {
                try {
                    proxyClass = (Class)Reflections.cast(this.classLoader.loadClass(proxyClassName));
                }
                catch (ClassNotFoundException e2) {
                    throw new WeldException(e1);
                }
            }
        }
        return proxyClass;
    }

    protected Class<T> getCachedProxyClass(String proxyClassName) {
        try {
            return (Class)Reflections.cast(this.classLoader.loadClass(proxyClassName));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    protected String getBaseProxyName() {
        return this.baseProxyName;
    }

    public static boolean isProxy(Object proxySuspect) {
        return proxySuspect instanceof ProxyObject;
    }

    public static <T> void setBeanInstance(T proxy, BeanInstance beanInstance, Bean<?> bean) {
        if (proxy instanceof ProxyObject) {
            ProxyObject proxyView = (ProxyObject)proxy;
            proxyView.setHandler(new ProxyMethodHandler(beanInstance, bean));
        }
    }

    protected String getProxyNameSuffix() {
        return PROXY_SUFFIX;
    }

    private void addDefaultAdditionalInterfaces() {
        this.additionalInterfaces.add(Serializable.class);
    }

    protected void addAdditionalInterfaces(Set<Class<?>> interfaces) {
    }

    private Class<T> createProxyClass(String proxyClassName) throws Exception {
        ArraySet specialInterfaces = new ArraySet(3);
        specialInterfaces.add(LifecycleMixin.class);
        specialInterfaces.add(TargetInstanceProxy.class);
        specialInterfaces.add(ProxyObject.class);
        this.addAdditionalInterfaces(specialInterfaces);
        this.additionalInterfaces.removeAll(specialInterfaces);
        ClassFile proxyClassType = null;
        if (this.beanType.isInterface()) {
            proxyClassType = new ClassFile(proxyClassName, Object.class.getName(), new String[0]);
            proxyClassType.addInterface(this.beanType.getName());
        } else {
            proxyClassType = new ClassFile(proxyClassName, this.beanType.getName(), new String[0]);
        }
        for (Class<?> clazz : this.additionalInterfaces) {
            proxyClassType.addInterface(clazz.getName());
        }
        ArrayList<DeferredBytecode> initialValueBytecode = new ArrayList<DeferredBytecode>();
        this.addFields(proxyClassType, initialValueBytecode);
        this.addConstructors(proxyClassType, initialValueBytecode);
        this.addMethods(proxyClassType);
        for (Class<?> specialInterface : specialInterfaces) {
            proxyClassType.addInterface(specialInterface.getName());
        }
        ProtectionDomain domain = this.proxiedBeanType.getProtectionDomain();
        if (this.proxiedBeanType.getPackage() == null || this.proxiedBeanType.equals(Object.class)) {
            domain = ProxyFactory.class.getProtectionDomain();
        }
        Class proxyClass = (Class)Reflections.cast(ClassFileUtils.toClass(proxyClassType, this.classLoader, domain));
        log.trace("Created Proxy class of type " + proxyClass + " supporting interfaces " + Arrays.toString(proxyClass.getInterfaces()));
        return proxyClass;
    }

    protected void addConstructors(ClassFile proxyClassType, List<DeferredBytecode> initialValueBytecode) {
        try {
            if (this.beanType.isInterface()) {
                ConstructorUtils.addDefaultConstructor(proxyClassType, initialValueBytecode);
            } else {
                boolean constructorFound = false;
                for (Constructor<?> constructor : this.beanType.getDeclaredConstructors()) {
                    if ((constructor.getModifiers() & 2) != 0) continue;
                    constructorFound = true;
                    String[] exceptions = new String[constructor.getExceptionTypes().length];
                    for (int i = 0; i < exceptions.length; ++i) {
                        exceptions[i] = constructor.getExceptionTypes()[i].getName();
                    }
                    ConstructorUtils.addConstructor("V", DescriptorUtils.getParameterTypes(constructor.getParameterTypes()), exceptions, proxyClassType, initialValueBytecode);
                }
                if (!constructorFound) {
                    this.addConstructorsForBeanWithPrivateConstructors(proxyClassType);
                }
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    protected void addFields(ClassFile proxyClassType, List<DeferredBytecode> initialValueBytecode) {
        proxyClassType.addField(2, "methodHandler", MethodHandler.class);
        proxyClassType.addField(2, CONSTRUCTED_FLAG_NAME, "Z");
    }

    protected void addMethods(ClassFile proxyClassType) {
        this.addMethodsFromClass(proxyClassType);
        this.addSpecialMethods(proxyClassType);
        this.addSerializationSupport(proxyClassType);
    }

    protected void addSerializationSupport(ClassFile proxyClassType) {
    }

    protected void addMethodsFromClass(ClassFile proxyClassType) {
        try {
            this.generateEqualsMethod(proxyClassType);
            this.generateHashCodeMethod(proxyClassType);
            for (Class<?> cls = this.beanType; cls != null; cls = cls.getSuperclass()) {
                for (Method method : cls.getDeclaredMethods()) {
                    if (Modifier.isStatic(method.getModifiers()) || Modifier.isFinal(method.getModifiers()) || method.getDeclaringClass() == Object.class && !method.getName().equals("toString")) continue;
                    try {
                        RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                        ClassMethod classMethod = proxyClassType.addMethod(method);
                        this.addConstructedGuardToMethodBody(classMethod);
                        this.createForwardingMethodBody(classMethod, methodInfo);
                        log.trace("Adding method " + method);
                    }
                    catch (DuplicateMemberException e) {
                        // empty catch block
                    }
                }
            }
            for (Class<?> c : this.additionalInterfaces) {
                for (Method method : c.getMethods()) {
                    try {
                        RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                        ClassMethod classMethod = proxyClassType.addMethod(method);
                        this.createSpecialMethodBody(classMethod, methodInfo);
                        log.trace("Adding method " + method);
                    }
                    catch (DuplicateMemberException e) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    protected void generateHashCodeMethod(ClassFile proxyClassType) {
    }

    protected void generateEqualsMethod(ClassFile proxyClassType) {
    }

    protected void createSpecialMethodBody(ClassMethod proxyClassType, MethodInformation method) {
        this.createInterceptorBody(proxyClassType, method);
    }

    protected void addConstructedGuardToMethodBody(ClassMethod classMethod) {
        CodeAttribute cond = classMethod.getCodeAttribute();
        cond.aload(0);
        cond.getfield(classMethod.getClassFile().getName(), CONSTRUCTED_FLAG_NAME, "Z");
        BranchEnd jumpMarker = cond.ifne();
        cond.aload(0);
        cond.loadMethodParameters();
        cond.invokespecial(classMethod.getClassFile().getSuperclass(), classMethod.getName(), classMethod.getDescriptor());
        cond.returnInstruction();
        cond.branchEnd(jumpMarker);
    }

    protected void createForwardingMethodBody(ClassMethod classMethod, MethodInformation method) {
        this.createInterceptorBody(classMethod, method);
    }

    protected void createInterceptorBody(ClassMethod classMethod, MethodInformation method) {
        ProxyFactory.invokeMethodHandler(classMethod, method, true, DEFAULT_METHOD_RESOLVER);
    }

    protected static void invokeMethodHandler(ClassMethod classMethod, MethodInformation method, boolean addReturnInstruction, BytecodeMethodResolver bytecodeMethodResolver) {
        CodeAttribute b = classMethod.getCodeAttribute();
        b.aload(0);
        b.getfield(classMethod.getClassFile().getName(), "methodHandler", DescriptorUtils.classToStringRepresentation(MethodHandler.class));
        b.aload(0);
        bytecodeMethodResolver.getDeclaredMethod(classMethod, method.getDeclaringClass(), method.getName(), method.getParameterTypes());
        b.aconstNull();
        b.iconst(method.getParameterTypes().length);
        b.anewarray("java.lang.Object");
        int localVariableCount = 1;
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            String typeString = method.getParameterTypes()[i];
            b.dup();
            b.iconst(i);
            BytecodeUtils.addLoadInstruction(b, typeString, localVariableCount);
            Boxing.boxIfNessesary(b, typeString);
            b.aastore();
            if (DescriptorUtils.isWide(typeString)) {
                localVariableCount += 2;
                continue;
            }
            ++localVariableCount;
        }
        b.invokeinterface(MethodHandler.class.getName(), "invoke", "Ljava/lang/Object;", new String[]{"Ljava/lang/Object;", "Ljava/lang/reflect/Method;", "Ljava/lang/reflect/Method;", "[Ljava/lang/Object;"});
        if (addReturnInstruction) {
            if (method.getReturnType().equals("V")) {
                b.returnInstruction();
            } else if (DescriptorUtils.isPrimitive(method.getReturnType())) {
                Boxing.unbox(b, method.getReturnType());
                b.returnInstruction();
            } else {
                String castType = method.getReturnType();
                if (!method.getReturnType().startsWith("[")) {
                    castType = method.getReturnType().substring(1).substring(0, method.getReturnType().length() - 2);
                }
                b.checkcast(castType);
                b.returnInstruction();
            }
        }
    }

    protected void addSpecialMethods(ClassFile proxyClassType) {
        try {
            for (Method method : LifecycleMixin.class.getDeclaredMethods()) {
                log.trace("Adding method " + method);
                RuntimeMethodInformation methodInfo = new RuntimeMethodInformation(method);
                ClassMethod classMethod = proxyClassType.addMethod(method);
                this.createInterceptorBody(classMethod, methodInfo);
            }
            Method getInstanceMethod = TargetInstanceProxy.class.getDeclaredMethod("getTargetInstance", new Class[0]);
            Method getInstanceClassMethod = TargetInstanceProxy.class.getDeclaredMethod("getTargetClass", new Class[0]);
            RuntimeMethodInformation getInstanceMethodInfo = new RuntimeMethodInformation(getInstanceMethod);
            this.createInterceptorBody(proxyClassType.addMethod(getInstanceMethod), getInstanceMethodInfo);
            RuntimeMethodInformation getInstanceClassMethodInfo = new RuntimeMethodInformation(getInstanceClassMethod);
            this.createInterceptorBody(proxyClassType.addMethod(getInstanceClassMethod), getInstanceClassMethodInfo);
            Method setMethodHandlerMethod = ProxyObject.class.getDeclaredMethod("setHandler", MethodHandler.class);
            ProxyFactory.generateSetMethodHandlerBody(proxyClassType.addMethod(setMethodHandlerMethod));
        }
        catch (Exception e) {
            throw new WeldException(e);
        }
    }

    private static void generateSetMethodHandlerBody(ClassMethod method) {
        CodeAttribute b = method.getCodeAttribute();
        b.aload(0);
        b.aload(1);
        b.putfield(method.getClassFile().getName(), "methodHandler", DescriptorUtils.classToStringRepresentation(MethodHandler.class));
        b.returnInstruction();
    }

    private void addConstructorsForBeanWithPrivateConstructors(ClassFile proxyClassType) {
        ClassMethod ctor = proxyClassType.addMethod(1, "<init>", "V", new String[]{"Ljava/lang/Byte;"});
        CodeAttribute b = ctor.getCodeAttribute();
        b.aload(0);
        b.aconstNull();
        b.aconstNull();
        b.invokespecial(proxyClassType.getName(), "<init>", "(Ljava/lang/Byte;Ljava/lang/Byte;)V");
        b.returnInstruction();
        ctor = proxyClassType.addMethod(1, "<init>", "V", new String[]{"Ljava/lang/Byte;", "Ljava/lang/Byte;"});
        b = ctor.getCodeAttribute();
        b.aload(0);
        b.aconstNull();
        b.invokespecial(proxyClassType.getName(), "<init>", "(Ljava/lang/Byte;)V");
        b.returnInstruction();
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public Set<Class<?>> getAdditionalInterfaces() {
        return this.additionalInterfaces;
    }

    public Bean<?> getBean() {
        return this.bean;
    }

    public static ClassLoader resolveClassLoaderForBeanProxy(Bean<?> bean, Proxies.TypeInfo typeInfo) {
        Class<?> superClass = typeInfo.getSuperClass();
        if (superClass.getName().startsWith("java")) {
            ClassLoader cl = Container.instance().services().get(ProxyServices.class).getClassLoader(bean.getBeanClass());
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            return cl;
        }
        return Container.instance().services().get(ProxyServices.class).getClassLoader(superClass);
    }

    public static ClassLoader resolveClassLoaderForBeanProxy(Bean<?> bean) {
        return ProxyFactory.resolveClassLoaderForBeanProxy(bean, Proxies.TypeInfo.of(bean.getTypes()));
    }
}

