/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.decorator.Decorator;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessBeanAttributes;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.interceptor.Interceptor;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.attributes.BeanAttributesFactory;
import org.jboss.weld.bootstrap.AbstractBeanDeployer;
import org.jboss.weld.bootstrap.BeanDeployerEnvironment;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.events.ProcessAnnotatedTypeFactory;
import org.jboss.weld.bootstrap.events.ProcessAnnotatedTypeImpl;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.enums.EnumInjectionTarget;
import org.jboss.weld.enums.EnumService;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.logging.Category;
import org.jboss.weld.logging.LoggerFactory;
import org.jboss.weld.logging.messages.BootstrapMessage;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.BeansClosure;
import org.jboss.weld.util.reflection.Reflections;
import org.slf4j.cal10n.LocLogger;
import org.slf4j.ext.XLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeployer
extends AbstractBeanDeployer<BeanDeployerEnvironment> {
    private transient LocLogger log = LoggerFactory.loggerFactory().getLogger(Category.CLASS_LOADING);
    private transient XLogger xlog = LoggerFactory.loggerFactory().getXLogger(Category.CLASS_LOADING);
    private final ResourceLoader resourceLoader;
    protected final ClassTransformer classTransformer;

    public BeanDeployer(BeanManagerImpl manager, EjbDescriptors ejbDescriptors, ServiceRegistry services) {
        this(manager, ejbDescriptors, services, BeanDeployerEnvironment.newEnvironment(ejbDescriptors, manager));
    }

    public BeanDeployer(BeanManagerImpl manager, EjbDescriptors ejbDescriptors, ServiceRegistry services, BeanDeployerEnvironment environment) {
        super(manager, services, environment);
        this.resourceLoader = manager.getServices().get(ResourceLoader.class);
        this.classTransformer = manager.getServices().get(ClassTransformer.class);
    }

    public BeanDeployer addClass(String className) {
        Class<?> clazz = null;
        try {
            clazz = this.resourceLoader.classForName(className);
        }
        catch (ResourceLoadingException e) {
            this.log.info(BootstrapMessage.IGNORING_CLASS_DUE_TO_LOADING_ERROR, className);
            this.xlog.catching(XLogger.Level.INFO, e);
        }
        if (clazz != null && !clazz.isAnnotation()) {
            this.preloadContainerLifecycleEvent(ProcessAnnotatedType.class, clazz);
            BackedAnnotatedType<?> annotatedType = null;
            try {
                annotatedType = this.classTransformer.getAnnotatedType(clazz);
            }
            catch (ResourceLoadingException e) {
                this.log.info(BootstrapMessage.IGNORING_CLASS_DUE_TO_LOADING_ERROR, className);
                this.xlog.catching(XLogger.Level.INFO, e);
            }
            if (annotatedType != null) {
                ((BeanDeployerEnvironment)this.getEnvironment()).addAnnotatedType(annotatedType);
            }
        }
        return this;
    }

    public <T> BeanDeployer addSyntheticClass(AnnotatedType<T> annotatedType, Extension extension) {
        SlimAnnotatedType<T> slim = ClassTransformer.instance(this.getManager()).getAnnotatedType(annotatedType);
        ((BeanDeployerEnvironment)this.getEnvironment()).addSyntheticAnnotatedType(slim, extension);
        return this;
    }

    public BeanDeployer addClasses(Iterable<String> classes) {
        for (String className : classes) {
            this.addClass(className);
        }
        return this;
    }

    public void processAnnotatedTypes() {
        HashSet classesToBeAdded = new HashSet();
        HashSet classesToBeRemoved = new HashSet();
        for (AnnotatedType<?> annotatedType : ((BeanDeployerEnvironment)this.getEnvironment()).getAnnotatedTypes()) {
            boolean synthetic = ((BeanDeployerEnvironment)this.getEnvironment()).getAnnotatedTypeSource(annotatedType) != null;
            ProcessAnnotatedTypeImpl<?> event = synthetic ? ProcessAnnotatedTypeFactory.create(this.getManager(), annotatedType, ((BeanDeployerEnvironment)this.getEnvironment()).getAnnotatedTypeSource(annotatedType)) : ProcessAnnotatedTypeFactory.create(this.getManager(), annotatedType);
            event.fire();
            if (event.isVeto()) {
                ((BeanDeployerEnvironment)this.getEnvironment()).vetoJavaClass(annotatedType.getJavaClass());
                classesToBeRemoved.add(annotatedType);
                continue;
            }
            boolean dirty = event.isDirty();
            if (dirty) {
                classesToBeRemoved.add(annotatedType);
                AnnotatedType<?> modifiedType = event.getAnnotatedType();
                annotatedType = modifiedType instanceof SlimAnnotatedType ? modifiedType : this.classTransformer.getAnnotatedType(modifiedType);
            }
            boolean vetoed = Beans.isVetoed(annotatedType);
            if (dirty && !vetoed) {
                classesToBeAdded.add(annotatedType);
            }
            if (dirty || !vetoed) continue;
            ((BeanDeployerEnvironment)this.getEnvironment()).vetoJavaClass(annotatedType.getJavaClass());
            classesToBeRemoved.add(annotatedType);
        }
        ((BeanDeployerEnvironment)this.getEnvironment()).removeAnnotatedTypes(classesToBeRemoved);
        ((BeanDeployerEnvironment)this.getEnvironment()).addAnnotatedTypes(classesToBeAdded);
    }

    public void processEnums() {
        EnumService enumService = this.getManager().getServices().get(EnumService.class);
        for (AnnotatedType<?> annotatedType : ((BeanDeployerEnvironment)this.getEnvironment()).getAnnotatedTypes()) {
            if (!Reflections.isEnum(annotatedType.getJavaClass())) continue;
            enumService.addEnumClass((AnnotatedType)Reflections.cast(annotatedType));
        }
        for (EnumInjectionTarget enumInjectionTarget : enumService.getEnumInjectionTargets()) {
            ((BeanDeployerEnvironment)this.getEnvironment()).addNewBeansFromInjectionPoints(enumInjectionTarget.getNewInjectionPoints());
        }
    }

    public void createClassBeans() {
        HashMultimap<Class<?>, AnnotatedType<?>> otherWeldClasses = HashMultimap.create();
        for (AnnotatedType<?> annotatedType : ((BeanDeployerEnvironment)this.getEnvironment()).getAnnotatedTypes()) {
            this.createClassBean(annotatedType, otherWeldClasses);
        }
        for (InternalEjbDescriptor ejbDescriptor : ((BeanDeployerEnvironment)this.getEnvironment()).getEjbDescriptors()) {
            if (((BeanDeployerEnvironment)this.getEnvironment()).isVetoed(ejbDescriptor.getBeanClass()) || !ejbDescriptor.isSingleton() && !ejbDescriptor.isStateful() && !ejbDescriptor.isStateless()) continue;
            if (otherWeldClasses.containsKey(ejbDescriptor.getBeanClass())) {
                for (AnnotatedType annotatedType : otherWeldClasses.get(ejbDescriptor.getBeanClass())) {
                    EnhancedAnnotatedType weldClass = this.classTransformer.getEnhancedAnnotatedType(annotatedType);
                    this.createSessionBean(ejbDescriptor, (EnhancedAnnotatedType)Reflections.cast(weldClass));
                }
                continue;
            }
            this.createSessionBean(ejbDescriptor);
        }
    }

    protected void createClassBean(AnnotatedType<?> annotatedType, Multimap<Class<?>, AnnotatedType<?>> otherWeldClasses) {
        boolean managedBeanOrDecorator;
        boolean bl = managedBeanOrDecorator = !((BeanDeployerEnvironment)this.getEnvironment()).getEjbDescriptors().contains(annotatedType.getJavaClass()) && Beans.isTypeManagedBeanOrDecoratorOrInterceptor(annotatedType);
        if (managedBeanOrDecorator) {
            this.preloadContainerLifecycleEvent(ProcessInjectionTarget.class, annotatedType.getJavaClass());
            this.preloadContainerLifecycleEvent(ProcessBeanAttributes.class, annotatedType.getJavaClass());
            EnhancedAnnotatedType<?> weldClass = this.classTransformer.getEnhancedAnnotatedType(annotatedType);
            if (weldClass.isAnnotationPresent(Decorator.class)) {
                this.preloadContainerLifecycleEvent(ProcessBean.class, annotatedType.getJavaClass());
                this.validateDecorator(weldClass);
                this.createDecorator(weldClass);
            } else if (weldClass.isAnnotationPresent(Interceptor.class)) {
                this.preloadContainerLifecycleEvent(ProcessBean.class, annotatedType.getJavaClass());
                this.validateInterceptor(weldClass);
                this.createInterceptor(weldClass);
            } else if (!weldClass.isAbstract()) {
                this.preloadContainerLifecycleEvent(ProcessManagedBean.class, annotatedType.getJavaClass());
                this.createManagedBean(weldClass);
            }
        } else {
            otherWeldClasses.put(annotatedType.getJavaClass(), annotatedType);
        }
    }

    public void processClassBeanAttributes() {
        this.preInitializeBeans(((BeanDeployerEnvironment)this.getEnvironment()).getClassBeanMap().values());
        this.preInitializeBeans(((BeanDeployerEnvironment)this.getEnvironment()).getDecorators());
        this.preInitializeBeans(((BeanDeployerEnvironment)this.getEnvironment()).getInterceptors());
        this.processBeanAttributes(((BeanDeployerEnvironment)this.getEnvironment()).getClassBeanMap().values());
        this.processBeanAttributes(((BeanDeployerEnvironment)this.getEnvironment()).getDecorators());
        this.processBeanAttributes(((BeanDeployerEnvironment)this.getEnvironment()).getInterceptors());
    }

    private void preInitializeBeans(Collection<? extends AbstractBean<?, ?>> beans) {
        for (AbstractBean<?, ?> bean : beans) {
            bean.preInitialize();
        }
    }

    protected void processBeanAttributes(Collection<? extends AbstractBean<?, ?>> beans) {
        if (beans.isEmpty()) {
            return;
        }
        HashSet vetoedBeans = new HashSet();
        HashSet<RIBean> previouslySpecializedBeans = new HashSet<RIBean>();
        for (AbstractBean<?, ?> abstractBean : beans) {
            boolean vetoed = this.fireProcessBeanAttributes(abstractBean);
            if (vetoed) {
                vetoedBeans.add(abstractBean);
                continue;
            }
            ((BeanDeployerEnvironment)this.getEnvironment()).addNewBeansFromInjectionPoints(abstractBean);
        }
        for (AbstractBean<Object, Object> abstractBean : vetoedBeans) {
            if (abstractBean.isSpecializing()) {
                BeansClosure.getClosure(this.getManager()).removeSpecialized(abstractBean.getSpecializedBean());
                previouslySpecializedBeans.add(abstractBean.getSpecializedBean());
            }
            ((BeanDeployerEnvironment)this.getEnvironment()).vetoBean(abstractBean);
        }
        this.processBeanAttributes(previouslySpecializedBeans);
    }

    public void createProducersAndObservers() {
        for (AbstractClassBean<?> bean : ((BeanDeployerEnvironment)this.getEnvironment()).getClassBeanMap().values()) {
            this.createObserversProducersDisposers(bean);
        }
    }

    public void processProducerAttributes() {
        this.processBeanAttributes(((BeanDeployerEnvironment)this.getEnvironment()).getProducerFields());
        this.preInitializeBeans(((BeanDeployerEnvironment)this.getEnvironment()).getProducerMethodBeanMap().values());
        this.processBeanAttributes(((BeanDeployerEnvironment)this.getEnvironment()).getProducerMethodBeanMap().values());
    }

    public void createNewBeans() {
        for (EnhancedAnnotatedType<?> enhancedAnnotatedType : ((BeanDeployerEnvironment)this.getEnvironment()).getNewManagedBeanClasses()) {
            this.createNewManagedBean(enhancedAnnotatedType);
        }
        for (Map.Entry entry : ((BeanDeployerEnvironment)this.getEnvironment()).getNewSessionBeanDescriptorsFromInjectionPoint().entrySet()) {
            InternalEjbDescriptor descriptor = (InternalEjbDescriptor)entry.getKey();
            this.createNewSessionBean(descriptor, BeanAttributesFactory.forSessionBean((EnhancedAnnotatedType)entry.getValue(), descriptor, this.getManager()));
        }
    }

    public void deploy() {
        this.initializeBeans();
        this.fireBeanEvents();
        this.deployBeans();
        this.initializeObserverMethods();
        this.deployObserverMethods();
    }

    protected void validateInterceptor(EnhancedAnnotatedType<?> weldClass) {
        if (weldClass.isAnnotationPresent(Decorator.class)) {
            throw new DeploymentException(BootstrapMessage.BEAN_IS_BOTH_INTERCEPTOR_AND_DECORATOR, weldClass.getName());
        }
    }

    protected void validateDecorator(EnhancedAnnotatedType<?> weldClass) {
        if (weldClass.isAnnotationPresent(Interceptor.class)) {
            throw new DefinitionException(BootstrapMessage.BEAN_IS_BOTH_INTERCEPTOR_AND_DECORATOR, weldClass.getName());
        }
    }

    public void doAfterBeanDiscovery(List<? extends Bean<?>> beanList) {
        for (Bean<?> bean : beanList) {
            if (!(bean instanceof RIBean)) continue;
            ((RIBean)bean).initializeAfterBeanDiscovery();
        }
    }

    public void cleanup() {
        ((BeanDeployerEnvironment)this.getEnvironment()).cleanup();
    }
}

