/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.New;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.annotated.slim.backed.BackedAnnotatedType;
import org.jboss.weld.bean.AbstractBean;
import org.jboss.weld.bean.AbstractClassBean;
import org.jboss.weld.bean.DecoratorImpl;
import org.jboss.weld.bean.DisposalMethod;
import org.jboss.weld.bean.InterceptorImpl;
import org.jboss.weld.bean.ManagedBean;
import org.jboss.weld.bean.NewBean;
import org.jboss.weld.bean.NewManagedBean;
import org.jboss.weld.bean.NewSessionBean;
import org.jboss.weld.bean.ProducerField;
import org.jboss.weld.bean.ProducerMethod;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.bean.SessionBean;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bean.builtin.ExtensionBean;
import org.jboss.weld.bootstrap.ObserverInitializationContext;
import org.jboss.weld.ejb.EjbDescriptors;
import org.jboss.weld.ejb.InternalEjbDescriptor;
import org.jboss.weld.injection.WeldInjectionPoint;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resolution.ResolvableBuilder;
import org.jboss.weld.resolution.TypeSafeDisposerResolver;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.AnnotatedTypes;
import org.jboss.weld.util.reflection.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanDeployerEnvironment {
    private final Set<AnnotatedType<?>> annotatedTypes;
    private final Map<AnnotatedType<?>, Extension> annotatedTypeSource;
    private final Set<Class<?>> vetoedClasses;
    private final Map<AnnotatedType<?>, AbstractClassBean<?>> classBeanMap;
    private final Map<WeldMethodKey<?, ?>, ProducerMethod<?, ?>> producerMethodBeanMap;
    private final Set<ProducerField<?, ?>> producerFields;
    private final Set<RIBean<?>> beans;
    private final Set<ObserverInitializationContext<?, ?>> observers;
    private final Set<DisposalMethod<?, ?>> allDisposalBeans;
    private final Set<DisposalMethod<?, ?>> resolvedDisposalBeans;
    private final Set<DecoratorImpl<?>> decorators;
    private final Set<InterceptorImpl<?>> interceptors;
    private final EjbDescriptors ejbDescriptors;
    private final TypeSafeDisposerResolver disposalMethodResolver;
    private final ClassTransformer classTransformer;
    private final Set<EnhancedAnnotatedType<?>> newManagedBeanClasses;
    private final Map<InternalEjbDescriptor<?>, EnhancedAnnotatedType<?>> newSessionBeanDescriptorsFromInjectionPoint;
    private final BeanManagerImpl manager;

    public static BeanDeployerEnvironment newEnvironment(EjbDescriptors ejbDescriptors, BeanManagerImpl manager) {
        return new BeanDeployerEnvironment(ejbDescriptors, manager);
    }

    public static BeanDeployerEnvironment newConcurrentEnvironment(EjbDescriptors ejbDescriptors, BeanManagerImpl manager) {
        return new BeanDeployerEnvironment(Sets.newSetFromMap(new ConcurrentHashMap()), new ConcurrentHashMap(), Sets.newSetFromMap(new ConcurrentHashMap()), new ConcurrentHashMap(), Sets.newSetFromMap(new ConcurrentHashMap()), new ConcurrentHashMap(), Sets.newSetFromMap(new ConcurrentHashMap()), Sets.newSetFromMap(new ConcurrentHashMap()), Sets.newSetFromMap(new ConcurrentHashMap()), Sets.newSetFromMap(new ConcurrentHashMap()), Sets.newSetFromMap(new ConcurrentHashMap()), Sets.newSetFromMap(new ConcurrentHashMap()), ejbDescriptors, Sets.newSetFromMap(new ConcurrentHashMap()), new ConcurrentHashMap(), manager);
    }

    protected BeanDeployerEnvironment(Set<AnnotatedType<?>> annotatedTypes, Map<AnnotatedType<?>, Extension> annotatedTypeSource, Set<Class<?>> vetoedClasses, Map<AnnotatedType<?>, AbstractClassBean<?>> classBeanMap, Set<ProducerField<?, ?>> producerFields, Map<WeldMethodKey<?, ?>, ProducerMethod<?, ?>> producerMethodBeanMap, Set<RIBean<?>> beans, Set<ObserverInitializationContext<?, ?>> observers, Set<DisposalMethod<?, ?>> allDisposalBeans, Set<DisposalMethod<?, ?>> resolvedDisposalBeans, Set<DecoratorImpl<?>> decorators, Set<InterceptorImpl<?>> interceptors, EjbDescriptors ejbDescriptors, Set<EnhancedAnnotatedType<?>> newManagedBeanClasses, Map<InternalEjbDescriptor<?>, EnhancedAnnotatedType<?>> newSessionBeanDescriptorsFromInjectionPoint, BeanManagerImpl manager) {
        this.annotatedTypes = annotatedTypes;
        this.annotatedTypeSource = annotatedTypeSource;
        this.vetoedClasses = vetoedClasses;
        this.classBeanMap = classBeanMap;
        this.producerFields = producerFields;
        this.producerMethodBeanMap = producerMethodBeanMap;
        this.beans = beans;
        this.observers = observers;
        this.allDisposalBeans = allDisposalBeans;
        this.resolvedDisposalBeans = resolvedDisposalBeans;
        this.decorators = decorators;
        this.interceptors = interceptors;
        this.ejbDescriptors = ejbDescriptors;
        this.disposalMethodResolver = new TypeSafeDisposerResolver(manager, allDisposalBeans);
        this.classTransformer = manager.getServices().get(ClassTransformer.class);
        this.newManagedBeanClasses = newManagedBeanClasses;
        this.newSessionBeanDescriptorsFromInjectionPoint = newSessionBeanDescriptorsFromInjectionPoint;
        this.manager = manager;
    }

    protected BeanDeployerEnvironment(EjbDescriptors ejbDescriptors, BeanManagerImpl manager) {
        this(new HashSet(), new HashMap(), new HashSet(), new HashMap(), new HashSet(), new HashMap(), new HashSet(), new HashSet(), new HashSet(), new HashSet(), new HashSet(), new HashSet(), ejbDescriptors, new HashSet(), new HashMap(), manager);
    }

    public void addAnnotatedType(AnnotatedType<?> annotatedType) {
        this.annotatedTypes.add(annotatedType);
    }

    public void addAnnotatedTypes(Collection<AnnotatedType<?>> annotatedTypes) {
        this.annotatedTypes.addAll(annotatedTypes);
    }

    public void addSyntheticAnnotatedType(SlimAnnotatedType<?> annotatedType, Extension extension) {
        this.addAnnotatedType(annotatedType);
        this.annotatedTypeSource.put(annotatedType, extension);
    }

    public Set<AnnotatedType<?>> getAnnotatedTypes() {
        return Collections.unmodifiableSet(this.annotatedTypes);
    }

    public Extension getAnnotatedTypeSource(AnnotatedType<?> annotatedType) {
        return this.annotatedTypeSource.get(annotatedType);
    }

    public void removeAnnotatedType(AnnotatedType<?> annotatedType) {
        this.annotatedTypes.remove(annotatedType);
    }

    public void removeAnnotatedTypes(Collection<AnnotatedType<?>> annotatedTypes) {
        for (AnnotatedType<?> annotatedType : annotatedTypes) {
            this.removeAnnotatedType(annotatedType);
        }
    }

    public void vetoJavaClass(Class<?> javaClass) {
        this.vetoedClasses.add(javaClass);
    }

    public void vetoAnnotatedType(AnnotatedType<?> annotatedType) {
        if (annotatedType instanceof BackedAnnotatedType) {
            this.vetoJavaClass(annotatedType.getJavaClass());
        }
        this.removeAnnotatedType(annotatedType);
    }

    public boolean isVetoed(Class<?> clazz) {
        return this.vetoedClasses.contains(clazz);
    }

    public Set<EnhancedAnnotatedType<?>> getNewManagedBeanClasses() {
        return this.newManagedBeanClasses;
    }

    public Map<InternalEjbDescriptor<?>, EnhancedAnnotatedType<?>> getNewSessionBeanDescriptorsFromInjectionPoint() {
        return this.newSessionBeanDescriptorsFromInjectionPoint;
    }

    public <X, T> ProducerMethod<X, T> getProducerMethod(EnhancedAnnotatedMethod<X, T> method) {
        WeldMethodKey<T, X> key = new WeldMethodKey<T, X>(method);
        ProducerMethod<?, ?> bean = this.producerMethodBeanMap.get(key);
        if (bean != null) {
            bean.initialize(this);
        }
        return (ProducerMethod)Reflections.cast(bean);
    }

    public AbstractClassBean<?> getClassBean(AnnotatedType<?> clazz) {
        AbstractClassBean<?> bean;
        AnnotatedType<Object> type = clazz;
        if (clazz instanceof EnhancedAnnotatedType) {
            type = ((EnhancedAnnotatedType)Reflections.cast(clazz)).slim();
        }
        if ((bean = this.classBeanMap.get(type)) != null) {
            bean.preInitialize();
        }
        return bean;
    }

    public void addProducerMethod(ProducerMethod<?, ?> bean) {
        this.producerMethodBeanMap.put(WeldMethodKey.of(bean.getEnhancedAnnotated()), bean);
        this.addAbstractBean(bean);
    }

    public void addProducerField(ProducerField<?, ?> bean) {
        this.producerFields.add(bean);
        this.addAbstractBean(bean);
    }

    public void addExtension(ExtensionBean bean) {
        this.beans.add(bean);
    }

    public void addBuiltInBean(AbstractBuiltInBean<?> bean) {
        this.beans.add(bean);
    }

    protected void addAbstractClassBean(AbstractClassBean<?> bean) {
        if (!(bean instanceof NewBean)) {
            this.classBeanMap.put((AnnotatedType<?>)bean.getAnnotated(), bean);
        }
        this.addAbstractBean(bean);
    }

    public void addManagedBean(ManagedBean<?> bean) {
        this.addAbstractClassBean(bean);
    }

    public void addSessionBean(SessionBean<?> bean) {
        this.addAbstractClassBean(bean);
    }

    public void addNewManagedBean(NewManagedBean<?> bean) {
        this.beans.add(bean);
    }

    public void addNewSessionBean(NewSessionBean<?> bean) {
        this.beans.add(bean);
    }

    protected void addAbstractBean(AbstractBean<?, ?> bean) {
        this.beans.add(bean);
    }

    public void addDecorator(DecoratorImpl<?> bean) {
        this.decorators.add(bean);
    }

    public void addInterceptor(InterceptorImpl<?> bean) {
        this.interceptors.add(bean);
    }

    public void addDisposesMethod(DisposalMethod<?, ?> bean) {
        this.allDisposalBeans.add(bean);
        this.addNewBeansFromInjectionPoints(bean);
    }

    public void addObserverMethod(ObserverInitializationContext<?, ?> observerInitializer) {
        this.observers.add(observerInitializer);
        this.addNewBeansFromInjectionPoints(observerInitializer.getObserver().getNewInjectionPoints());
    }

    public void addNewBeansFromInjectionPoints(AbstractBean<?, ?> bean) {
        this.addNewBeansFromInjectionPoints(bean.getNewInjectionPoints());
    }

    public void addNewBeansFromInjectionPoints(Set<WeldInjectionPoint<?, ?>> newInjectionPoints) {
        for (WeldInjectionPoint<?, ?> injectionPoint : newInjectionPoints) {
            Class rawType = Reflections.getRawType(injectionPoint.getType());
            if (Instance.class.equals(rawType) || Event.class.equals(rawType)) continue;
            New _new = injectionPoint.getQualifier(New.class);
            if (_new.value().equals(New.class)) {
                this.addNewBeanFromInjecitonPoint(rawType, injectionPoint.getType());
                continue;
            }
            this.addNewBeanFromInjecitonPoint(_new.value(), _new.value());
        }
    }

    private void addNewBeanFromInjecitonPoint(Class<?> rawType, Type baseType) {
        if (this.getEjbDescriptors().contains(rawType)) {
            InternalEjbDescriptor<?> descriptor = this.getEjbDescriptors().getUnique(rawType);
            this.newSessionBeanDescriptorsFromInjectionPoint.put(descriptor, this.classTransformer.getEnhancedAnnotatedType(rawType, baseType));
        } else {
            this.newManagedBeanClasses.add(this.classTransformer.getEnhancedAnnotatedType(rawType, baseType));
        }
    }

    public Set<? extends RIBean<?>> getBeans() {
        return Collections.unmodifiableSet(this.beans);
    }

    public Set<DecoratorImpl<?>> getDecorators() {
        return Collections.unmodifiableSet(this.decorators);
    }

    public Set<InterceptorImpl<?>> getInterceptors() {
        return Collections.unmodifiableSet(this.interceptors);
    }

    public Set<ObserverInitializationContext<?, ?>> getObservers() {
        return Collections.unmodifiableSet(this.observers);
    }

    public Set<DisposalMethod<?, ?>> getUnresolvedDisposalBeans() {
        HashSet beans = new HashSet(this.allDisposalBeans);
        beans.removeAll(this.resolvedDisposalBeans);
        return Collections.unmodifiableSet(beans);
    }

    public EjbDescriptors getEjbDescriptors() {
        return this.ejbDescriptors;
    }

    public <X> Set<DisposalMethod<X, ?>> resolveDisposalBeans(Set<Type> types, Set<Annotation> qualifiers, AbstractClassBean<X> declaringBean) {
        Set beans = (Set)Reflections.cast(this.disposalMethodResolver.resolve(new ResolvableBuilder(this.manager).addTypes(types).addQualifiers(qualifiers).setDeclaringBean(declaringBean).create(), true));
        this.resolvedDisposalBeans.addAll(beans);
        return Collections.unmodifiableSet(beans);
    }

    public void vetoBean(AbstractBean<?, ?> bean) {
        this.beans.remove(bean);
        if (bean instanceof AbstractClassBean) {
            this.classBeanMap.remove(bean.getAnnotated());
            if (bean instanceof InterceptorImpl) {
                this.interceptors.remove(bean);
            }
            if (bean instanceof DecoratorImpl) {
                this.decorators.remove(bean);
            }
        }
        if (bean instanceof ProducerMethod) {
            this.producerMethodBeanMap.remove(WeldMethodKey.of(((ProducerMethod)Reflections.cast(bean)).getEnhancedAnnotated()));
        }
        if (bean instanceof ProducerField) {
            this.producerFields.remove(bean);
        }
    }

    public Map<AnnotatedType<?>, AbstractClassBean<?>> getClassBeanMap() {
        return Collections.unmodifiableMap(this.classBeanMap);
    }

    public Map<WeldMethodKey<?, ?>, ProducerMethod<?, ?>> getProducerMethodBeanMap() {
        return Collections.unmodifiableMap(this.producerMethodBeanMap);
    }

    public Set<ProducerField<?, ?>> getProducerFields() {
        return Collections.unmodifiableSet(this.producerFields);
    }

    public void cleanup() {
        this.annotatedTypes.clear();
        this.annotatedTypeSource.clear();
        this.vetoedClasses.clear();
        this.classBeanMap.clear();
        this.producerMethodBeanMap.clear();
        this.allDisposalBeans.clear();
        this.resolvedDisposalBeans.clear();
        this.beans.clear();
        this.decorators.clear();
        this.interceptors.clear();
        this.observers.clear();
        this.disposalMethodResolver.clear();
        this.newManagedBeanClasses.clear();
        this.newSessionBeanDescriptorsFromInjectionPoint.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class WeldMethodKey<T, X> {
        final EnhancedAnnotatedMethod<T, X> method;

        static <T, X> WeldMethodKey<T, X> of(EnhancedAnnotatedMethod<T, X> method) {
            return new WeldMethodKey<T, X>(method);
        }

        WeldMethodKey(EnhancedAnnotatedMethod<T, X> meth) {
            this.method = meth;
        }

        public boolean equals(Object other) {
            if (other instanceof WeldMethodKey) {
                WeldMethodKey o = (WeldMethodKey)other;
                return AnnotatedTypes.compareAnnotatedCallable(this.method, o.method);
            }
            return false;
        }

        public int hashCode() {
            return ((Method)this.method.getJavaMember()).hashCode();
        }
    }
}

